/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;

public class FaRealCardCodeRule4BarcodeValidator
extends AbstractValidator {
    public void validate() {
        this.checkDispatchCardBarcode();
    }

    private void checkDispatchCardBarcode() {
        ArrayList<Long> updateRealCardId = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            long realCardId;
            DynamicObject realCard = dataEntity.getDataEntity();
            String sourceFlag = realCard.getString("sourceflag");
            if (!SourceFlagEnum.DISPATCH.name().equals(sourceFlag) || (realCardId = realCard.getLong("id")) == 0L) continue;
            updateRealCardId.add(realCardId);
        }
        DynamicObjectCollection realCardsFromDb = QueryServiceHelper.query((String)"fa_card_real", (String)"id, barcode", (QFilter[])new QFilter("id", "in", updateRealCardId).toArray());
        Map<Long, String> barcodeMap = realCardsFromDb.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("barcode")));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            long realCardId = realCard.getLong("id");
            if (!barcodeMap.containsKey(realCardId)) continue;
            String barcode = realCard.getString("barcode");
            String barcodeFromDb = barcodeMap.get(realCardId);
            if (barcodeFromDb.equals(barcode)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u5165\u7684\u5361\u7247\u4e0d\u5141\u8bb8\u4fee\u6539\u6761\u5f62\u7801\u3002", (String)"FaRealCardCodeRule4BarcodeValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }
}

