/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaGenBigDataUtils;

public class FaRealCardGenBigData
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FaRealCardGenBigData.class);
    private static final int maxCountes = 5000;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long startTime = System.currentTimeMillis();
        DynamicObject[] cardentities = e.getDataEntities();
        if (cardentities.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u5f20\u590d\u5236\u7684\u5361\u7247", (String)"FaRealCardGenBigData_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        DynamicObject card = cardentities[0];
        card = BusinessDataServiceHelper.loadSingle((Object)card.getLong("id"), (String)"fa_card_real");
        BigDecimal assetamount = card.getBigDecimal("assetamount");
        int totalAmount = assetamount.intValue();
        int job_mod = totalAmount % 5000;
        int jobs = 0;
        jobs = job_mod == 0 ? totalAmount / 5000 : totalAmount / 5000 + 1;
        List books = FaBizUtils.getEnableAsstBooksByOrg((Long)card.getLong("org.id"));
        for (int i = 1; i <= jobs; ++i) {
            int beginIndex = 5000 * (i - 1) + 1;
            int endIndex = 5000 * i;
            if (endIndex > totalAmount) {
                endIndex = totalAmount;
            }
            FaGenBigDataUtils.genCards((DynamicObject)card, null, (int)beginIndex, (int)endIndex, (int)totalAmount, (List)books);
        }
        long usedTime = System.currentTimeMillis() - startTime;
        logger.info(String.format("------\u7528\u65f6\uff1a\u5168\u90e8\u5b8c\u6210\u590d\u5236  %s,\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247\uff0c\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%sms\uff01", card.getString("number"), totalAmount, usedTime));
    }
}

