/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.opplugin.realcard.FaAbstractRealCardOp;
import kd.fi.fa.opplugin.realcard.FaRealCardSaveValidator;
import kd.fi.fa.opplugin.validator.FaProductLineValidator;

public class FaRealCardSaveOp
extends FaAbstractRealCardOp {
    private static final Log log = LogFactory.getLog(FaRealCardSaveOp.class);

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaRealCardSaveValidator());
        e.addValidator((AbstractValidator)new FaProductLineValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.setBaseInfoForAddNew(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        HashSet<DynamicObject> srcEntityName4InitLease = new HashSet<DynamicObject>(dynamicObjects.length);
        for (DynamicObject dataEntity : dynamicObjects) {
            Object srcBillEntityName = dataEntity.get("srcbillentityname");
            if ("fa_lease_contract_init".equals(srcBillEntityName)) {
                srcEntityName4InitLease.add(dataEntity);
            } else if (dataEntity.getBoolean("initialcard")) {
                dataEntity.set("sourceflag", (Object)SourceFlagEnum.INITIAL);
            }
            if (!dataEntity.getBoolean("initialcard") || !dataEntity.getBoolean("mergedcard")) continue;
            dataEntity.set("bizstatus", (Object)BizStatusEnum.READY);
        }
        if (!srcEntityName4InitLease.isEmpty()) {
            FaRealCardSaveOp.addLeaseContractLinkRealCard(srcEntityName4InitLease, "fa_card_real");
        }
    }

    public static void addLeaseContractLinkRealCard(Set<DynamicObject> realCard, String entryName) {
        Map<Long, Long> cardId2LeaseId = realCard.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("srcbillid")));
        ConvertDataService reader = new ConvertDataService();
        TableDefine leaseTableDefine = reader.loadTableDefine("fa_lease_contract", "fa_lease_contract");
        TableDefine realCardTableDefine = reader.loadTableDefine(entryName, entryName);
        Long leaseTableId = leaseTableDefine.getTableId();
        Long realCardTableId = realCardTableDefine.getTableId();
        try {
            SqlBuilder sqlLk = new SqlBuilder();
            sqlLk.append("select fid, fsbillid from t_fa_card_real_lk ", new Object[0]);
            sqlLk.append("where fstableid = ?", new Object[]{leaseTableId});
            sqlLk.appendIn(" and fid ", cardId2LeaseId.keySet().toArray());
            DataSet dataSet = DB.queryDataSet((String)"addLeaseContractLinkRealCard_query", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlLk);
            HashMap<Long, Long> cardId2LeaseId4DB = new HashMap<Long, Long>(cardId2LeaseId.size());
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                cardId2LeaseId4DB.put(next.getLong("fid"), next.getLong("fsbillid"));
            }
            HashMap<Long, Long> addLinkData = new HashMap<Long, Long>(cardId2LeaseId.size());
            for (Map.Entry<Long, Long> entry : cardId2LeaseId.entrySet()) {
                Long realCardId = entry.getKey();
                long leaseId = entry.getValue();
                if (cardId2LeaseId4DB.containsKey(realCardId) && leaseId == (Long)cardId2LeaseId4DB.get(realCardId)) continue;
                addLinkData.put(realCardId, leaseId);
            }
            if (!addLinkData.isEmpty()) {
                String lkSql = "insert into t_fa_card_real_lk(fpkid, fid, fseq, fsbillid, fstableid, fsid, fassetqty_old, fassetqty) values (?, ?, ?, ?, ?, ?, ?, ?)";
                String trackSql = "insert into t_botp_billtracker(fid, fstableid, fsbillid, fttableid, ftbillid, fcreatetime) values (?, ?, ?, ?, ?, ?)";
                long[] lkIds = DB.genLongIds((String)"t_fa_card_real_lk", (int)addLinkData.size());
                long[] trackIds = DB.genLongIds((String)"t_botp_billtracker", (int)addLinkData.size());
                ArrayList<Object[]> lkParamList = new ArrayList<Object[]>(addLinkData.size());
                ArrayList<Object[]> trackParamList = new ArrayList<Object[]>(addLinkData.size());
                int i = 0;
                for (Map.Entry entry : addLinkData.entrySet()) {
                    Object[] lkParam = new Object[8];
                    Long realCardId = (Long)entry.getKey();
                    Long leaseId = (Long)entry.getValue();
                    lkParam[0] = lkIds[i];
                    lkParam[1] = realCardId;
                    lkParam[2] = 1;
                    lkParam[3] = leaseId;
                    lkParam[4] = leaseTableId;
                    lkParam[5] = leaseId;
                    lkParam[6] = 0;
                    lkParam[7] = 0;
                    lkParamList.add(lkParam);
                    Object[] trackParam = new Object[]{trackIds[i], leaseTableId, leaseId, realCardTableId, realCardId, new Date()};
                    trackParamList.add(trackParam);
                    ++i;
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)lkSql, lkParamList);
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)trackSql, trackParamList);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"FaRealCardSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }
}

