/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaRealCardValidator;
import kd.fi.fa.opplugin.FaRealCheckClearApplyValidator;
import kd.fi.fa.opplugin.realcard.FaAbstractRealCardOp;
import kd.fi.fa.opplugin.realcard.FaRealCardUnAuditValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaRealCardUnAuditOp
extends FaAbstractRealCardOp {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaRealCardUnAuditValidator());
        e.addValidator((AbstractValidator)new FaRealCardValidator());
        e.addValidator((AbstractValidator)new FaRealCheckClearApplyValidator(this.billEntityType));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperateOption option = this.getOption();
        boolean assetCardOperate = option.containsVariable("assetCardOperate");
        Set<Object> oriRealCardIds = this.findOriRealCardIds(FaOpUtils.getDataEntities(e));
        this.deleteOriRealCards(oriRealCardIds);
        if (!assetCardOperate) {
            this.deleteFinCardOnly(e, oriRealCardIds);
        }
        super.restoreInitFields(e);
    }

    private void deleteFinCardOnly(BeginOperationTransactionArgs e, Set<Object> oriRealCardIds) {
        try {
            List<DynamicObject> bills = FaOpUtils.getDataEntities(e);
            Set realIdSet = bills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            realIdSet.addAll(oriRealCardIds);
            DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id,realcard", (QFilter[])new QFilter("realcard", "in", realIdSet).toArray());
            Object[] realCardPks = finCards.stream().map(v -> v.getLong("realcard")).toArray();
            FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(realCardPks, BizStatusEnum.ADD);
            HashMap<Long, Long> finRealMap = new HashMap<Long, Long>(finCards.size());
            for (DynamicObject finCard : finCards) {
                finRealMap.put(finCard.getLong("id"), finCard.getLong("realcard"));
            }
            if (finRealMap.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignoreAssetBookStatus", "true");
                OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_card_fin", (Object[])finRealMap.keySet().toArray(), (OperateOption)option);
                FaCommonUtils.handleOperationResult((OperationResult)result);
            }
            IDataEntityType type = FaRealCardDaoFactory.getBaseInstance().getEmptyDynamicObject().getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
            cacheManager.removeByPrimaryKey(this.getOperationResult().getSuccessPkIds().toArray());
        }
        catch (Exception ex) {
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", String.format(ResManager.loadKDString((String)"%s\r\n\u5220\u9664\u8d22\u52a1\u5361\u7247\u5931\u8d25.", (String)"FaRealCardUnAuditOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
        }
    }

    private Set<Object> findOriRealCardIds(List<DynamicObject> bills) {
        HashSet masterIds = new HashSet(bills.size());
        bills.stream().forEach(t -> masterIds.add(t.getLong("masterid")));
        DynamicObjectCollection oriRealCards = QueryServiceHelper.query((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"id"}), (QFilter[])new QFilter[]{new QFilter("masterid", "in", masterIds), new QFilter("isbak", "=", (Object)Boolean.TRUE), new QFilter("originaldata", "=", (Object)Boolean.TRUE)});
        HashSet<Object> oriRealCardIds = new HashSet<Object>(oriRealCards.size());
        oriRealCards.stream().forEach(t -> oriRealCardIds.add(t.get("id")));
        return oriRealCardIds;
    }

    private void deleteOriRealCards(Set<Object> oriRealCardIds) {
        DeleteServiceHelper.delete((String)"fa_card_real", (QFilter[])new QFilter[]{new QFilter("id", "in", oriRealCardIds)});
    }
}

