/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depretask.DepreStatusEnum2;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class CommonCheckUtils {
    public static Set<Long> existsFaReStartRealBill(Long periodId, Long orgId, Set<Long> realCardIdSet) {
        if (Objects.isNull(periodId) || Objects.isNull(orgId) || Objects.isNull(realCardIdSet) || realCardIdSet.isEmpty()) {
            return new HashSet<Long>(0);
        }
        String realCardIdField = Fa.dot((String[])new String[]{"restartentity", "realcard", "id"});
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodIdFilter = new QFilter("restartperiod", "=", (Object)periodId);
        QFilter realCardIdFilter = new QFilter(realCardIdField, "in", realCardIdSet);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fa_restartrealbill", (String)realCardIdField, (QFilter[])new QFilter[]{orgFilter, periodIdFilter, realCardIdFilter});
        HashSet<Long> result = new HashSet<Long>(16);
        for (DynamicObject dynObj : dynamicObjectCollection) {
            long realCardId = dynObj.getLong(realCardIdField);
            result.add(realCardId);
        }
        return result;
    }

    public static String checkDepSum(Long orgId, String reStartRealBillNo, Date reStartDate) {
        DynamicObjectCollection assetBookDynObjCollection = FaBizUtils.getAsstBookFieldsByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"id", "periodtype"}));
        for (DynamicObject assetBookDynObj : assetBookDynObjCollection) {
            boolean enableSumMutVoucher;
            long periodTypeId = assetBookDynObj.getLong("periodtype");
            DynamicObject reStartPeriod = PeriodUtil.getPeriodFullObjByDate((Date)reStartDate, (long)periodTypeId);
            Long reStartPeriodId = reStartPeriod.getLong("id");
            boolean depSumHasVoucher = CommonCheckUtils.isDepSumHasVoucher(orgId, reStartPeriodId);
            if (!depSumHasVoucher || (enableSumMutVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)Boolean.FALSE))) continue;
            return String.format(ResManager.loadKDString((String)"\u91cd\u542f\u5355\u5355\u636e\uff1a%1$s\uff0c\u91cd\u542f\u5931\u8d25\uff0c\u672a\u5f00\u542f\u7cfb\u7edf\u53c2\u6570\uff1a\u5141\u8bb8\u540c\u671f\u751f\u6210\u591a\u4e2a\u6298\u65e7\u6c47\u603b\u3002", (String)"FaReStartRealBillAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), reStartRealBillNo);
        }
        return null;
    }

    private static boolean isDepSumHasVoucher(Long orgId, Long reStartPeriodId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)reStartPeriodId);
        DynamicObjectCollection depSumList = QueryServiceHelper.query((String)"fa_depre_sum", (String)"id", (QFilter[])new QFilter[]{orgFilter, periodFilter});
        List depSumIds = depSumList.stream().map(v -> v.get("id")).collect(Collectors.toList());
        return FaDepreUtil.hashVouncherV2(depSumIds, (String)"fa_depre_sum");
    }

    private DepreStatusEnum2 getDepStatusEnum(long mainAssetBookId, Long reStartPeriodId) {
        ArrayList<QFilter> faDisDepLogQFilterList = new ArrayList<QFilter>(5);
        faDisDepLogQFilterList.add(new QFilter("assetbook", "=", (Object)mainAssetBookId));
        faDisDepLogQFilterList.add(new QFilter("period", "=", (Object)reStartPeriodId));
        faDisDepLogQFilterList.add(new QFilter("fromentityname", "=", (Object)"fa_new_depre"));
        faDisDepLogQFilterList.add(new QFilter("isnew", "=", (Object)Boolean.TRUE));
        faDisDepLogQFilterList.add(new QFilter("ismanual", "=", (Object)Boolean.TRUE));
        String selectFields = "status";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fa_disdepre_log", (String)selectFields, (QFilter[])faDisDepLogQFilterList.toArray(new QFilter[0]));
        if (Objects.isNull(dynamicObject)) {
            return DepreStatusEnum2.INIT;
        }
        String status = dynamicObject.getString("status");
        return DepreStatusEnum2.fromString((String)status);
    }
}

