/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill.validators;

import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.restartrealbill.utils.CommonCheckUtils;
import kd.fi.fa.utils.FaOpUtils;

public class FaReStartRealBillAuditValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, DynamicObject> orgId2MainBookMap = new HashMap<Long, DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String bookNames;
            DynamicObject reStartRealBill = dataEntity.getDataEntity();
            DynamicObject orgDynObj = reStartRealBill.getDynamicObject("org");
            Long orgId = orgDynObj.getLong("id");
            String orgName = orgDynObj.getString("name");
            String reStartRealBillNo = reStartRealBill.getString("billno");
            Date reStartDate = reStartRealBill.getDate("restartdate");
            DynamicObject mainAssetBookDynObj = (DynamicObject)orgId2MainBookMap.get(orgId);
            if (Objects.isNull(mainAssetBookDynObj) && Objects.nonNull(mainAssetBookDynObj = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"id", "periodtype"})))) {
                orgId2MainBookMap.put(orgId, mainAssetBookDynObj);
            }
            if (Objects.isNull(mainAssetBookDynObj)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FaReStartRealBillAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), orgName));
            }
            String checkResult = CommonCheckUtils.checkDepSum(orgId, reStartRealBillNo, reStartDate);
            if (checkResult != null) {
                this.addErrorMessage(dataEntity, checkResult);
            }
            if ((bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "restartdate")).isEmpty()) continue;
            String msgCaption = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"FaReStartRealBillAuditValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format("%s:%s\u3002", msgCaption, bookNames));
        }
    }
}

