/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill.validators;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.opplugin.restartrealbill.utils.CommonCheckUtils;
import kd.fi.fa.utils.FaOpUtils;

public class FaReStartRealBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object reStartRealBillPkValue;
            boolean hasVoucher;
            DynamicObject reStartRealBill = dataEntity.getDataEntity();
            String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "restartdate");
            if (!bookNames.isEmpty()) {
                String msgCaption = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"FaReStartRealBillUnAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format("%s:%s\u3002", msgCaption, bookNames));
            }
            if (hasVoucher = FaDepreUtil.hashVouncherV2(Collections.singletonList(reStartRealBillPkValue = reStartRealBill.getPkValue()), (String)"fa_restartrealbill")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u91cd\u542f\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FaReStartRealBillUnAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            String reStartRealBillNo = reStartRealBill.getString("billno");
            Date reStartDate = reStartRealBill.getDate("restartdate");
            DynamicObject orgDynObj = reStartRealBill.getDynamicObject("org");
            Long orgId = orgDynObj.getLong("id");
            String checkResult = CommonCheckUtils.checkDepSum(orgId, reStartRealBillNo, reStartDate);
            if (checkResult != null) {
                this.addErrorMessage(dataEntity, checkResult);
            }
            List realCards = reStartRealBill.getDynamicObjectCollection("restartentity").stream().map(v -> v.getDynamicObject("realcard")).collect(Collectors.toList());
            Set realCardIds = realCards.stream().map(v -> v.get("id")).collect(Collectors.toSet());
            Optional optional = new FutureBizChecker(reStartRealBill.getPkValue(), (Object)orgId, realCardIds, reStartRealBill.getDate("auditdate"), BusyTypeDetailEnum.REAL_FIN_CHG).checkWhenun();
            if (optional.isPresent()) {
                String result = String.format(ResManager.loadKDString((String)"\u91cd\u542f\u5355\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"FaReStartRealBillUnAuditValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), optional.get());
                this.addMessage(dataEntity, result, ErrorLevel.Error);
            }
            try {
                FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "restartentity", "realcard.masterid", "fa_restartrealbill");
            }
            catch (Exception e) {
                this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
            }
        }
    }
}

