/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.assetsplit.FaSplitBillAndCardHelper;
import kd.fi.fa.business.clear.ClearBillHDGenerator;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.convertor.SplitBill2ClearBillConvertor;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.operate.IFaOpHandler;
import kd.fi.fa.business.po.FaCardVersionParameter;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaShareOpUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.split.FaSplitBillCodeRuleValidator;
import kd.fi.fa.opplugin.split.FaSplitCardBillAssetCardOp;
import kd.fi.fa.opplugin.split.FaSplitCardBillAuditValidator;
import kd.fi.fa.opplugin.split.FaSplitCardBillSubmitCompFieldValidator;

public class FaSplitCardBillAuditOp
extends AbstractBizCtrOperationServicePlugIn
implements IFaOpHandler {
    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_real_base");
    private static final Log logger = LogFactory.getLog(FaSplitCardBillAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        MainEntityType splitEntityType = EntityMetadataCache.getDataEntityType((String)"fa_assetsplitbill");
        EntryProp befEntryProp = (EntryProp)splitEntityType.getProperties().get((Object)"assetsplitentry");
        DataEntityPropertyCollection befProps = befEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        for (IDataEntityProperty befProp : befProps) {
            fieldKeys.add(befProp.getName());
        }
        EntryProp aftEntryProp = (EntryProp)befProps.get((Object)"subassetsplitentry");
        DataEntityPropertyCollection aftProps = aftEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        for (IDataEntityProperty aftProp : aftProps) {
            fieldKeys.add(aftProp.getName());
        }
        fieldKeys.add("org");
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("splittype");
        fieldKeys.add("splitdate");
        fieldKeys.add("splitperiod");
        fieldKeys.add("split_realcard");
        fieldKeys.add("assetsplitentry");
        fieldKeys.add("biztype");
        fieldKeys.add("voucherflag");
        fieldKeys.add("splitqty");
        fieldKeys.add("isautocarry");
        fieldKeys.add(Fa.dot((String[])new String[]{"split_realcard", "bizstatus"}));
        fieldKeys.add("ismanualcode");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaSplitCardBillAuditValidator());
        e.addValidator((AbstractValidator)new FaSplitCardBillSubmitCompFieldValidator());
        e.addValidator((AbstractValidator)new FaSplitBillCodeRuleValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("FaSplitCardBillAuditOpBeginLog\u8fdb\u5165Begin\u65b9\u6cd5");
        String operationKey = e.getOperationKey();
        HashMap<String, BeginOperationTransactionArgs> otherParams = new HashMap<String, BeginOperationTransactionArgs>(1, 1.0f);
        otherParams.put("beginArgs", e);
        FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock((String)operationKey, (String)"fa_assetsplitbill", (DynamicObject[])e.getDataEntities(), otherParams, (IFaOpHandler)this);
    }

    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        FaSplitCardBillAssetCardOp splitCardOp = new FaSplitCardBillAssetCardOp("audit", true, new FaSplitBillAndCardHelper());
        ArrayList<DynamicObject> needNoGenVoucherBills = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            FaModiRealStatsUtils.update_splitbill_bizStatus((DynamicObject)bill, (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.SPLIT);
            String errorMsg = splitCardOp.splitConvertCardProcess(bill);
            if (errorMsg != null) {
                throw new KDBizException(errorMsg);
            }
            this.updateSplitCard(bill);
            this.writeBackAftSplitEntry(bill);
            boolean isNeedVoucher = this.getVoucherFlag(bill);
            if (isNeedVoucher) {
                bill.set("voucherflag", (Object)"B");
            } else {
                needNoGenVoucherBills.add(bill);
            }
            this.generateClearBill(bill);
        }
        this.switchOutDynamic(Arrays.stream(dataEntities).collect(Collectors.toSet()));
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (!needNoGenVoucherBills.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            OperationServiceHelper.executeOperate((String)"nogenvoucher", (String)"fa_assetsplitbill", (DynamicObject[])needNoGenVoucherBills.toArray(new DynamicObject[0]), (OperateOption)option);
        }
    }

    private boolean getVoucherFlag(DynamicObject splitBill) {
        Map needGenVoucherFields4Card = new FaSplitBillAndCardHelper().getNeedGenVoucherFields4Card();
        Set faFinCardNeedGenVoucherFieldSet = (Set)needGenVoucherFields4Card.get("fa_card_fin");
        logger.info("\u8d22\u52a1\u5361\u7247\u9700\u8981\u751f\u6210\u51ed\u8bc1\u7684\u5b57\u6bb5: {}", (Object)faFinCardNeedGenVoucherFieldSet);
        Set faRealCardNeedGenVoucherFieldSet = (Set)needGenVoucherFields4Card.get("fa_card_real");
        logger.info("\u5b9e\u7269\u5361\u7247\u9700\u8981\u751f\u6210\u51ed\u8bc1\u7684\u5b57\u6bb5: {}", (Object)faRealCardNeedGenVoucherFieldSet);
        if (!faFinCardNeedGenVoucherFieldSet.isEmpty() || !faRealCardNeedGenVoucherFieldSet.isEmpty()) {
            DynamicObjectCollection befEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
            HashSet<Long> aftRealCardIdSet = new HashSet<Long>(16);
            HashSet<Long> aftFaFinCardIdSet = new HashSet<Long>(16);
            boolean realHasNoQuery = true;
            for (DynamicObject bef : befEntry) {
                DynamicObjectCollection aftSplitEntry = bef.getDynamicObjectCollection("subassetsplitentry");
                for (DynamicObject aft : aftSplitEntry) {
                    long faRealCardId = aft.getLong(Fa.id((String)"aft_realcard"));
                    long faFinCardId = aft.getLong(Fa.id((String)"aft_fincard"));
                    aftRealCardIdSet.add(faRealCardId);
                    aftFaFinCardIdSet.add(faFinCardId);
                }
                DataSet aftRealCardDataSet = null;
                if (!aftRealCardIdSet.isEmpty() && !faRealCardNeedGenVoucherFieldSet.isEmpty() && realHasNoQuery) {
                    String realCardSelectFields = String.join((CharSequence)",", faRealCardNeedGenVoucherFieldSet);
                    aftRealCardDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_card_real", (String)realCardSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", aftRealCardIdSet)}, null);
                    realHasNoQuery = false;
                }
                if (this.isGenVoucher(aftRealCardDataSet)) {
                    return true;
                }
                DataSet aftFaFinCardDataSet = null;
                if (!aftFaFinCardIdSet.isEmpty() && !faFinCardNeedGenVoucherFieldSet.isEmpty()) {
                    String faFinCardSelectFields = String.join((CharSequence)",", faFinCardNeedGenVoucherFieldSet);
                    aftFaFinCardDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_card_fin", (String)faFinCardSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", aftFaFinCardIdSet)}, null);
                }
                if (!this.isGenVoucher(aftFaFinCardDataSet)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGenVoucher(DataSet aftDataSet) {
        if (Objects.isNull(aftDataSet)) {
            return Boolean.FALSE;
        }
        DataSet distinct = aftDataSet.distinct();
        int i = 0;
        while (distinct.hasNext()) {
            distinct.next();
            if (++i <= 1) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void writeBackAftSplitEntry(DynamicObject bill) {
        DynamicObjectCollection aftSplitEntry = ((DynamicObject)bill.getDynamicObjectCollection("assetsplitentry").get(0)).getDynamicObjectCollection("subassetsplitentry");
        Set newRealCardIds = aftSplitEntry.stream().filter(v -> !v.getBoolean("issourcecard")).map(v -> v.getLong(Fa.id((String)"aft_realcard"))).collect(Collectors.toSet());
        DynamicObjectCollection newCards = QueryServiceHelper.query((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"id", "billno", "number", "barcode", "assetname"}), (QFilter[])new QFilter[]{new QFilter("id", "in", newRealCardIds)});
        Map<Long, DynamicObject> id2Card = newCards.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        DynamicObjectCollection befEntry = bill.getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject bef : befEntry) {
            DynamicObjectCollection aftEntry = bef.getDynamicObjectCollection("subassetsplitentry");
            for (DynamicObject aft : aftEntry) {
                if (aft.getBoolean("issourcecard")) continue;
                long realCardId = aft.getLong(Fa.id((String)"aft_realcard"));
                DynamicObject realCard = id2Card.get(realCardId);
                if (realCard == null) {
                    logger.error("\u62c6\u5206\u5355\u5ba1\u6838\u540e\u5361\u7247\u627e\u4e0d\u5230\uff0c\u5177\u4f53\u64cd\u4f5ctraceId\u4e3a\uff1a" + RequestContext.get().getTraceId());
                    logger.error("\u672c\u6b21\u62c6\u5206\u65b0\u589e\u5361\u7247id\u96c6\u5408\uff1a" + newRealCardIds.toString());
                    throw new KDBizException(ResManager.loadKDString((String)"\u62c6\u5206\u5f02\u5e38\uff0c\u62c6\u5206\u65b0\u589e\u5361\u7247\u4e22\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaSplitCardBillAuditOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                aft.set("aft_cardbillno", (Object)realCard.getString("billno"));
                aft.set("aft_cardnumber", (Object)realCard.getString("number"));
                aft.set("aft_barcode", (Object)realCard.getString("barcode"));
                DynamicObject realCardBase = (DynamicObject)this.dataEntityType.createInstance();
                realCardBase.set("id", (Object)realCardId);
                realCardBase.set("assetname", realCard.get("assetname"));
                aft.set("aft_realcard", (Object)realCardBase);
            }
        }
    }

    private void updateSplitCard(DynamicObject bill) {
        Object realPK = bill.getDynamicObject("split_realcard").getPkValue();
        Long orgId = bill.getLong(Fa.id((String)"org"));
        FaCardVersionParameter cardVersionParameter = new FaCardVersionParameter();
        cardVersionParameter.setAccountdate(bill.getDate("splitdate"));
        cardVersionParameter.setSrcbillid(Long.valueOf(bill.getLong("id")));
        cardVersionParameter.setSrcbillentityname("fa_assetsplitbill");
        Map realCardIdMap = FaRealCardDaoFactory.getInstance().copyCards(new Object[]{realPK}, null, orgId, null, cardVersionParameter);
        DynamicObjectCollection befRowDys = bill.getDynamicObjectCollection("assetsplitentry");
        long periodId = bill.getLong(Fa.id((String)"splitperiod"));
        DynamicObject befRealDy = BusinessDataServiceHelper.loadSingle((Object)realPK, (String)"fa_card_real");
        ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>(FaUtils.getInitialCapacity43((int)befRowDys.size()));
        for (DynamicObject befRowDy : befRowDys) {
            this.copyBefRowCard(befRowDy, realCardIdMap, realPK, periodId);
            DynamicObjectCollection aftRowDys = befRowDy.getDynamicObjectCollection("subassetsplitentry");
            long befFinId = befRowDy.getLong(Fa.id((String)"bef_fincard"));
            DynamicObject befFinDy = BusinessDataServiceHelper.loadSingle((Object)befFinId, (String)"fa_card_fin");
            BigDecimal depredAmount = befFinDy.getBigDecimal("depredamount");
            BigDecimal addiDepAmount = befFinDy.getBigDecimal("addidepreamount");
            BigDecimal curDepredAmount = depredAmount.subtract(addiDepAmount);
            for (DynamicObject aftRowDy : aftRowDys) {
                if (!aftRowDy.getBoolean("issourcecard")) continue;
                befRealDy.set("assetamount", (Object)aftRowDy.getBigDecimal("aft_assetamount"));
                befFinDy.set("originalval", (Object)aftRowDy.getBigDecimal("aft_originalval"));
                befFinDy.set("accumdepre", (Object)aftRowDy.getBigDecimal("aft_accumdepre"));
                befFinDy.set("addupyeardepre", (Object)aftRowDy.getBigDecimal("aft_addupyeardepre"));
                befFinDy.set("decval", (Object)aftRowDy.getBigDecimal("aft_decval"));
                befFinDy.set("incometax", (Object)aftRowDy.getBigDecimal("aft_incometax"));
                befFinDy.set("preresidualval", (Object)aftRowDy.getBigDecimal("aft_preresidualval"));
                befFinDy.set("networth", (Object)aftRowDy.getBigDecimal("aft_networth"));
                befFinDy.set("netamount", (Object)aftRowDy.getBigDecimal("aft_netamount"));
                befFinDy.set("originalamount", (Object)aftRowDy.getBigDecimal("aft_originalamount"));
                befFinDy.set("monthorigvalchg", (Object)befFinDy.getBigDecimal("monthorigvalchg").add(aftRowDy.getBigDecimal("aft_monthorigvalchg")));
                befFinDy.set("yearorigvalchg", (Object)befFinDy.getBigDecimal("yearorigvalchg").add(aftRowDy.getBigDecimal("aft_yearorigvalchg")));
                befFinDy.set("monthdeprechg", (Object)befFinDy.getBigDecimal("monthdeprechg").add(aftRowDy.getBigDecimal("aft_monthdeprechg")));
                befFinDy.set("monthaccumdeprechg", (Object)befFinDy.getBigDecimal("monthaccumdeprechg").add(aftRowDy.getBigDecimal("aft_monthaccumdeprechg")));
                befFinDy.set("depredamount", (Object)curDepredAmount);
                befFinDy.set("addidepreamount", (Object)BigDecimal.ZERO);
                befFinDy.set("monthdepre", (Object)BigDecimal.ZERO);
                befFinDy.set("isneeddepre", (Object)"1");
            }
            finCards.add(befFinDy);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{befRealDy});
        FaShareOpUtils.saveFaShare(Collections.singletonList(befRealDy), (String)"fa_card_real");
        SaveServiceHelper.save((DynamicObject[])finCards.toArray(new DynamicObject[0]));
        HashSet<Long> realCardIds = new HashSet<Long>();
        realCardIds.add(bill.getLong(Fa.id((String)"split_realcard")));
        for (DynamicObject befRowDy : befRowDys) {
            long depreUseId = befRowDy.getLong(Fa.id((String)"bef_depreuse"));
            new DepreSplitSum().updateDepreSplit4ChangeBill(orgId, Long.valueOf(depreUseId), realCardIds);
        }
    }

    private void copyBefRowCard(DynamicObject befRowDy, Map<Object, Object> realCardIdMap, Object realPK, long periodId) {
        long depUseId = befRowDy.getLong(Fa.id((String)"bef_depreuse"));
        Object[] realPKs = new Object[]{realPK};
        Map finCardIdMap = FaFinCardDaoFactory.getInstance().copyFinCards(periodId, depUseId, realPKs, null, null, realCardIdMap);
        befRowDy.set(Fa.id((String)"bef_bakrealcard"), realCardIdMap.values().toArray()[0]);
        Map map = (Map)finCardIdMap.get(realPK);
        Long finCardId = (Long)map.get(depUseId);
        befRowDy.set(Fa.id((String)"bef_fincard"), (Object)finCardId);
        DynamicObjectCollection aftSplitEntry = befRowDy.getDynamicObjectCollection("subassetsplitentry");
        for (DynamicObject aftSplit : aftSplitEntry) {
            if (!aftSplit.getBoolean("issourcecard")) continue;
            aftSplit.set(Fa.id((String)"aft_fincard"), (Object)finCardId);
            return;
        }
    }

    private void switchOutDynamic(Set<DynamicObject> splitBills) {
        HashMap<String, Set<Long>> depreUse2CardIdsMap = new HashMap<String, Set<Long>>(2);
        HashMap<String, DynamicObject> depUseAndRealCard2SplitBill = new HashMap<String, DynamicObject>(splitBills.size());
        this.getAllPartySplitCards(splitBills, depreUse2CardIdsMap, depUseAndRealCard2SplitBill);
        if (depreUse2CardIdsMap.isEmpty()) {
            return;
        }
        HashSet<String> needSwitchOutData = new HashSet<String>(splitBills.size());
        this.getNeedSwitchOutData(depreUse2CardIdsMap, needSwitchOutData);
        if (needSwitchOutData.isEmpty()) {
            return;
        }
        this.genDynamicCardsAndSave(depUseAndRealCard2SplitBill, needSwitchOutData);
    }

    private void genDynamicCardsAndSave(Map<String, DynamicObject> depUseAndRealCard2SplitBill, Set<String> needSwitchOutData) {
        ArrayList<DynamicObject> depreDynamicLst = new ArrayList<DynamicObject>();
        MainEntityType dynamicCardType = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        for (Map.Entry<String, DynamicObject> splitEntry : depUseAndRealCard2SplitBill.entrySet()) {
            String key = splitEntry.getKey();
            if (!needSwitchOutData.contains(key)) continue;
            String[] s = key.split("_");
            Long assetBookId = Long.valueOf(s[0]);
            Long depreUseId = Long.valueOf(s[1]);
            Long realCardId = Long.valueOf(s[2]);
            DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)dynamicCardType);
            DynamicObject splitBill = splitEntry.getValue();
            dynamicCard.set("realcard", (Object)realCardId);
            dynamicCard.set("assetbook", (Object)assetBookId);
            dynamicCard.set("depreuse", (Object)depreUseId);
            dynamicCard.set("date", (Object)splitBill.getDate("splitdate"));
            dynamicCard.set("entityname", (Object)"fa_assetsplitbill");
            dynamicCard.set("changebillid", splitBill.getPkValue());
            dynamicCard.set("sourcename", (Object)splitBill.getString("billno"));
            depreDynamicLst.add(dynamicCard);
        }
        SaveServiceHelper.save((DynamicObject[])depreDynamicLst.toArray(new DynamicObject[0]));
    }

    private void getNeedSwitchOutData(Map<String, Set<Long>> depreUse2CardIdsMap, Set<String> needSwitchOutData) {
        for (Map.Entry<String, Set<Long>> entry : depreUse2CardIdsMap.entrySet()) {
            String key = entry.getKey();
            Set<Long> realCardIds = entry.getValue();
            DynamicObjectCollection existsDynamicCard = QueryServiceHelper.query((String)"fa_card_dynamic", (String)"realcard", (QFilter[])new QFilter[]{new QFilter("assetbook", "=", (Object)Long.parseLong(key.split("_")[0])), new QFilter("realcard", "in", realCardIds)});
            Set existsCardIds = existsDynamicCard.stream().map(v -> v.getLong("realcard")).collect(Collectors.toSet());
            realCardIds.removeAll(existsCardIds);
            if (realCardIds.isEmpty()) continue;
            for (Long realCardId : realCardIds) {
                needSwitchOutData.add(key + "_" + realCardId);
            }
        }
    }

    private void getAllPartySplitCards(Set<DynamicObject> splitBills, Map<String, Set<Long>> depreUse2CardIdsMap, Map<String, DynamicObject> depUseAndRealCard2SplitBill) {
        for (DynamicObject splitBill : splitBills) {
            String bizType = splitBill.getString("biztype");
            if (!"A".equalsIgnoreCase(bizType)) continue;
            DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
            for (DynamicObject entry : befSplitEntry) {
                long depreUseId = entry.getLong(Fa.id((String)"bef_depreuse"));
                long assetBook = entry.getDynamicObject("bef_fincard").getLong(Fa.id((String)"assetbook"));
                long realCardId = splitBill.getLong(Fa.id((String)"split_realcard"));
                Set cardIds = depreUse2CardIdsMap.computeIfAbsent(assetBook + "_" + depreUseId, k -> new HashSet(splitBills.size()));
                cardIds.add(realCardId);
                String key = assetBook + "_" + depreUseId + "_" + realCardId;
                depUseAndRealCard2SplitBill.put(key, splitBill);
            }
        }
    }

    private void generateClearBill(DynamicObject splitCardBill) {
        String bizType = splitCardBill.getString("biztype");
        if ("B".equalsIgnoreCase(bizType)) {
            SplitBill2ClearBillConvertor converter = new SplitBill2ClearBillConvertor();
            ClearBillHDGenerator generator = new ClearBillHDGenerator((IClearBillConvertor)converter);
            generator.generate(splitCardBill.getPkValue(), "fa_assetsplitbill");
        }
    }
}

