/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.validator.SourceFlagDataAssetValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.FaBizBaseValidator;
import kd.fi.fa.opplugin.changebill.validator.FaSourceFlagValidator;
import kd.fi.fa.opplugin.split.FaSplitBillDataChangeValidator;
import kd.fi.fa.opplugin.split.FaSplitCardBillDevalueValidator;
import kd.fi.fa.opplugin.split.FaSplitCardBillManualCodeValidator;
import kd.fi.fa.opplugin.split.FaSplitCardBillMergeValidator;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaSplitCardBillSaveOp
extends AbstractBizCtrOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaBizBaseValidator());
        e.addValidator((AbstractValidator)new FaSplitBillDataChangeValidator());
        e.addValidator((AbstractValidator)new FaSourceFlagValidator("assetsplitentry", "realcard"));
        e.addValidator((AbstractValidator)new FaSplitCardBillDevalueValidator());
        e.addValidator((AbstractValidator)new FaSplitCardBillMergeValidator());
        e.addValidator((AbstractValidator)new SourceFlagDataAssetValidator("assetsplitentry", "split_realcard", "realcard"));
        e.addValidator((AbstractValidator)new FaSplitCardBillManualCodeValidator());
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("splittype");
        fieldKeys.add("splitdate");
        fieldKeys.add("splitperiod");
        fieldKeys.add("split_realcard");
        fieldKeys.add("ismanualcode");
        fieldKeys.add("isautocarry");
        fieldKeys.add(Fa.dot((String[])new String[]{"split_realcard", "mergedcard"}));
        fieldKeys.add("assetsplitentry");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_assetsplitbill");
        EntryProp befEntryProp = (EntryProp)dataEntityType.getProperties().get((Object)"assetsplitentry");
        DataEntityPropertyCollection befProps = befEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        for (IDataEntityProperty befProp : befProps) {
            fieldKeys.add(befProp.getName());
        }
        EntryProp aftEntryProp = (EntryProp)befProps.get((Object)"subassetsplitentry");
        DataEntityPropertyCollection aftProps = aftEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        for (IDataEntityProperty aftProp : aftProps) {
            fieldKeys.add(aftProp.getName());
        }
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] oldBills;
        super.beginOperationTransaction(e);
        FaOpUtils.updateMasterIdByRealCard4Entries(e.getDataEntities(), "assetsplitentry", "realcard");
        DynamicObject[] bills = e.getDataEntities();
        Object[] pkArray = Stream.of(bills).map(DataEntityBase::getPkValue).toArray(Object[]::new);
        for (DynamicObject oldBill : oldBills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_assetsplitbill"))) {
            FaModiRealStatsUtils.update_splitbill_bizStatus((DynamicObject)oldBill, (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.SPLIT);
        }
        for (DynamicObject bill : bills) {
            this.processSplitBillCalc(bill);
            FaModiRealStatsUtils.update_splitbill_bizStatus((DynamicObject)bill, (BizStatusEnum)BizStatusEnum.SPLIT, (BizStatusEnum)BizStatusEnum.READY);
        }
    }

    private void processSplitBillCalc(DynamicObject bill) {
        DynamicObjectCollection befSplitEntry = bill.getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject befSplit : befSplitEntry) {
            BigDecimal befOriginalVal = befSplit.getBigDecimal("bef_originalval");
            BigDecimal befAccumDepre = befSplit.getBigDecimal("bef_accumdepre");
            BigDecimal befDecVal = befSplit.getBigDecimal("bef_decval");
            DynamicObjectCollection aftSplitEntry = befSplit.getDynamicObjectCollection("subassetsplitentry");
            BigDecimal aftOriginalValSum = BigDecimal.ZERO;
            BigDecimal aftOriginalAmountSum = BigDecimal.ZERO;
            for (DynamicObject aftSplit : aftSplitEntry) {
                BigDecimal originalVal = aftSplit.getBigDecimal("aft_originalval") == null ? BigDecimal.ZERO : aftSplit.getBigDecimal("aft_originalval");
                aftOriginalValSum = aftOriginalValSum.add(originalVal);
                BigDecimal accumDep = aftSplit.getBigDecimal("aft_accumdepre") == null ? BigDecimal.ZERO : aftSplit.getBigDecimal("aft_accumdepre");
                BigDecimal decVal = aftSplit.getBigDecimal("aft_decval") == null ? BigDecimal.ZERO : aftSplit.getBigDecimal("aft_decval");
                aftSplit.set("aft_networth", (Object)originalVal.subtract(accumDep));
                BigDecimal netAmount = originalVal.subtract(accumDep).subtract(decVal);
                aftSplit.set("aft_netamount", (Object)netAmount);
                if (aftSplit.getBoolean("issourcecard")) {
                    aftSplit.set("aft_monthorigvalchg", (Object)originalVal.subtract(befOriginalVal));
                    aftSplit.set("aft_yearorigvalchg", (Object)originalVal.subtract(befOriginalVal));
                    aftSplit.set("aft_monthaccumdeprechg", (Object)accumDep.subtract(befAccumDepre));
                    aftSplit.set("aft_monthdeprechg", (Object)decVal.subtract(befDecVal));
                } else {
                    aftSplit.set("aft_monthorigvalchg", (Object)originalVal);
                    aftSplit.set("aft_yearorigvalchg", (Object)originalVal);
                    aftSplit.set("aft_monthaccumdeprechg", (Object)accumDep);
                    aftSplit.set("aft_monthdeprechg", (Object)decVal);
                }
                aftOriginalAmountSum = aftOriginalAmountSum.add(aftSplit.getBigDecimal("aft_originalamount"));
            }
            if (aftOriginalValSum.compareTo(befOriginalVal) != 0) continue;
            this.aftOriginalAmountCalc(befSplit);
        }
    }

    private void aftOriginalAmountCalc(DynamicObject befSplit) {
        BigDecimal originalAmount = befSplit.getBigDecimal("bef_originalamount");
        DynamicObject currency = befSplit.getDynamicObject("bef_fincard").getDynamicObject("currency");
        int curPrecision = (currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (DynamicObjectType)currency.getDynamicObjectType())) == null ? 15 : currency.getInt("amtprecision");
        BigDecimal befOriginalVal = befSplit.getBigDecimal("bef_originalval");
        DynamicObjectCollection aftSplitEntry = befSplit.getDynamicObjectCollection("subassetsplitentry");
        int i = 0;
        int count = aftSplitEntry.size();
        BigDecimal originalAmountSum = BigDecimal.ZERO;
        for (DynamicObject aftSplit : aftSplitEntry) {
            if (i == count - 1) {
                ((DynamicObject)aftSplitEntry.get(i)).set("aft_originalamount", (Object)originalAmount.subtract(originalAmountSum));
            } else {
                BigDecimal originalVal = aftSplit.getBigDecimal("aft_originalval");
                BigDecimal originalAmountCalc = this.getScaleValue(originalAmount, befOriginalVal, originalVal, curPrecision);
                originalAmountSum = originalAmountSum.add(originalAmountCalc);
                ((DynamicObject)aftSplitEntry.get(i)).set("aft_originalamount", (Object)originalAmountCalc);
            }
            ++i;
        }
    }

    private BigDecimal getScaleValue(BigDecimal totalOriginalAmount, BigDecimal totalOriginalVal, BigDecimal originalVal, int precise) {
        if (totalOriginalAmount.compareTo(BigDecimal.ZERO) == 0 || totalOriginalVal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal rowHalfUpAvg = totalOriginalAmount.multiply(originalVal).divide(totalOriginalVal, precise, RoundingMode.HALF_UP);
        if (rowHalfUpAvg.multiply(totalOriginalVal.subtract(BigDecimal.ONE)).compareTo(totalOriginalAmount.multiply(originalVal)) <= 0) {
            return rowHalfUpAvg;
        }
        return totalOriginalAmount.multiply(originalVal).divide(totalOriginalVal, precise, RoundingMode.DOWN);
    }
}

