/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.constants.FaChangeItem;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpQueryUtils;
import kd.fi.fa.utils.FaOpUtils;

public class FaSplitCardBillSubmitValidator
extends AbstractValidator {
    private static final String[][] AMOUNT_FIELD_INFO_ARR = new String[][]{{"bef_originalval", "aft_originalval"}, {"bef_accumdepre", "aft_accumdepre"}, {"bef_decval", "aft_decval"}, {"bef_preresidualval", "aft_preresidualval"}, {"bef_networth", "aft_networth"}, {"bef_netamount", "aft_netamount"}};
    private static final EntryType[] ENTRY_TYPE_ARR = new EntryType[2];

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            try {
                DynamicObject splitBill = dataEntity.getDataEntity();
                DynamicObject realCard = splitBill.getDynamicObject("split_realcard");
                if (realCard == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u88ab\u62c6\u5206\u5361\u7247\u3002", (String)"FaSplitCardBillSubmitValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                this.checkSplitCardInOrg(dataEntity);
                FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "assetsplitentry", Fa.dot((String[])new String[]{"realcard", "masterid"}), "fa_assetsplitbill");
                String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "splitdate");
                if (!bookNames.isEmpty()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff1a%s\u3002", (String)"FaSplitCardBillSubmitValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), bookNames));
                }
                this.checkDisableBiz(dataEntity);
                this.checkSplitData(dataEntity);
            }
            catch (Exception e) {
                this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
            }
        }
    }

    private void checkSplitCardInOrg(ExtendedDataEntity dataEntity) {
        DynamicObject splitBill = dataEntity.getDataEntity();
        DynamicObject realCard = splitBill.getDynamicObject("split_realcard");
        Long realCardId = realCard.getLong("id");
        DynamicObject org = splitBill.getDynamicObject("org");
        Long orgId = org.getLong("id");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)realCardId), new QFilter("org", "=", (Object)orgId)};
        if (!QueryServiceHelper.exists((String)"fa_card_real", (QFilter[])filters)) {
            String orgNumber = org.getString("number");
            String realCardNumber = realCard.getString("number");
            String msgCaption = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7[%1$s]\u4e0d\u5b58\u5728\u5361\u7247\u7f16\u7801[%2$s]\u3002", (String)"FaSplitCardBillSubmitValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), orgNumber, realCardNumber);
            this.addErrorMessage(dataEntity, msgCaption);
        }
    }

    private void checkSplitData(ExtendedDataEntity dataEntity) {
        DynamicObject splitBill = dataEntity.getDataEntity();
        DynamicObjectCollection befRows = splitBill.getDynamicObjectCollection("assetsplitentry");
        if (befRows.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62c6\u5206\u524d\u7684\u5361\u7247\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaSplitCardBillSubmitValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            return;
        }
        this.checkSplitDataByBef(dataEntity, befRows);
    }

    private void checkSplitDataByBef(ExtendedDataEntity dataEntity, DynamicObjectCollection befRows) {
        DynamicObject splitBill = dataEntity.getDataEntity();
        DynamicObject splitRealCard = splitBill.getDynamicObject("split_realcard");
        BigDecimal assetAmount = splitRealCard.getBigDecimal("assetamount");
        String splitType = splitBill.getString("splittype");
        boolean isPartSplit = "A".equals(splitBill.getString("biztype"));
        int subEntryLine = isPartSplit ? splitBill.getInt("splitqty") : splitBill.getInt("splitqty") + 1;
        boolean enableCurPeriodSplit = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)splitBill.getLong(Fa.id((String)"org")));
        long splitPeriod = splitBill.getLong(Fa.id((String)"splitperiod"));
        for (DynamicObject befRowDy : befRows) {
            DynamicObjectCollection aftSplitEntryColl;
            long finPeriodId;
            DynamicObject realDy = befRowDy.getDynamicObject("realcard");
            if (realDy == null) continue;
            String assetNumber = realDy.getString("number");
            DynamicObject finDy = befRowDy.getDynamicObject("bef_fincard");
            DynamicObject curPeriod = finDy.getDynamicObject("period");
            if (curPeriod != null && (finPeriodId = curPeriod.getLong("id")) == splitPeriod) {
                if (enableCurPeriodSplit) {
                    boolean existsChangeBill = QueryServiceHelper.exists((String)"fa_change_dept", (QFilter[])new QFilter[]{new QFilter("fieldentry.realcard1", "=", (Object)realDy.getLong("id"))});
                    if (existsChangeBill) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u5f53\u671f\u5df2\u5b58\u5728\u53d8\u66f4\u4e1a\u52a1\uff0c\u4e0d\u652f\u6301\u62c6\u5206\u3002", (String)"FaSplitCardBillSubmitValidator_26", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
                    }
                } else {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u4e0d\u4e3a\u5f53\u671f\u4e4b\u524d\u65b0\u589e\u7684\u5361\u7247\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
                }
            }
            if ((aftSplitEntryColl = befRowDy.getDynamicObjectCollection("subassetsplitentry")) == null || aftSplitEntryColl.isEmpty()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u6ca1\u6709\u6267\u884c\u5361\u7247\u62c6\u5206\u3002", (String)"FaSplitCardBillSubmitValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
                continue;
            }
            if (assetAmount.compareTo(BigDecimal.ONE) == 0 && "A".equalsIgnoreCase(splitType)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u62c6\u5206\u524d\u540e\u7684\u8d44\u4ea7\u6570\u91cf\u4e3a1\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u91cf\u62c6\u5206\u3002", (String)"FaSplitCardBillSubmitValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
            }
            if (subEntryLine != aftSplitEntryColl.size()) {
                String errStr = String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u62c6\u5206\u540e\u5361\u7247\u6570\u91cf\u548c\u62c6\u5206\u5361\u7247\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u62c6\u5206\u3002", (String)"FaSplitCardBillSubmitValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber);
                this.addErrorMessage(dataEntity, errStr);
            }
            this.checkAftSplitData(dataEntity, befRowDy, aftSplitEntryColl);
        }
    }

    private void checkAftSplitData(ExtendedDataEntity dataEntity, DynamicObject befRowDy, DynamicObjectCollection aftSplitEntryColl) {
        DynamicObject splitBill = dataEntity.getDataEntity();
        DynamicObject splitRealCard = splitBill.getDynamicObject("split_realcard");
        String assetNumber = splitRealCard.getString("number");
        BigDecimal assetAmount = splitRealCard.getBigDecimal("assetamount");
        String splitType = splitBill.getString("splittype");
        String bizType = splitBill.getString("biztype");
        BigDecimal totalOriginalVal = befRowDy.getBigDecimal("bef_originalval");
        BigDecimal totalAccumDepre = befRowDy.getBigDecimal("bef_accumdepre");
        BigDecimal totalDecVal = befRowDy.getBigDecimal("bef_decval");
        BigDecimal totalIncomeTax = befRowDy.getBigDecimal("bef_incometax");
        BigDecimal sumAssetAmount = BigDecimal.ZERO;
        BigDecimal sumOriData = BigDecimal.ZERO;
        BigDecimal sumAccumDepreData = BigDecimal.ZERO;
        BigDecimal sumDecValData = BigDecimal.ZERO;
        BigDecimal sumIncomeTax = BigDecimal.ZERO;
        int rowIndex = 0;
        for (DynamicObject aftDy : aftSplitEntryColl) {
            boolean ignoreFlag;
            ++rowIndex;
            BigDecimal afterAssetAmount = aftDy.getBigDecimal("aft_assetamount");
            if (afterAssetAmount.compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5361\u7247\u7b2c%s\u884c\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex));
            }
            this.calcNetWorthAndNetAmount(aftDy);
            for (String[] fieldInfo : AMOUNT_FIELD_INFO_ARR) {
                this.checkAmount(dataEntity, assetNumber, aftDy, fieldInfo[1], rowIndex);
            }
            BigDecimal aftNetAmount = aftDy.getBigDecimal("aft_originalval").subtract(aftDy.getBigDecimal("aft_accumdepre")).subtract(aftDy.getBigDecimal("aft_decval"));
            BigDecimal aftPreResidualVal = aftDy.getBigDecimal("aft_preresidualval");
            DynamicObject depreUse = aftDy.getDynamicObject("aft_depreuse");
            String depreUseName = depreUse.getString("name");
            if (aftNetAmount.compareTo(aftPreResidualVal) < 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5361\u7247[ %2$s ] \u62c6\u5206\u540e\u5361\u7247\u7b2c%3$s\u884c\u51c0\u989d\u5c0f\u4e8e\u6b8b\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreUseName, assetNumber, rowIndex));
            }
            boolean bl = ignoreFlag = "B".equalsIgnoreCase(bizType) && aftDy.getBoolean("issourcecard");
            if (!ignoreFlag) {
                sumAssetAmount = sumAssetAmount.add(aftDy.getBigDecimal("aft_assetamount"));
            }
            sumOriData = sumOriData.add(aftDy.getBigDecimal("aft_originalval"));
            sumAccumDepreData = sumAccumDepreData.add(aftDy.getBigDecimal("aft_accumdepre"));
            sumDecValData = sumDecValData.add(aftDy.getBigDecimal("aft_decval"));
            sumIncomeTax = sumIncomeTax.add(aftDy.getBigDecimal("aft_incometax"));
            if (aftDy.getBoolean("issourcecard") || aftDy.getBigDecimal("aft_addupyeardepre").compareTo(BigDecimal.ZERO) == 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5361\u7247[ %2$s ] \u62c6\u5206\u540e\u5361\u7247\u7b2c%3$s\u884c\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u503c\u4e0d\u7b49\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_25", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreUseName, assetNumber, rowIndex));
        }
        if ("A".equalsIgnoreCase(splitType) && assetAmount.compareTo(sumAssetAmount) != 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6309\u6570\u91cf\u62c6\u5206\u65b9\u5f0f\uff0c\u5361\u7247\u201c%s\u201d\u62c6\u5206\u524d\u540e\u7684\u8d44\u4ea7\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
        }
        if (sumOriData.compareTo(totalOriginalVal) != 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u62c6\u5206\u524d\u540e\u7684\u8d44\u4ea7\u539f\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_12", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
        }
        if (sumAccumDepreData.compareTo(totalAccumDepre) != 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u62c6\u5206\u524d\u540e\u7684\u7d2f\u8ba1\u6298\u65e7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_13", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
        }
        if (sumDecValData.compareTo(totalDecVal) != 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u62c6\u5206\u524d\u540e\u7684\u51cf\u503c\u51c6\u5907\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_14", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
        }
        if (sumIncomeTax.compareTo(totalIncomeTax) != 0) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u62c6\u5206\u524d\u540e\u7684\u8fdb\u9879\u7a0e\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillSubmitValidator_15", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber));
        }
    }

    private void calcNetWorthAndNetAmount(DynamicObject aftDy) {
        BigDecimal originalVal = aftDy.getBigDecimal("aft_originalval") == null ? BigDecimal.ZERO : aftDy.getBigDecimal("aft_originalval");
        BigDecimal accumDep = aftDy.getBigDecimal("aft_accumdepre") == null ? BigDecimal.ZERO : aftDy.getBigDecimal("aft_accumdepre");
        BigDecimal decVal = aftDy.getBigDecimal("aft_decval") == null ? BigDecimal.ZERO : aftDy.getBigDecimal("aft_decval");
        aftDy.set("aft_networth", (Object)originalVal.subtract(accumDep));
        aftDy.set("aft_netamount", (Object)originalVal.subtract(accumDep).subtract(decVal));
    }

    private void checkAmount(ExtendedDataEntity dataEntity, String assetNumber, DynamicObject aftDy, String afterField, int rowIndex) {
        String errStr = null;
        BigDecimal afterAmount = aftDy.getBigDecimal(afterField);
        if (afterAmount.compareTo(BigDecimal.ZERO) < 0) {
            EntryType afterEntryType = ENTRY_TYPE_ARR[1];
            DynamicObject depreUse = aftDy.getDynamicObject("aft_depreuse");
            String depreUseName = depreUse.getString("name");
            String afterFieldDesc = afterEntryType.getProperty(afterField).getDisplayName().getLocaleValue();
            errStr = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5361\u7247[ %2$s ] \u62c6\u5206\u540e\u5361\u7247\u7b2c%3$s\u884c%4$s\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u8bf7\u68c0\u67e5", (String)"FaSplitCardBillSubmitValidator_16", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreUseName, assetNumber, rowIndex, afterFieldDesc);
        }
        if (errStr != null) {
            this.addErrorMessage(dataEntity, errStr);
        }
    }

    private void checkDisableBiz(ExtendedDataEntity dataEntity) {
        String depAdjustErrStr;
        String changeErrStr;
        String clearErrStr;
        DynamicObject splitBill = dataEntity.getDataEntity();
        String errStr = null;
        ArrayList<String> errList = new ArrayList<String>();
        DynamicObject realDy = splitBill.getDynamicObject("split_realcard");
        long realCardId = realDy.getLong("id");
        long orgId = splitBill.getLong(Fa.id((String)"org"));
        DynamicObject assetBookDy = FaBizUtils.getAsstBookByOrg((Long)orgId);
        String workloadErrStr = this.checkWorkloadBiz(realCardId, splitBill);
        if (!StringUtils.isEmpty((String)workloadErrStr)) {
            errList.add(workloadErrStr);
        }
        if (!StringUtils.isEmpty((String)(clearErrStr = this.checkClearBiz(realCardId, assetBookDy)))) {
            errList.add(clearErrStr);
        }
        if (!StringUtils.isEmpty((String)(changeErrStr = this.checkChangeBiz(realCardId, assetBookDy, splitBill)))) {
            errList.add(changeErrStr);
        }
        if (!StringUtils.isEmpty((String)(depAdjustErrStr = this.checkDepAdjustBiz(realCardId, assetBookDy)))) {
            errList.add(depAdjustErrStr);
        }
        if (!errList.isEmpty()) {
            String formatStr = ResManager.loadKDString((String)"\u5361\u7247[ %1$s ] \u5f53\u671f\u5b58\u5728\u4ee5\u4e0b\u4e1a\u52a1\u4e0d\u652f\u6301\u5361\u7247\u62c6\u5206\u4e1a\u52a1:  %2$s", (String)"FaSplitCardBillSubmitValidator_17", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            errStr = String.format(formatStr, realDy.getString("number"), String.join((CharSequence)",", errList));
        }
        if (!StringUtils.isEmpty(errStr)) {
            this.addErrorMessage(dataEntity, errStr);
        }
    }

    private String checkChangeBillDoIsAdjustDepre(DynamicObject splitBill, long realCardId) {
        DynamicObject splitPeriod = splitBill.getDynamicObject("splitperiod");
        Long orgId = splitBill.getLong(Fa.dot((String[])new String[]{"org", "id"}));
        if (Objects.isNull(splitPeriod)) {
            DynamicObject mainBookByOrg = FaUtils.getMainBookDyByOrg((Long)orgId);
            splitPeriod = mainBookByOrg.getDynamicObject("curperiod");
        }
        splitPeriod = PeriodUtil.getPeriodDynById((Object)splitPeriod.getPkValue());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.name());
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "realcard1"}), "=", (Object)realCardId);
        QFilter fieldFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "field"}), "in", (Object)FaChangeItem.SYS_INIT_DEPRE_ITEM);
        QFilter isAdjustdepreEqualsTrueQFilter = new QFilter("fieldentry.isadjustdepre1", "=", (Object)true);
        String bizDate = Fa.dot((String[])new String[]{"fieldentry", "bizdate1"});
        QFilter bizdateQFilter = new QFilter(bizDate, ">", (Object)splitPeriod.getDate("enddate")).or(new QFilter(bizDate, "<", (Object)splitPeriod.getDate("begindate")));
        QFilter isAdjustdepreEqualsFalseQFilter = new QFilter("fieldentry.isadjustdepre1", "=", (Object)false);
        QFilter filter = realFilter.and(isAdjustdepreEqualsTrueQFilter.and(bizdateQFilter).or(isAdjustdepreEqualsFalseQFilter.and(fieldFilter)));
        DynamicObjectCollection itemDys = QueryServiceHelper.query((String)"fa_change_dept", (String)"billno", (QFilter[])new QFilter[]{filter, orgFilter, billStatusFilter});
        String errStr = null;
        if (itemDys != null && !itemDys.isEmpty()) {
            Set billSet = itemDys.stream().map(dy -> dy.getString("billno")).collect(Collectors.toSet());
            String formatStr = ResManager.loadKDString((String)"\u53d8\u66f4\u4e1a\u52a1[ %s ] \u5b58\u5728\u8ffd\u6eaf\u8c03\u6574\u7684\u53d8\u66f4\u6216\u672a\u6765\u9002\u7528\u5230\u8fc7\u53bb\u7684\u53d8\u66f4", (String)"FaSplitCardBillSubmitValidator_24", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            errStr = String.format(formatStr, String.join((CharSequence)",", billSet));
        }
        return errStr;
    }

    private String checkChangeBillDoNextPeriodDepBiz(DynamicObject splitBill, long realCardId) {
        QFilter lessDateFilter;
        String bizDate;
        QFilter largeDateFilter;
        DynamicObjectCollection itemDys;
        DynamicObject splitPeriod = splitBill.getDynamicObject("splitperiod");
        Long orgId = splitBill.getLong(Fa.dot((String[])new String[]{"org", "id"}));
        if (Objects.isNull(splitPeriod)) {
            DynamicObject mainBookByOrg = FaUtils.getMainBookDyByOrg((Long)orgId);
            splitPeriod = mainBookByOrg.getDynamicObject("curperiod");
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.name());
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "realcard1"}), "=", (Object)realCardId);
        QFilter fieldFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "field"}), "in", (Object)FaChangeItem.SYS_INIT_DEPRE_ITEM);
        String errStr = null;
        DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriodByDo((DynamicObject)splitPeriod, (int)1);
        if (Objects.nonNull(nextPeriod) && (itemDys = QueryServiceHelper.query((String)"fa_change_dept", (String)"billno", (QFilter[])new QFilter[]{orgFilter, billStatusFilter, largeDateFilter = new QFilter(bizDate = Fa.dot((String[])new String[]{"fieldentry", "bizdate1"}), ">=", (Object)nextPeriod.getDate("begindate")), lessDateFilter = new QFilter(bizDate, "<=", (Object)nextPeriod.getDate("enddate")), realFilter, fieldFilter})) != null && !itemDys.isEmpty()) {
            Set billSet = itemDys.stream().map(dy -> dy.getString("billno")).collect(Collectors.toSet());
            String formatStr = ResManager.loadKDString((String)"\u53d8\u66f4\u4e1a\u52a1[ %s ] \u505a\u4e86\u5f71\u54cd\u4e0b\u671f\u6298\u65e7\u7684\u53d8\u66f4", (String)"FaSplitCardBillSubmitValidator_27", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            errStr = String.format(formatStr, String.join((CharSequence)",", billSet));
        }
        return errStr;
    }

    private String checkWorkloadBiz(long realCardId, DynamicObject splitBill) {
        long periodId = splitBill.getLong(Fa.dot((String[])new String[]{"splitperiod", "id"}));
        Long orgId = splitBill.getLong(Fa.dot((String[])new String[]{"org", "id"}));
        if (periodId == 0L) {
            Date splitDate = splitBill.getDate("splitdate");
            periodId = PeriodUtil.getMainBookBizPeriodPK((Object)orgId, (Date)splitDate);
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("period", "=", (Object)periodId), new QFilter("realcard", "=", (Object)realCardId)};
        DynamicObjectCollection dynObjCollection = QueryServiceHelper.query((String)"fa_workload", (String)"realcard.number", (QFilter[])filters);
        String errStr = null;
        if (Objects.nonNull(dynObjCollection) && !dynObjCollection.isEmpty()) {
            Set billSet = dynObjCollection.stream().map(dy -> dy.getString("realcard.number")).collect(Collectors.toSet());
            String formatStr = ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4\u4e1a\u52a1[ %s ]", (String)"FaSplitCardBillSubmitValidator_22", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            errStr = String.format(formatStr, String.join((CharSequence)",", billSet));
        }
        return errStr;
    }

    private String checkClearBiz(long realCardId, DynamicObject assetBookDy) {
        QFilter realFilter;
        QFilter lessDateFilter;
        QFilter largeDateFilter;
        QFilter statusFilter;
        String errStr = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)assetBookDy.getLong("org"));
        DynamicObjectCollection itemDys = QueryServiceHelper.query((String)"fa_clearbill", (String)"billno", (QFilter[])new QFilter[]{orgFilter, statusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.name()), largeDateFilter = new QFilter("cleardate", ">=", (Object)assetBookDy.getDate("begindate")), lessDateFilter = new QFilter("cleardate", "<=", (Object)assetBookDy.getDate("enddate")), realFilter = new QFilter(Fa.dot((String[])new String[]{"detail_entry", "realcard"}), "=", (Object)realCardId)});
        if (itemDys != null && !itemDys.isEmpty()) {
            Set billSet = itemDys.stream().map(dy -> dy.getString("billno")).collect(Collectors.toSet());
            String formatStr = ResManager.loadKDString((String)"\u6e05\u7406\u4e1a\u52a1[ %s ]", (String)"FaSplitCardBillSubmitValidator_18", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            errStr = String.format(formatStr, String.join((CharSequence)",", billSet));
        }
        return errStr;
    }

    private String checkChangeBiz(long realCardId, DynamicObject assetBookDy, DynamicObject splitBill) {
        String errStr = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)assetBookDy.getLong("org"));
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.name());
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "realcard1"}), "=", (Object)realCardId);
        QFilter fieldFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "field"}), "in", (Object)FaChangeItem.SYS_INIT_DEPRE_ITEM);
        boolean enableOldVersionSplitBillSubmitCheckChangeBiz = FaBillParamUtils.getBooleanValue(null, null, null, (String)"enableOldVersionSplitBillSubmitCheckChangeBiz");
        if (enableOldVersionSplitBillSubmitCheckChangeBiz) {
            QFilter lessDateFilter;
            QFilter largeDateFilter = new QFilter("changedate", ">=", (Object)assetBookDy.getDate("begindate"));
            DynamicObjectCollection itemDys = QueryServiceHelper.query((String)"fa_change_dept", (String)"billno", (QFilter[])new QFilter[]{orgFilter, statusFilter, largeDateFilter, lessDateFilter = new QFilter("changedate", "<=", (Object)assetBookDy.getDate("enddate")), realFilter, fieldFilter});
            if (itemDys != null && !itemDys.isEmpty()) {
                Set billSet = itemDys.stream().map(dy -> dy.getString("billno")).collect(Collectors.toSet());
                String formatStr = ResManager.loadKDString((String)"\u53d8\u66f4\u4e1a\u52a1[ %s ]", (String)"FaSplitCardBillSubmitValidator_19", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                errStr = String.format(formatStr, String.join((CharSequence)",", billSet));
            }
        } else {
            String selectFields = Fa.comma((String[])new String[]{"billno", "changedate", Fa.dot((String[])new String[]{"fieldentry", "bizdate1"}), Fa.dot((String[])new String[]{"fieldentry", "isadjustdepre1"})});
            DynamicObjectCollection itemDys = QueryServiceHelper.query((String)"fa_change_dept", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, statusFilter, realFilter, fieldFilter});
            String finalBillNo = null;
            Date finalMaxDate = null;
            if (itemDys != null && !itemDys.isEmpty()) {
                for (DynamicObject dyObj : itemDys) {
                    Date maxDate;
                    Date bizDate = dyObj.getDate(Fa.dot((String[])new String[]{"fieldentry", "bizdate1"}));
                    Date changeDate = dyObj.getDate("changedate");
                    if (Objects.isNull(bizDate) && Objects.isNull(changeDate)) continue;
                    boolean isAdjustDepre = dyObj.getBoolean(Fa.dot((String[])new String[]{"fieldentry", "isadjustdepre1"}));
                    if (!isAdjustDepre) {
                        bizDate = changeDate;
                    }
                    if (Objects.isNull(maxDate = this.getMaxDate(bizDate, changeDate))) continue;
                    if (Objects.isNull(finalMaxDate)) {
                        finalMaxDate = maxDate;
                        finalBillNo = dyObj.getString("billno");
                        continue;
                    }
                    if (maxDate.compareTo(finalMaxDate) <= 0) continue;
                    finalMaxDate = maxDate;
                    finalBillNo = dyObj.getString("billno");
                }
            }
            if (Objects.nonNull(finalBillNo) && Objects.nonNull(finalMaxDate)) {
                long periodType = assetBookDy.getLong("periodtype");
                DynamicObject splitPeriod = splitBill.getDynamicObject("splitperiod");
                Long orgId = splitBill.getLong(Fa.dot((String[])new String[]{"org", "id"}));
                if (Objects.isNull(splitPeriod)) {
                    DynamicObject mainBookByOrg = FaUtils.getMainBookDyByOrg((Long)orgId);
                    splitPeriod = mainBookByOrg.getDynamicObject("curperiod");
                }
                long splitPeriodId = (Long)splitPeriod.getPkValue();
                DynamicObject finalMaxDatePeriod = FaOpQueryUtils.getPeriodByDate(finalMaxDate, periodType);
                if (finalMaxDatePeriod.getLong("id") >= splitPeriodId) {
                    String formatStr = ResManager.loadKDString((String)"\u53d8\u66f4\u4e1a\u52a1[ %s ]", (String)"FaSplitCardBillSubmitValidator_19", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                    errStr = String.format(formatStr, finalBillNo);
                }
            }
        }
        return errStr;
    }

    private Date getMaxDate(Date bizDate, Date changeDate) {
        if (changeDate.compareTo(bizDate) >= 0) {
            return changeDate;
        }
        return bizDate;
    }

    private String checkDepAdjustBiz(long realCardId, DynamicObject assetBookDy) {
        QFilter cardFilter;
        QFilter periodFilter;
        QFilter statusFilter;
        String errStr = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)assetBookDy.getLong("org"));
        DynamicObjectCollection itemDys = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)"billno", (QFilter[])new QFilter[]{orgFilter, statusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.name()), periodFilter = new QFilter("period", "=", (Object)assetBookDy.getLong("curperiod")), cardFilter = new QFilter(Fa.dot((String[])new String[]{"entryentity", "realcard", "masterid"}), "=", (Object)realCardId)});
        if (itemDys != null && !itemDys.isEmpty()) {
            Set billSet = itemDys.stream().map(dy -> dy.getString("billno")).collect(Collectors.toSet());
            String formatStr = ResManager.loadKDString((String)"\u6298\u65e7\u8c03\u6574\u4e1a\u52a1[ %s ]", (String)"FaSplitCardBillSubmitValidator_21", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            errStr = String.format(formatStr, String.join((CharSequence)",", billSet));
        }
        return errStr;
    }

    static {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_assetsplitbill");
        EntryType befEntryType = (EntryType)((EntryProp)dataEntityType.getProperty("assetsplitentry")).getItemType();
        EntryType aftEntryType = (EntryType)((EntryProp)befEntryType.getProperty("subassetsplitentry")).getItemType();
        FaSplitCardBillSubmitValidator.ENTRY_TYPE_ARR[0] = befEntryType;
        FaSplitCardBillSubmitValidator.ENTRY_TYPE_ARR[1] = aftEntryType;
    }
}

