/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaCheckBaseDataRef;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpUtils;

public class FaSplitCardBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            try {
                DynamicObject splitBill = dataEntity.getDataEntity();
                if (!BillStatus.C.name().equals(splitBill.getString("billstatus"))) continue;
                String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "splitdate");
                if (!bookNames.isEmpty()) {
                    String msgCaption = ResManager.loadKDString((String)"\u62c6\u5206\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"FaSplitCardBillUnAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format("%s:%s\u3002", msgCaption, bookNames));
                    continue;
                }
                Object splitBillPkValue = splitBill.getPkValue();
                boolean hasVoucher = FaDepreUtil.hashVouncherV2(Collections.singletonList(splitBillPkValue), (String)"fa_assetsplitbill");
                if (hasVoucher) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u62c6\u5206\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FaSplitCardBillUnAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                this.checkSplitCardRefBiz(dataEntity);
                this.checkDepSumHasVouch(orgId2SumMutilVou, dataEntity);
                DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
                HashSet<Long> aftRealCardIds = new HashSet<Long>(befSplitEntry.size());
                HashSet<Long> aftFinCardIds = new HashSet<Long>(befSplitEntry.size());
                HashSet<Long> aftNewFinCardIds = new HashSet<Long>(16);
                for (DynamicObject befSplitEntity : befSplitEntry) {
                    DynamicObjectCollection aftSplitEntry = befSplitEntity.getDynamicObjectCollection("subassetsplitentry");
                    for (DynamicObject aftSplitEntity : aftSplitEntry) {
                        long aftRealCardId = aftSplitEntity.getLong(Fa.id((String)"aft_realcard"));
                        long aftFinCardId = aftSplitEntity.getLong(Fa.id((String)"aft_fincard"));
                        aftRealCardIds.add(aftRealCardId);
                        aftFinCardIds.add(aftFinCardId);
                        if (aftSplitEntity.getBoolean("issourcecard")) continue;
                        aftNewFinCardIds.add(aftFinCardId);
                    }
                }
                String checkVoucherResult = this.checkDepreSumHasVoucher(aftNewFinCardIds);
                if (StringUtils.isNotEmpty((CharSequence)checkVoucherResult)) {
                    this.addErrorMessage(dataEntity, checkVoucherResult);
                }
                if (!this.getValidateResult().getAllErrorInfo().isEmpty()) continue;
                this.checkSplitDataInDb(dataEntity, splitBill, aftFinCardIds, aftRealCardIds);
            }
            catch (Exception e) {
                this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
            }
        }
    }

    private void checkDepSumHasVouch(Map<Long, Boolean> orgId2SumMutilVou, ExtendedDataEntity dataEntity) {
        boolean enableSumMutilVoucher;
        DynamicObject splitBill = dataEntity.getDataEntity();
        Long orgId = splitBill.getLong(Fa.id((String)"org"));
        if (orgId2SumMutilVou.get(orgId) != null) {
            enableSumMutilVoucher = orgId2SumMutilVou.get(orgId);
        } else {
            enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
            orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
        }
        QFilter orgQFilter = new QFilter("org", "=", (Object)orgId);
        long splitPeriodId = splitBill.getLong(Fa.id((String)"splitperiod"));
        QFilter periodQFilter = !enableSumMutilVoucher ? new QFilter("period", ">=", (Object)splitPeriodId) : new QFilter("period", ">", (Object)splitPeriodId);
        DynamicObjectCollection depreSumList = QueryServiceHelper.query((String)"fa_depre_sum", (String)"id", (QFilter[])new QFilter[]{orgQFilter, periodQFilter});
        ArrayList<Object> depreSumIdSet = new ArrayList<Object>();
        for (DynamicObject depreSum : depreSumList) {
            depreSumIdSet.add(depreSum.get("id"));
        }
        if (!depreSumIdSet.isEmpty() && FaDepreUtil.hashVouncherV2(depreSumIdSet, (String)"fa_depre_sum")) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1", (String)"FaSplitCardBillUnAuditValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkSplitDataInDb(ExtendedDataEntity dataEntity, DynamicObject bill, Set<Long> aftFinCardIds, Set<Long> aftRealCardIds) {
        long realCardId = bill.getLong(Fa.id((String)"split_realcard"));
        String bizType = bill.getString("biztype");
        boolean isPartySplit = "A".equals(bizType);
        String realSelFields = Fa.comma((String[])new String[]{"id", "assetamount", "bizstatus", "number"});
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)realSelFields, (QFilter[])new QFilter("id", "in", aftRealCardIds).toArray());
        Map<Long, DynamicObject> realCardMap = realCards.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        DynamicObjectCollection befSplitEntry = bill.getDynamicObjectCollection("assetsplitentry");
        DynamicObjectCollection mainAftSplitEntry = ((DynamicObject)befSplitEntry.get(0)).getDynamicObjectCollection("subassetsplitentry");
        for (DynamicObject aftSplitEntity : mainAftSplitEntry) {
            BigDecimal aftAssetAmountDb;
            BigDecimal aftAssetAmount;
            long aftRealCard;
            long aftRealCardId = aftSplitEntity.getLong(Fa.id((String)"aft_realcard"));
            DynamicObject realCard = realCardMap.get(aftRealCardId);
            if (realCard == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u5b9e\u7269\u5361\u7247\u201cID = %s\u201d\u4e0d\u5b58\u5728\u4e86\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"FaSplitCardBillUnAuditValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), aftRealCardId));
            }
            boolean isSourceCard = aftSplitEntity.getBoolean("issourcecard");
            String bizStatus = realCard.getString("bizstatus");
            if (!isPartySplit && isSourceCard) {
                if (!BizStatusEnum.DELETE.name().equals(bizStatus)) {
                    String number = realCard.getString("number");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5361\u7247[%s]\u5b58\u5728\u672a\u5b8c\u6210\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u6267\u884c\u5b8c\u672a\u5b8c\u6210\u4e1a\u52a1\u540e\u518d\u8bd5\u3002", (String)"FaSplitCardBillUnAuditValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
                }
            } else if (!BizStatusEnum.READY.name().equals(bizStatus)) {
                String number = realCard.getString("number");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5361\u7247[%s]\u5b58\u5728\u672a\u5b8c\u6210\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u6267\u884c\u5b8c\u672a\u5b8c\u6210\u4e1a\u52a1\u540e\u518d\u8bd5\u3002", (String)"FaSplitCardBillUnAuditValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
            }
            if (realCardId != (aftRealCard = aftSplitEntity.getLong(Fa.id((String)"aft_realcard"))) || (aftAssetAmount = aftSplitEntity.getBigDecimal("aft_assetamount")).compareTo(aftAssetAmountDb = realCard.getBigDecimal("assetamount")) == 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u8d44\u4ea7\u6570\u91cf\u4e0e\u5b9e\u7269\u5361\u7247\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff0c\u62c6\u5206\u540e\u6570\u91cf\uff1a%1$s\uff0c\u5361\u7247\u6570\u91cf\uff1a%2$s\uff1b", (String)"FaSplitCardBillUnAuditValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), aftAssetAmount, aftAssetAmountDb));
        }
        String finSelFields = Fa.comma((String[])new String[]{"id", "originalval", "preresidualval", "decval"});
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)finSelFields, (QFilter[])new QFilter("id", "in", aftFinCardIds).toArray());
        Map<Long, DynamicObject> finCardMap = finCards.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        for (DynamicObject befSplitEntity : befSplitEntry) {
            DynamicObjectCollection aftSplitEntry = befSplitEntity.getDynamicObjectCollection("subassetsplitentry");
            for (DynamicObject aftSplitEntity : aftSplitEntry) {
                BigDecimal aftDecValDb;
                BigDecimal aftDecVal;
                BigDecimal aftPreResidualValDb;
                BigDecimal aftPreResidualVal;
                BigDecimal aftOriginalValDb;
                long aftFinCardId = aftSplitEntity.getLong(Fa.id((String)"aft_fincard"));
                DynamicObject finCard = finCardMap.get(aftFinCardId);
                if (finCard == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u8d22\u52a1\u5361\u7247\u201cID = %s\u201d\u4e0d\u5b58\u5728\u4e86\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"FaSplitCardBillUnAuditValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), aftFinCardId));
                }
                long aftRealCard = aftSplitEntity.getLong("aft_realcard.id");
                if (realCardId != aftRealCard) continue;
                BigDecimal aftOriginalVal = aftSplitEntity.getBigDecimal("aft_originalval");
                if (aftOriginalVal.compareTo(aftOriginalValDb = finCard.getBigDecimal("originalval")) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u539f\u503c\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff0c\u62c6\u5206\u540e\u539f\u503c\uff1a%1$s\uff0c\u5361\u7247\u539f\u503c\uff1a%2$s\uff1b", (String)"FaSplitCardBillUnAuditValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), aftOriginalVal, aftOriginalValDb));
                }
                if ((aftPreResidualVal = aftSplitEntity.getBigDecimal("aft_preresidualval")).compareTo(aftPreResidualValDb = finCard.getBigDecimal("preresidualval")) != 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u6b8b\u503c\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff0c\u62c6\u5206\u540e\u6b8b\u503c\uff1a%1$s\uff0c\u5361\u7247\u6b8b\u503c\uff1a%2$s\uff1b", (String)"FaSplitCardBillUnAuditValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), aftPreResidualVal, aftPreResidualValDb));
                }
                if ((aftDecVal = aftSplitEntity.getBigDecimal("aft_decval")).compareTo(aftDecValDb = finCard.getBigDecimal("decval")) == 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u51cf\u503c\u51c6\u5907\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u51cf\u503c\u51c6\u5907\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff0c\u62c6\u5206\u540e\u51cf\u503c\u51c6\u5907\uff1a%1$s\uff0c\u5361\u7247\u51cf\u503c\u51c6\u5907\uff1a%2$s\uff1b", (String)"FaSplitCardBillUnAuditValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), aftDecVal, aftDecValDb));
            }
        }
    }

    private String checkDepreSumHasVoucher(Set<Long> aftFinCardIds) {
        if (CollectionUtils.isEmpty(aftFinCardIds)) {
            return null;
        }
        HashSet<String> msgSet = new HashSet<String>(aftFinCardIds.size());
        Map finCardMap = BusinessDataServiceHelper.loadFromCache((Object[])aftFinCardIds.toArray(), (String)"fa_card_fin");
        List finCards = finCardMap.values().stream().collect(Collectors.toList());
        FinCardValidator validator = FinCardValidator.getInstanceForSeparateCard(finCards);
        Map errInfo = validator.validateInitFinCardForDelete();
        if (null != errInfo && errInfo.size() > 0) {
            for (Map.Entry entry : errInfo.entrySet()) {
                List msgList = (List)entry.getValue();
                msgSet.add(msgList.stream().collect(Collectors.joining(",")));
            }
        }
        return msgSet.stream().collect(Collectors.joining("; "));
    }

    private void checkSplitCardRefBiz(ExtendedDataEntity dataEntity) {
        DynamicObject billDy = dataEntity.getDataEntity();
        StringBuilder result = new StringBuilder();
        Set<Object> splitCardIds = this.getSplitCardIds(billDy);
        if (splitCardIds.isEmpty()) {
            return;
        }
        Long orgId = billDy.getLong("org.id");
        Optional checkResult = new FutureBizChecker(billDy.getPkValue(), (Object)orgId, splitCardIds, billDy.getDate("modifytime"), BusyTypeDetailEnum.REAL_FIN_CHG).checkWhenun();
        if (checkResult.isPresent()) {
            result.append(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s", (String)"FaSplitCardBillUnAuditValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get()));
        }
        OperateOption operate = OperateOption.create();
        DynamicObject mainBefSplit = (DynamicObject)billDy.getDynamicObjectCollection("assetsplitentry").get(0);
        DynamicObjectCollection mainAftSplitEntry = mainBefSplit.getDynamicObjectCollection("subassetsplitentry");
        HashMap<Object, String> idToNumber = new HashMap<Object, String>(mainAftSplitEntry.size());
        for (DynamicObject aftSplit : mainAftSplitEntry) {
            if (aftSplit.getBoolean("issourcecard")) continue;
            DynamicObject aftRealCard = aftSplit.getDynamicObject("aft_realcard");
            Object id = aftRealCard.get("id");
            String number = aftRealCard.getString("number");
            idToNumber.put(id, number);
        }
        try {
            Map checkRefResult = FaCheckBaseDataRef.checkRef((String)"fa_card_real_base", (OperateOption)operate, idToNumber);
            for (Map.Entry entry : checkRefResult.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!result.toString().isEmpty()) {
                    result.append("\n");
                }
                String msg = String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5361\u7247[%1$s]%2$s", (String)"FaSplitCardBillUnAuditValidator_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), key, value);
                result.append(msg);
            }
        }
        catch (Exception e) {
            this.addErrorMessage(dataEntity, e.getMessage());
        }
        if (!StringUtils.isEmpty((CharSequence)result)) {
            this.addErrorMessage(dataEntity, result.toString());
        }
    }

    private Set<Object> getSplitCardIds(DynamicObject billDy) {
        HashSet<Object> splitCardIds = new HashSet<Object>();
        String bizType = billDy.getString("biztype");
        DynamicObjectCollection befRowDys = billDy.getDynamicObjectCollection("assetsplitentry");
        DynamicObjectCollection aftRowDys = ((DynamicObject)befRowDys.get(0)).getDynamicObjectCollection("subassetsplitentry");
        for (DynamicObject aftRowDy : aftRowDys) {
            DynamicObject aftRealDy = aftRowDy.getDynamicObject("aft_realcard");
            if (aftRealDy == null) continue;
            splitCardIds.add(aftRealDy.getLong("id"));
        }
        if ("B".equals(bizType)) {
            long splitCardId = billDy.getLong(Fa.id((String)"split_realcard"));
            splitCardIds.remove(splitCardId);
        }
        return splitCardIds;
    }
}

