/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.validator;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FaChangeApplyValidator
extends AbstractValidator {
    public void validate() {
        String entityKey;
        switch (entityKey = this.entityKey) {
            case "fa_card_real": {
                this.checkUnauditChangeApplyBillOnRealCard(true);
                break;
            }
            case "fa_clearbill": {
                this.checkUnauditChangeApplyBill("detail_entry", "realcard");
                break;
            }
            case "fa_dispatch": {
                this.checkUnauditChangeApplyBill("dispatchentry", "realcard");
                break;
            }
            case "fa_assetsplitbill": {
                this.checkUnauditChangeApplyBill("assetsplitentry", "realcard");
                break;
            }
            case "fa_mergebill": {
                this.checkUnauditChangeApplyBill("inentryentity", "inrealcard");
                this.checkUnauditChangeApplyBillOnMerge("outentryentity", "outrealcard");
                break;
            }
            case "fa_asset_drawback": {
                this.checkUnauditChangeApplyBill("assetdrawbackentry", "realcard");
                break;
            }
            case "fa_asset_transfer": {
                this.checkUnauditChangeApplyBill("assettransferentry", "realcard");
                break;
            }
            case "fa_asset_requisition": {
                this.checkUnauditChangeApplyBill("entryentity", "real_card");
                break;
            }
            case "fa_card_fin": {
                if ("unaudit".equals(this.getOperateKey())) {
                    this.checkUnauditChangeApplyBillOnRealCard(false);
                    break;
                }
            }
            case "fa_initcard_fin": {
                this.checkUnauditChangeApplyBillOnRealCard(false);
                break;
            }
        }
    }

    private void checkUnauditChangeApplyBillOnRealCard(boolean isRealCard) {
        ArrayList<Long> realCardIds = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            if (isRealCard) {
                realCardIds.add(entity.getDataEntity().getLong("id"));
                continue;
            }
            realCardIds.add(entity.getDataEntity().getDynamicObject("realcard").getLong("id"));
        }
        QFilter qFilter0 = new QFilter("bizstatus", "=", (Object)"A");
        QFilter qFilter2 = new QFilter("main_changebillentry.realcard.id", "in", realCardIds);
        DynamicObjectCollection existRealCard = QueryServiceHelper.query((String)"fa_change_apply", (String)"main_changebillentry.realcard.id realcardid", (QFilter[])new QFilter[]{qFilter0, qFilter2});
        ArrayList<Long> existRealCardIds = new ArrayList<Long>();
        for (DynamicObject card : existRealCard) {
            existRealCardIds.add(card.getLong("realcardid"));
        }
        for (ExtendedDataEntity entity : this.dataEntities) {
            Long id = isRealCard ? entity.getDataEntity().getLong("id") : entity.getDataEntity().getDynamicObject("realcard").getLong("id");
            if (!existRealCardIds.contains(id)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff1a%1$s\u5b58\u5728\u672a\u751f\u6210\u53d8\u66f4\u5355\u7684\u53d8\u66f4\u7533\u8bf7\u5355\u3002", (String)"FaChangeApplyValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), entity.getDataEntity().getString("number"));
            this.addErrorMessage(entity, msg);
        }
    }

    private void checkUnauditChangeApplyBill(String entryEntityKey, String realCardField) {
        ArrayList<Long> realCardIds = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObjectCollection entry = entity.getDataEntity().getDynamicObjectCollection(entryEntityKey);
            for (DynamicObject entryItem : entry) {
                DynamicObject entryRealCard = entryItem.getDynamicObject(realCardField);
                if (entryRealCard == null) continue;
                realCardIds.add(entryRealCard.getLong("id"));
            }
        }
        if (!realCardIds.isEmpty()) {
            QFilter qFilter0 = new QFilter("bizstatus", "=", (Object)"A");
            QFilter qFilter2 = new QFilter("main_changebillentry.realcard.id", "in", realCardIds);
            DynamicObjectCollection existRealCard = QueryServiceHelper.query((String)"fa_change_apply", (String)"main_changebillentry.realcard.id realcardid", (QFilter[])new QFilter[]{qFilter0, qFilter2});
            ArrayList<Long> existRealCardIds = new ArrayList<Long>();
            for (DynamicObject card : existRealCard) {
                existRealCardIds.add(card.getLong("realcardid"));
            }
            block3: for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObjectCollection entry = entity.getDataEntity().getDynamicObjectCollection(entryEntityKey);
                for (DynamicObject entryItem : entry) {
                    DynamicObject realCard = entryItem.getDynamicObject(realCardField);
                    if (realCard == null || !existRealCardIds.contains(realCard.getLong("id"))) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff1a%1$s\u5b58\u5728\u672a\u751f\u6210\u53d8\u66f4\u5355\u7684\u53d8\u66f4\u7533\u8bf7\u5355\u3002", (String)"FaChangeApplyValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), entryItem.getDynamicObject(realCardField).getString("number"));
                    this.addErrorMessage(entity, msg);
                    continue block3;
                }
            }
        }
    }

    private void checkUnauditChangeApplyBillOnMerge(String entryEntityKey, String realCardField) {
        ArrayList<Long> realCardIds = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObjectCollection entry = ((DynamicObject)entity.getDataEntity().getDynamicObjectCollection("inentryentity").get(0)).getDynamicObjectCollection(entryEntityKey);
            for (DynamicObject entryItem : entry) {
                DynamicObject entryRealCard = entryItem.getDynamicObject(realCardField);
                if (entryRealCard == null) continue;
                realCardIds.add(entryRealCard.getLong("id"));
            }
        }
        if (!realCardIds.isEmpty()) {
            QFilter qFilter0 = new QFilter("bizstatus", "=", (Object)"A");
            QFilter qFilter2 = new QFilter("main_changebillentry.realcard.id", "in", realCardIds);
            DynamicObjectCollection existRealCard = QueryServiceHelper.query((String)"fa_change_apply", (String)"main_changebillentry.realcard.id realcardid", (QFilter[])new QFilter[]{qFilter0, qFilter2});
            ArrayList<Long> existRealCardIds = new ArrayList<Long>();
            for (DynamicObject card : existRealCard) {
                existRealCardIds.add(card.getLong("realcardid"));
            }
            block3: for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObjectCollection entry = ((DynamicObject)entity.getDataEntity().getDynamicObjectCollection("inentryentity").get(0)).getDynamicObjectCollection(entryEntityKey);
                for (DynamicObject entryItem : entry) {
                    if (!existRealCardIds.contains(entryItem.getDynamicObject(realCardField).getLong("id"))) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff1a%1$s\u5b58\u5728\u672a\u751f\u6210\u53d8\u66f4\u5355\u7684\u53d8\u66f4\u7533\u8bf7\u5355\u3002", (String)"FaChangeApplyValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), entryItem.getDynamicObject(realCardField).getString("number"));
                    this.addErrorMessage(entity, msg);
                    continue block3;
                }
            }
        }
    }
}

