/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.Fa;

public class FaProductLineValidator
extends AbstractValidator {
    private static final List<String> OP_KEY = Arrays.asList("save", "submit", "assetcardinitsave");
    private static final Map<String, ThreeTuple<String, String, String>> BILL_MAP = new HashMap<String, ThreeTuple<String, String, String>>(5);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        String operateKey = this.getOperateKey();
        String entity = this.getEntityKey();
        ThreeTuple<String, String, String> threeTuple = BILL_MAP.get(entity);
        if (!OP_KEY.contains(operateKey) || threeTuple == null) {
            return;
        }
        String mainOrgField = (String)threeTuple.item1;
        String entryField = (String)threeTuple.item2;
        String productLineField = (String)threeTuple.item3;
        String productLineIdField = Fa.dot((String[])new String[]{productLineField, "id"});
        String productLineNumberField = Fa.dot((String[])new String[]{productLineField, "number"});
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            String message;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject mainOrg = bill.getDynamicObject(mainOrgField);
            Set<Long> validProductLines = this.getProductLine(bill, entryField, productLineIdField, mainOrg.getLong("id"));
            if (StringUtils.isNotEmpty((String)entryField)) {
                DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
                for (DynamicObject entry : entries) {
                    message = this.checkProductLine(entry, productLineNumberField, productLineIdField, validProductLines);
                    if (message == null) continue;
                    this.addErrorMessage(dataEntity, message);
                }
                continue;
            }
            message = this.checkProductLine(bill, productLineNumberField, productLineIdField, validProductLines);
            if (message == null) continue;
            this.addErrorMessage(dataEntity, message);
        }
    }

    private Set<Long> getProductLine(DynamicObject bill, String entryField, String productLineIdField, long mainOrgId) {
        long productLineId;
        HashSet<Long> productLineIds = new HashSet<Long>(16);
        if (StringUtils.isNotEmpty((String)entryField)) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
            for (DynamicObject entry : entries) {
                productLineId = entry.getLong(productLineIdField);
                if (productLineId == 0L) continue;
                productLineIds.add(productLineId);
            }
        } else {
            productLineId = bill.getLong(productLineIdField);
            if (productLineId != 0L) {
                productLineIds.add(productLineId);
            }
        }
        if (productLineIds.size() == 0) {
            return new HashSet<Long>(0);
        }
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_productline", (Long)mainOrgId);
        QFilter idFilter = new QFilter("id", "in", productLineIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_productline", (String)"id", (QFilter[])new QFilter[]{acctFilter, idFilter, enableFilter});
        HashSet<Long> validProductLines = new HashSet<Long>(collection.size());
        for (DynamicObject productLine : collection) {
            validProductLines.add(productLine.getLong("id"));
        }
        return validProductLines;
    }

    private String checkProductLine(DynamicObject dynamicObject, String productLineNumberField, String productLineIdField, Set<Long> validProductLines) {
        long productLineId = dynamicObject.getLong(productLineIdField);
        if (productLineId != 0L && !validProductLines.contains(productLineId)) {
            String productLineNumber = dynamicObject.getString(productLineNumberField);
            return String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ebf%s\u4e0d\u5728\u53ef\u7528\u8303\u56f4\u5185\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaProductLineValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), productLineNumber);
        }
        return null;
    }

    static {
        BILL_MAP.put("fa_engineeringbill", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"assetunit", (Object)"assetsentryadd", (Object)"productline"));
        BILL_MAP.put("fa_card_real", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"assetunit", (Object)"", (Object)"productline"));
        BILL_MAP.put("fa_asset_card", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"org", (Object)"", (Object)"productline"));
        BILL_MAP.put("fa_initcard_real", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"assetunit", (Object)"", (Object)"productline"));
        BILL_MAP.put("fa_asset_initcard", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"org", (Object)"", (Object)"productline"));
    }
}

