/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.common.util.Tuple;

public class FaPurchaseBillMaterialAndProductLineValidator
extends AbstractValidator {
    private static final List<String> OP_KEY = Arrays.asList("save", "submit");

    public void validate() {
        String operateKey = this.getOperateKey();
        if (OP_KEY.contains(operateKey)) {
            ExtendedDataEntity[] dataEntities;
            String entity = this.getEntityKey();
            if (!"fa_purchasebill".equals(entity)) {
                return;
            }
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject purchaseBill = dataEntity.getDataEntity();
                DynamicObject assetUnit = purchaseBill.getDynamicObject("assetunit");
                DynamicObjectCollection assetEntry = purchaseBill.getDynamicObjectCollection("assetsentry");
                Tuple<Set<Long>, Set<Long>> tuple = this.getMaterialAndProductLine(assetEntry, assetUnit.getLong("id"));
                Set validMaterials = (Set)tuple.item1;
                Set validProductLines = (Set)tuple.item2;
                for (DynamicObject entry : assetEntry) {
                    long materialId;
                    String message;
                    long productLineId = entry.getLong("productline.id");
                    if (productLineId != 0L && !validProductLines.contains(productLineId)) {
                        message = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ebf\u4e0d\u5728\u53ef\u7528\u8303\u56f4\u5185\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaPurchaseBillMaterialAndProductLineValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, message);
                    }
                    if ((materialId = entry.getLong("materielfield.id")) == 0L || validMaterials.contains(materialId)) continue;
                    message = ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u5728\u53ef\u7528\u8303\u56f4\u5185\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaPurchaseBillMaterialAndProductLineValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, message);
                }
            }
        }
    }

    public Tuple<Set<Long>, Set<Long>> getMaterialAndProductLine(DynamicObjectCollection entries, long assetUnitId) {
        HashSet<Long> materialIds = new HashSet<Long>(entries.size());
        HashSet<Long> productLineIds = new HashSet<Long>(entries.size());
        for (DynamicObject entry : entries) {
            long productLineId;
            long materialId = entry.getLong("materielfield.id");
            if (materialId != 0L) {
                materialIds.add(materialId);
            }
            if ((productLineId = entry.getLong("productline.id")) == 0L) continue;
            productLineIds.add(productLineId);
        }
        if (materialIds.size() == 0 && productLineIds.size() == 0) {
            return new Tuple(new HashSet(0), new HashSet(0));
        }
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)assetUnitId);
        QFilter idFilter = new QFilter("id", "in", materialIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_material", (String)"id", (QFilter[])new QFilter[]{acctFilter, idFilter, enableFilter});
        HashSet<Long> validMaterials = new HashSet<Long>(collection.size());
        for (DynamicObject material : collection) {
            validMaterials.add(material.getLong("id"));
        }
        acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_productline", (Long)assetUnitId);
        idFilter = new QFilter("id", "in", productLineIds);
        collection = QueryServiceHelper.query((String)"bd_productline", (String)"id", (QFilter[])new QFilter[]{acctFilter, idFilter, enableFilter});
        HashSet<Long> validProductLines = new HashSet<Long>(collection.size());
        for (DynamicObject productLine : collection) {
            validProductLines.add(productLine.getLong("id"));
        }
        return new Tuple(validMaterials, validProductLines);
    }
}

