/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.workload;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class FaWorkLoadBatchSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(FaWorkLoadBatchSaveValidator.class);

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            Set billNumbers;
            DynamicObject dyn = entity.getDataEntity();
            DynamicObject org = dyn.getDynamicObject("org");
            if (org == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"FaWorkLoadBatchSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long orgId = org.getLong("id");
            DynamicObject depreUse = dyn.getDynamicObject("depreuse");
            if (depreUse == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6298\u65e7\u7528\u9014\u201d\u3002", (String)"FaWorkLoadBatchSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long depreUseId = depreUse.getLong("id");
            DynamicObject period = dyn.getDynamicObject("period");
            if (period == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u671f\u95f4\u201d\u3002", (String)"FaWorkLoadBatchSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long periodId = period.getLong("id");
            DynamicObject book = FaBizUtils.getAsstBookByOrgAndDepreuse((Long)orgId, (Long)depreUseId, (String)Fa.comma((String[])new String[]{"id", "startperiod"}));
            if (book == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u3001\u6298\u65e7\u7528\u9014\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaWorkLoadBatchSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entry = dyn.getDynamicObjectCollection("workloadentry");
            HashSet<Long> selectedCardId = new HashSet<Long>(entry.size());
            HashSet<DynamicObject> selectedCards = new HashSet<DynamicObject>(entry.size());
            for (DynamicObject row : entry) {
                DynamicObject realCard = row.getDynamicObject("realcard");
                if (realCard == null) continue;
                selectedCards.add(realCard);
                long realCardId = realCard.getLong("id");
                selectedCardId.add(realCardId);
            }
            Set<Long> statusNotDepreCardId = this.queryStatusNotDepreCard(selectedCardId);
            Set<Long> policyNotDepreCards = this.queryPolicyNotDepreCards(book, selectedCards);
            Set<Long> existRealCardId = this.queryExistWorkLoadCard(orgId, depreUseId, periodId, selectedCardId);
            Map<Long, DynamicObject> realFinCardMap = this.queryRealFinCardMap(orgId, depreUseId, periodId, selectedCardId);
            Map<Long, Tuple<BigDecimal, BigDecimal>> workLoadMap = this.queryCardWorkLoadRange(periodId, realFinCardMap.values());
            for (int seq = 0; seq < entry.size(); ++seq) {
                DynamicObject row = (DynamicObject)entry.get(seq);
                DynamicObject realCard = row.getDynamicObject("realcard");
                if (realCard == null) continue;
                long realCardId = realCard.getLong("id");
                if (statusNotDepreCardId.contains(realCardId)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5361\u7247\u7684\u4f7f\u7528\u72b6\u6001\u4e0d\u53c2\u4e0e\u8ba1\u63d0\uff0c\u4e0d\u80fd\u7ef4\u62a4\u672c\u671f\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkLoadBatchSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq + 1));
                    continue;
                }
                if (policyNotDepreCards.contains(realCardId)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5361\u7247\u7684\u653f\u7b56\u4e0d\u53c2\u4e0e\u8ba1\u63d0\uff0c\u4e0d\u80fd\u7ef4\u62a4\u672c\u671f\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkLoadBatchSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq + 1));
                    continue;
                }
                if (existRealCardId.contains(realCardId)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5361\u7247\u5728\u672c\u8d44\u4ea7\u8d26\u7c3f\u6240\u5728\u671f\u95f4\u5185\u5df2\u7ef4\u62a4\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkLoadBatchSaveValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq + 1));
                    continue;
                }
                Iterator finCard = realFinCardMap.get(realCardId);
                String depreMethodType = finCard.getString("depremethod.type");
                if (!"5".equals(depreMethodType)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5361\u7247\u7684\u6298\u65e7\u65b9\u6cd5\u4e0d\u662f\u5de5\u4f5c\u91cf\u6cd5\u3002", (String)"FaWorkLoadBatchSaveValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq + 1));
                    continue;
                }
                Tuple<BigDecimal, BigDecimal> range = workLoadMap.get(realCardId);
                BigDecimal minWorkLoad = (BigDecimal)range.item1;
                BigDecimal maxWorkLoad = (BigDecimal)range.item2;
                BigDecimal workLoad = row.getBigDecimal("workload");
                Object workLoadUnit = row.get("workloadunitid");
                if (Objects.isNull(workLoadUnit) && workLoad.setScale(0, RoundingMode.UP).compareTo(workLoad) != 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5361\u7247\u7684\u672c\u671f\u5de5\u4f5c\u91cf\u5fc5\u987b\u662f\u6574\u6570\u3002", (String)"FaWorkLoadBatchSaveValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq + 1));
                }
                if (workLoad.compareTo(maxWorkLoad) > 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u672c\u671f\u5de5\u4f5c\u91cf+\u671f\u521d\u7d2f\u8ba1\u5de5\u4f5c\u91cf\uff0c\u4e0d\u80fd\u8d85\u8fc7\u9884\u8ba1\u603b\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkLoadBatchSaveValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq + 1));
                }
                if (workLoad.compareTo(minWorkLoad) >= 0) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u672c\u671f\u5de5\u4f5c\u91cf+\u671f\u521d\u7d2f\u8ba1\u5de5\u4f5c\u91cf\uff0c\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"FaWorkLoadBatchSaveValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq + 1));
            }
            DynamicObject assetBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg((Object)orgId);
            DynamicObject curPeriodDy = assetBook.getDynamicObject("curperiod");
            Date endDate = curPeriodDy.getDate("enddate");
            DynamicObjectCollection realEntry = dyn.getDynamicObjectCollection("workloadentry");
            HashMap<Long, String> realId2numberMap = new HashMap<Long, String>(entry.size(), 1.0f);
            for (DynamicObject entryDy : realEntry) {
                realId2numberMap.put(entryDy.getLong(Fa.id((String)"realcard")), entryDy.getString("realcard.number"));
            }
            Set billNos = FaChangeBillUtil.getGenVoucherChangeBillNo((Long)orgId, (Date)endDate, realId2numberMap.keySet());
            if (billNos != null && billNos.size() > 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u53d8\u66f4\u5355%s\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"FaWorkLoadBatchSaveValidator_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNos.toString()));
            }
            if ((billNumbers = FaChangeBillUtil.checkhaveFutureRealChangeBill((Long)orgId, (Date)endDate, realId2numberMap)) == null || billNumbers.size() <= 0) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801%s\u5b58\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\uff0c\u5f00\u542f\"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\"\u76f8\u5e94\u53c2\u6570\u6216\u5220\u9664\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u3002", (String)"FaWorkLoadBatchSaveValidator_12", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNumbers.toString()));
        }
    }

    private Set<Long> queryStatusNotDepreCard(Set<Long> realCardIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", realCardIds), new QFilter("usestatus.isdepre", "=", (Object)"0")};
        DynamicObjectCollection notDepreCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])filters);
        return notDepreCards.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> queryPolicyNotDepreCards(DynamicObject book, Set<DynamicObject> realCards) {
        long bookId = book.getLong("id");
        List policyEntry = AssetPolicyUtil.getAssetPolicyInfoByBookId((Object)bookId);
        HashSet<Long> noDepreCardIds = new HashSet<Long>(realCards.size());
        for (DynamicObject card : realCards) {
            DynamicObject assetCat = card.getDynamicObject("assetcat");
            assetCat = BusinessDataServiceHelper.loadSingleFromCache((Object)assetCat.getPkValue(), (String)"fa_assetcategory", (String)"longnumber");
            String catLongNumber = assetCat.getString("longnumber");
            DynamicObject policyRow = null;
            for (Tuple row : policyEntry) {
                if (catLongNumber.indexOf((String)row.item1) != 0) continue;
                policyRow = (DynamicObject)row.item2;
                break;
            }
            if (policyRow == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d44\u4ea7\u7c7b\u522b\u3010%s\u3011\u5bf9\u5e94\u7684\u6298\u65e7\u653f\u7b56\u3002", (String)"FaWorkLoadBatchSaveValidator_13", (String)"fi-fa-opplugin", (Object[])new Object[0]), catLongNumber));
            }
            boolean noDepre = policyRow.getBoolean("nodepre");
            if (!noDepre) continue;
            noDepreCardIds.add(card.getLong("id"));
        }
        return noDepreCardIds;
    }

    private Set<Long> queryExistWorkLoadCard(long orgId, long depreUseId, long periodId, Set<Long> realCardIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("period", "=", (Object)periodId), new QFilter("realcard", "in", realCardIds)};
        DynamicObjectCollection existWorkLoad = QueryServiceHelper.query((String)"fa_workload", (String)"realcard", (QFilter[])filters);
        return existWorkLoad.stream().map(v -> v.getLong("realcard")).collect(Collectors.toSet());
    }

    private Map<Long, DynamicObject> queryRealFinCardMap(long orgId, long depreUseId, long periodId, Set<Long> realCardIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("realcardmasterid", "in", realCardIds), new QFilter("bizperiod", "<=", (Object)periodId), new QFilter("endperiod", ">", (Object)periodId)};
        String selectFields = Fa.comma((String[])new String[]{"preusingamount", "depredamount", "addidepreamount", "realcard", "realcardmasterid", "bizperiod", "depremethod.type"});
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])filters);
        return finCards.stream().collect(Collectors.toMap(v -> v.getLong("realcardmasterid"), v -> v));
    }

    private Map<Long, Tuple<BigDecimal, BigDecimal>> queryCardWorkLoadRange(long periodId, Collection<DynamicObject> finCards) {
        HashMap<Long, Tuple<BigDecimal, BigDecimal>> workLoadMap = new HashMap<Long, Tuple<BigDecimal, BigDecimal>>(finCards.size());
        for (DynamicObject finCard : finCards) {
            BigDecimal maxWorkLoad;
            BigDecimal minWorkLoad;
            long realCardId = finCard.getLong("realcardmasterid");
            BigDecimal preTotalWorkLoad = finCard.getBigDecimal("preusingamount");
            BigDecimal accumWorkLoad = finCard.getBigDecimal("depredamount");
            BigDecimal monthWorkLoad = finCard.getBigDecimal("addidepreamount");
            long bizPeriodId = finCard.getLong("bizperiod");
            if (bizPeriodId == 0L || bizPeriodId != periodId) {
                minWorkLoad = accumWorkLoad.negate();
                maxWorkLoad = preTotalWorkLoad.subtract(accumWorkLoad);
            } else {
                minWorkLoad = accumWorkLoad.subtract(monthWorkLoad).negate();
                maxWorkLoad = preTotalWorkLoad.subtract(accumWorkLoad).add(monthWorkLoad);
            }
            Tuple range = new Tuple((Object)minWorkLoad, (Object)maxWorkLoad);
            workLoadMap.put(realCardId, (Tuple<BigDecimal, BigDecimal>)range);
        }
        logger.info("\u5de5\u4f5c\u91cf\u4fdd\u5b58\u6821\u9a8c\u2014\u2014\u5361\u7247\u53ef\u5f55\u5165\u5de5\u4f5c\u91cf\u8303\u56f4Map\uff1a" + ((Object)workLoadMap).toString());
        return workLoadMap;
    }
}

