/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.workload;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.common.util.Fa;

public class FaWorkloadSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
            Set billNumbers;
            String depreMethodType;
            BigDecimal maxWorkLoad;
            BigDecimal minWorkLoad;
            DynamicObject data = entity.getDataEntity();
            DynamicObject org = data.getDynamicObject("org");
            if (org == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"FaWorkloadSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long orgId = org.getLong("id");
            DynamicObject depreUse = data.getDynamicObject("depreuse");
            if (depreUse == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6298\u65e7\u7528\u9014\u201d\u3002", (String)"FaWorkloadSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long depreUseId = depreUse.getLong("id");
            DynamicObject period = data.getDynamicObject("period");
            if (period == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u671f\u95f4\u201d\u3002", (String)"FaWorkloadSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long periodId = period.getLong("id");
            DynamicObject realCard = data.getDynamicObject("realcard");
            if (realCard == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u3002", (String)"FaWorkloadSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long realCardId = realCard.getLong("id");
            long useStatusId = realCard.getDynamicObject("usestatus").getLong("id");
            DynamicObject useStatus = BusinessDataServiceHelper.loadSingleFromCache((Object)useStatusId, (String)"fa_usestatus", (String)"isdepre");
            boolean isDepre = useStatus.getBoolean("isdepre");
            if (!isDepre) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5361\u7247\u7684\u4f7f\u7528\u72b6\u6001\u4e0d\u53c2\u4e0e\u8ba1\u63d0\uff0c\u4e0d\u80fd\u7ef4\u62a4\u672c\u671f\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkloadSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject book = FaBizUtils.getAsstBookByOrgAndDepreuse((Long)orgId, (Long)depreUseId, (String)Fa.comma((String[])new String[]{"id", "curperiod"}));
            if (book == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u3001\u6298\u65e7\u7528\u9014\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaWorkloadSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long bookId = book.getLong("id");
            long assetCatId = realCard.getDynamicObject("assetcat").getLong("id");
            DynamicObject policyRow = AssetPolicyUtil.getByBookAndCat((Object)bookId, (Object)assetCatId);
            boolean noDepre = policyRow.getBoolean("nodepre");
            if (noDepre) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5361\u7247\u7684\u653f\u7b56\u4e0d\u53c2\u4e0e\u8ba1\u63d0\uff0c\u4e0d\u80fd\u7ef4\u62a4\u672c\u671f\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkloadSaveValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            long curPeriodId = book.getLong("curperiod");
            if (periodId != curPeriodId) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53ea\u80fd\u5f55\u5165\u5f53\u524d\u671f\u95f4\u7684\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkloadSaveValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            HashSet<Long> realCardIdSet = new HashSet<Long>();
            realCardIdSet.add(realCardId);
            Date date = data.getDate("date");
            Optional checkResult = new FutureBizChecker(null, (Object)orgId, realCardIdSet, date, BusyTypeDetailEnum.FIN_CHG).check();
            if (checkResult.isPresent()) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff1a%s", (String)"FaWorkloadSaveValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get()));
                continue;
            }
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("realcardmasterid", "=", (Object)realCardId), new QFilter("bizperiod", "<=", (Object)periodId), new QFilter("endperiod", ">", (Object)periodId)};
            String selectFields = Fa.comma((String[])new String[]{"preusingamount", "depredamount", "addidepreamount", "depremethod.type", "bizperiod"});
            DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)selectFields, (QFilter[])filters);
            if (finCard == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b9e\u7269\u5361\u7247\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"FaWorkloadSaveValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            BigDecimal preTotalWorkLoad = finCard.getBigDecimal("preusingamount");
            BigDecimal accumWorkLoad = finCard.getBigDecimal("depredamount");
            BigDecimal monthWorkLoad = finCard.getBigDecimal("addidepreamount");
            long bizPeriodId = finCard.getLong("bizperiod");
            if (bizPeriodId == 0L || bizPeriodId != periodId) {
                minWorkLoad = accumWorkLoad.negate();
                maxWorkLoad = preTotalWorkLoad.subtract(accumWorkLoad);
            } else {
                minWorkLoad = accumWorkLoad.subtract(monthWorkLoad).negate();
                maxWorkLoad = preTotalWorkLoad.subtract(accumWorkLoad).add(monthWorkLoad);
            }
            BigDecimal workLoad = data.getBigDecimal("workload");
            Object workLoadUnit = data.get("workloadunitid");
            if (Objects.isNull(workLoadUnit) && workLoad.setScale(0, RoundingMode.UP).compareTo(workLoad) != 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5361\u7247\u7684\u672c\u671f\u5de5\u4f5c\u91cf\u5fc5\u987b\u662f\u6574\u6570\u3002", (String)"FaWorkloadSaveValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (workLoad.compareTo(maxWorkLoad) > 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u672c\u671f\u5de5\u4f5c\u91cf+\u671f\u521d\u7d2f\u8ba1\u5de5\u4f5c\u91cf\uff0c\u4e0d\u80fd\u8d85\u8fc7\u9884\u8ba1\u603b\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkloadSaveValidator_11", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (workLoad.compareTo(minWorkLoad) < 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u672c\u671f\u5de5\u4f5c\u91cf+\u671f\u521d\u7d2f\u8ba1\u5de5\u4f5c\u91cf\uff0c\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"FaWorkloadSaveValidator_12", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (!"5".equals(depreMethodType = finCard.getString("depremethod.type"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5361\u7247\u7684\u6298\u65e7\u65b9\u6cd5\u4e0d\u662f\u5de5\u4f5c\u91cf\u6cd5\u3002", (String)"FaWorkloadSaveValidator_13", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            Date endDate = period.getDate("enddate");
            HashMap<Long, String> realId2numberMap = new HashMap<Long, String>(1, 1.0f);
            realId2numberMap.put(realCardId, realCard.getString("number"));
            Set billNos = FaChangeBillUtil.getGenVoucherChangeBillNo((Long)orgId, (Date)endDate, realId2numberMap.keySet());
            if (billNos != null && billNos.size() > 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u53d8\u66f4\u5355%s\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"FaWorkloadSaveValidator_14", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNos.toString()));
            }
            if ((billNumbers = FaChangeBillUtil.checkhaveFutureRealChangeBill((Long)orgId, (Date)endDate, realId2numberMap)) == null || billNumbers.size() <= 0) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801%s\u5b58\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\uff0c\u5f00\u542f\"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\"\u76f8\u5e94\u53c2\u6570\u6216\u5220\u9664\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u3002", (String)"FaWorkloadSaveValidator_15", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNumbers.toString()));
        }
    }
}

