/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaAssetCardUtils {
    public static DynamicObject[] getFinCardsForOperate(OperateOption option, Object[] realCardIds, List<DynamicObject> assetCardFinList) {
        boolean containsFinInfo = option.containsVariable("assetCardFinInfo");
        if (containsFinInfo) {
            String depreUseFinCardStr = option.getVariableValue("assetCardFinInfo");
            Map depreUseFinCardMap = (Map)SerializationUtils.deSerializeFromBase64((String)depreUseFinCardStr);
            return depreUseFinCardMap.values().toArray(new DynamicObject[0]);
        }
        List finCardIds = assetCardFinList.stream().map(card -> card.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection dbFinCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", finCardIds)});
        Set dbFinCardIds = dbFinCards.stream().map(row -> row.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject finCard : assetCardFinList) {
            boolean fromDatabase = finCard.getDataEntityState().getFromDatabase();
            long finCardId = finCard.getLong("id");
            if (fromDatabase || !dbFinCardIds.contains(finCardId)) continue;
            String number = finCard.getString("number");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u6570\u636e\u6765\u81ea\u7f13\u5b58\uff0c\u4e0d\u662f\u6700\u65b0\u6570\u636e\uff0c\u8bf7\u6e05\u9664\u7f13\u5b58\u540e\u518d\u8bd5\u3002id[%1$s]\uff0c\u8d44\u4ea7\u7f16\u7801[%2$s]", (String)"FaAssetCardUtils_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), finCardId, number));
        }
        return assetCardFinList.toArray(new DynamicObject[0]);
    }

    public static void updateAssetCardFinEntry4FinSave(DynamicObject[] finCards) {
        Set realCardIds = Arrays.stream(finCards).map(v -> v.getLong(Fa.id((String)"realcard"))).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "in", realCardIds)};
        String selectFields = Fa.comma((String[])new String[]{"id", "realcard"});
        String orderBy = "realcard, assetbook.ismainbook desc";
        DynamicObjectCollection finCardList = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])filters, (String)orderBy);
        long[] entryIdArr = DBServiceHelper.genLongIds((String)"t_fa_asset_finentry", (int)finCardList.size());
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(finCardList.size());
        long lastRealCardId = 0L;
        int seq = 1;
        for (int i = 0; i < finCardList.size(); ++i) {
            DynamicObject finCard = (DynamicObject)finCardList.get(i);
            long realCardId = finCard.getLong("realcard");
            long finCardId = finCard.getLong("id");
            seq = realCardId != lastRealCardId ? 1 : ++seq;
            insertParams.add(new Object[]{realCardId, entryIdArr[i], seq, finCardId, finCardId});
            lastRealCardId = realCardId;
        }
        SqlBuilder deleteHisDataSql = new SqlBuilder();
        deleteHisDataSql.append("delete from t_fa_asset_finentry where ", new Object[0]);
        deleteHisDataSql.appendIn(" fid ", realCardIds.toArray());
        String insertNewDataSql = "insert into t_fa_asset_finentry(fid, fentryid, fseq, ffincardid, foriginalfincardid) values (?, ?, ?, ?, ?);";
        try (TXHandle h = TX.required();){
            try {
                DBRoute dbRoute = DBRoute.of((String)"fa");
                DB.execute((DBRoute)dbRoute, (SqlBuilder)deleteHisDataSql);
                DB.executeBatch((DBRoute)dbRoute, (String)insertNewDataSql, insertParams);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void deleteAssetCardFinEntry4FinDelete(DynamicObject[] finCards) {
        if (finCards == null || finCards.length == 0) {
            return;
        }
        ArrayList<Long> bakRealCardIds = new ArrayList<Long>(finCards.length);
        for (DynamicObject finCard : finCards) {
            long endPeriodId = finCard.getLong(Fa.id((String)"endperiod"));
            if (99999999999L == endPeriodId) continue;
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            bakRealCardIds.add(realCardId);
        }
        QFilter[] finFilters = new QFilter[]{new QFilter("realcard", "in", bakRealCardIds), new QFilter("endperiod", "=", (Object)99999999999L)};
        String selectFields = Fa.comma((String[])new String[]{"id", "depreuse", "realcard"});
        DynamicObjectCollection newFinCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])finFilters);
        HashMap<String, Long> newFinCardMap = new HashMap<String, Long>(finCards.length);
        for (DynamicObject[] finCard : newFinCards) {
            long finCardId = finCard.getLong("id");
            long depreUseId = finCard.getLong("depreuse");
            long realCardId = finCard.getLong("realcard");
            newFinCardMap.put(realCardId + "_" + depreUseId, finCardId);
        }
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>(finCards.length);
        for (DynamicObject finCard : finCards) {
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            long finCardId = finCard.getLong("id");
            long endPeriodId = finCard.getLong(Fa.id((String)"endperiod"));
            if (99999999999L != endPeriodId) {
                long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
                Long newFinCardId = (Long)newFinCardMap.get(realCardId + "_" + depreUseId);
                if (newFinCardId != null) {
                    finCardId = newFinCardId;
                }
            }
            deleteParams.add(new Object[]{realCardId, finCardId});
        }
        String deleteSql = "delete from t_fa_asset_finentry where fid = ? and ffincardid = ?;";
        try (TXHandle h = TX.required();){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)deleteSql, deleteParams);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

