/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.bookversion;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class AccountBookVersion {
    private static final long MAX_PERIOD = 99999999999L;
    private final AccountBookInfo accountBookInfo;
    private final Date enableDate;
    private final AccountTableRef accountTableRef;

    public AccountBookVersion(AccountBookInfo accountBookInfo, Date enableDate, AccountTableRef accountTableRef) {
        if (Objects.isNull(accountBookInfo)) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u542f\u7528\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"AccountBookVersion_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        if (Objects.isNull(enableDate)) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f\u4e0d\u5b58\u5728\u3002", (String)"AccountBookVersion_1", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        if (Objects.isNull(accountTableRef)) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"AccountBookVersion_2", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        this.accountBookInfo = accountBookInfo;
        this.enableDate = enableDate;
        this.accountTableRef = accountTableRef;
    }

    public final void enable() {
        DynamicObject[] oldRecords;
        Object[] bookSave;
        DynamicObject periodDO = GLUtil.getPeriodByDate(this.enableDate, this.accountBookInfo.getPeriodTypeId());
        if (Objects.isNull(periodDO)) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"AccountBookVersion_3", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        long enablePeriod = periodDO.getLong("id");
        DynamicObject accountBookDO = BusinessDataServiceHelper.loadSingle((Object)this.accountBookInfo.getId(), (String)"gl_accountbook");
        long newAccountTableId = this.accountTableRef.getNewAccountTableId();
        long curYearAccountId = accountBookDO.getLong(GLField.id_("yearprofitacct"));
        Long newYearAccountId = this.accountTableRef.getNewAccountId(Long.valueOf(curYearAccountId));
        if (newAccountTableId == this.accountBookInfo.getAccountTableId()) {
            return;
        }
        accountBookDO.set("accounttable", (Object)newAccountTableId);
        if (curYearAccountId != 0L) {
            if (!Objects.isNull(newYearAccountId)) {
                accountBookDO.set("yearprofitacct", (Object)newYearAccountId);
            } else {
                accountBookDO.set("yearprofitacct", (Object)0L);
            }
        }
        if ((bookSave = BusinessDataWriter.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_accountbook"), (Object[])new DynamicObject[]{accountBookDO})).length != 1) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u8d26\u7c3f\u4fdd\u5b58\u5931\u8d25", (String)"AccountBookVersion_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        DynamicObject bookVersionDO = BusinessDataServiceHelper.newDynamicObject((String)"gl_book_version");
        bookVersionDO.set("org", (Object)this.accountBookInfo.getOrgId());
        bookVersionDO.set("booktype", (Object)this.accountBookInfo.getBookTypeId());
        bookVersionDO.set("oldaccttab", (Object)this.accountTableRef.getOldAccountTableId());
        bookVersionDO.set("accounttable", (Object)newAccountTableId);
        bookVersionDO.set("oldyearacct", (Object)curYearAccountId);
        bookVersionDO.set("yearprofitacct", (Object)newYearAccountId);
        bookVersionDO.set("enabledate", (Object)this.enableDate);
        bookVersionDO.set("disabledate", (Object)GLUtil.getEndDate());
        bookVersionDO.set("disableperiod", (Object)99999999999L);
        bookVersionDO.set("enableperiod", (Object)enablePeriod);
        bookVersionDO.set("createdate", (Object)new Date());
        Object[] saveResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bookVersionDO});
        if (saveResult.length != 1) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u8d26\u7c3f\u79d1\u76ee\u8868\u53d8\u66f4\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AccountBookVersion_5", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        QFBuilder builder = new QFBuilder();
        builder.add("org", "=", this.accountBookInfo.getOrgId());
        builder.add("booktype", "=", this.accountBookInfo.getBookTypeId());
        builder.add("accounttable", "=", this.accountBookInfo.getAccountTableId());
        builder.add("disabledate", "=", GLUtil.getEndDate());
        builder.add("enabledate", "<=", this.enableDate);
        for (DynamicObject oldRecord : oldRecords = BusinessDataServiceHelper.load((String)"gl_book_version", (String)String.join((CharSequence)",", "disabledate", "disableperiod"), (QFilter[])builder.toArray())) {
            oldRecord.set("disabledate", (Object)this.enableDate);
            oldRecord.set("disableperiod", (Object)enablePeriod);
        }
        if (oldRecords.length > 0 && (saveResult = SaveServiceHelper.save((DynamicObject[])oldRecords)).length != oldRecords.length) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u8d26\u7c3f\u79d1\u76ee\u8868\u53d8\u66f4\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AccountBookVersion_5", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        AccSysUtil.clearAccountBookVersionsFromCache(this.accountBookInfo.getOrgId(), this.accountBookInfo.getBookTypeId());
    }

    public final void disable() {
        DynamicObject accountBookDO = BusinessDataServiceHelper.loadSingle((Object)this.accountBookInfo.getId(), (String)"gl_accountbook");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", this.accountBookInfo.getOrgId());
        qfBuilder.add("booktype", "=", this.accountBookInfo.getBookTypeId());
        qfBuilder.add("oldaccttab", "=", this.accountTableRef.getOldAccountTableId());
        qfBuilder.add("enabledate", "=", this.enableDate);
        DynamicObject singleRecoedDO = null;
        if (this.accountTableRef.getOldAccountTableId() == this.accountTableRef.getNewAccountTableId()) {
            DynamicObject[] records;
            qfBuilder.add("accounttable", "=", this.accountTableRef.getOldAccountTableId());
            for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"gl_book_version", (String)String.join((CharSequence)",", "oldyearacct", "yearprofitacct", "disabledate"), (QFilter[])qfBuilder.toArray())) {
                long recordNewAccountId;
                long oldYearAccountId = record.getLong("oldyearacct_id");
                Long newYearAccountId = this.accountTableRef.getNewAccountId(Long.valueOf(oldYearAccountId));
                if (Objects.isNull(newYearAccountId) || !newYearAccountId.equals(recordNewAccountId = record.getLong("yearprofitacct_id"))) continue;
                if (GLUtil.getEndDate().compareTo(record.getDate("disabledate")) != 0) {
                    throw new GLException(GLErrorCode.common, String.format(ResManager.loadKDString((String)"\u8d26\u7c3fID%s\uff1a\u672c\u5e74\u5229\u6da6\u5728\u8be5\u79d1\u76ee\u7248\u672c\u5316\u4e4b\u540e\u8fdb\u884c\u8fc7\u79d1\u76ee\u8868\u6216\u5176\u4ed6\u79d1\u76ee\u7248\u672c\u5316\u3002", (String)"AccountBookVersion_6", (String)"fi-gl-common", (Object[])new Object[0]), this.accountBookInfo.getId()));
                }
                singleRecoedDO = record;
                break;
            }
        } else {
            qfBuilder.add("accounttable", "!=", this.accountTableRef.getOldAccountTableId());
            qfBuilder.add("disabledate", "=", GLUtil.getEndDate());
            singleRecoedDO = BusinessDataServiceHelper.loadSingle((String)"gl_book_version", (String)"oldaccttab,oldyearacct", (QFilter[])qfBuilder.toArray());
        }
        if (null == singleRecoedDO) {
            return;
        }
        long oldAccountTableId = singleRecoedDO.getLong(GLField.id_("oldaccttab"));
        long oldYearAccountId = singleRecoedDO.getLong(GLField.id_("oldyearacct"));
        accountBookDO.set("yearprofitacct", (Object)oldYearAccountId);
        accountBookDO.set("accounttable", (Object)oldAccountTableId);
        Object[] bookSave = BusinessDataWriter.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_accountbook"), (Object[])new DynamicObject[]{accountBookDO});
        if (bookSave.length != 1) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u8d26\u7c3f\u4fdd\u5b58\u5931\u8d25", (String)"AccountBookVersion_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_book_version"), (Object[])new Object[]{singleRecoedDO.getLong("id")});
        AccSysUtil.clearAccountBookVersionsFromCache(this.accountBookInfo.getOrgId(), this.accountBookInfo.getBookTypeId());
        qfBuilder.clear();
        qfBuilder.add("org", "=", this.accountBookInfo.getOrgId());
        qfBuilder.add("booktype", "=", this.accountBookInfo.getBookTypeId());
        qfBuilder.add("accounttable", "=", this.accountTableRef.getOldAccountTableId());
        qfBuilder.add("enabledate", "<=", this.enableDate);
        qfBuilder.add("disabledate", "=", this.enableDate);
        List lastRecordPks = QueryServiceHelper.queryPrimaryKeys((String)"gl_book_version", (QFilter[])qfBuilder.toArray(), (String)"createdate desc", (int)1);
        if (lastRecordPks.isEmpty()) {
            return;
        }
        DynamicObject lastRecord = BusinessDataServiceHelper.loadSingleFromCache(lastRecordPks.get(0), (String)"gl_book_version");
        lastRecord.set("disabledate", (Object)GLUtil.getEndDate());
        lastRecord.set("disableperiod", (Object)99999999999L);
        Object[] saveResult = SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_book_version"), (Object[])new DynamicObject[]{lastRecord});
        if (saveResult.length != 1) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u8d26\u7c3f\u79d1\u76ee\u8868\u53d8\u66f4\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AccountBookVersion_5", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        AccSysUtil.clearAccountBookVersionsFromCache(this.accountBookInfo.getOrgId(), this.accountBookInfo.getBookTypeId());
    }
}

