/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.constant;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.util.BdBusinessDataServiceHelper;
import kd.fi.gl.accountref.constant.AccountDetails;
import kd.fi.gl.accountref.constant.AccountRefContext;

public class AccountCache {
    private static final int INIT_CAPACITY = 1024;
    private static final String ENDDATE = "enddate";
    private static final String STARTDATE = "startdate";
    private static final String ASSTACTITEM_FLEXFIELD = "asstactitem.flexfield";
    private Map<Long, AccountDetails> idAndDetailsMap;
    private Map<Long, Long> masteridAndIdMap = new HashMap<Long, Long>(1024);

    public AccountCache(AccountRefContext context, boolean isOnlyAcccurrent) {
        AccountTableRef accountTableRef = context.getAcctTblRef();
        this.buildNewAccountMap(accountTableRef.getNewAccountIdSet(), isOnlyAcccurrent);
        this.buildOldAccountMap(accountTableRef.getOldAccountIdSet());
    }

    public AccountDetails getNewAccountDetails(Long accountId) {
        return this.idAndDetailsMap.get(accountId);
    }

    public Long getOldAccountId(Long masterId) {
        return this.masteridAndIdMap.get(masterId);
    }

    private void buildOldAccountMap(Collection<Long> lstAcctIds) {
        DynamicObject[] accounts = BdBusinessDataServiceHelper.load((Object[])lstAcctIds.toArray(new Long[0]), (String)String.join((CharSequence)",", "masterid", "id"), (String)"bd_accountview");
        this.masteridAndIdMap = new HashMap<Long, Long>(1024);
        for (DynamicObject account : accounts) {
            this.masteridAndIdMap.put(account.getLong("masterid"), account.getLong("id"));
        }
    }

    private void buildNewAccountMap(Collection<Long> lstAcctIds, boolean isOnlyAccurrent) {
        DynamicObject[] accounts = BusinessDataServiceHelper.load((Object[])lstAcctIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        this.idAndDetailsMap = new HashMap<Long, AccountDetails>(1024);
        for (DynamicObject account : accounts) {
            DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
            HashSet<String> lstFields = new HashSet<String>(16);
            for (DynamicObject assistRow : assistEntry) {
                String fieldName = assistRow.getString(ASSTACTITEM_FLEXFIELD);
                if (isOnlyAccurrent) {
                    Boolean enaccheck = assistRow.getBoolean("enaccheck");
                    if (!enaccheck.booleanValue()) continue;
                    lstFields.add(fieldName);
                    continue;
                }
                lstFields.add(fieldName);
            }
            AccountDetails accountDetails = new AccountDetails();
            Long masterId = account.getLong("masterid");
            accountDetails.setMasterId(masterId);
            accountDetails.setFlexFields(lstFields);
            accountDetails.setStartDate(account.getDate(STARTDATE));
            accountDetails.setEndDate(account.getDate(ENDDATE));
            Long id = account.getLong("id");
            this.idAndDetailsMap.put(id, accountDetails);
        }
    }
}

