/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.AccountCache;
import kd.fi.gl.accountref.constant.AccountRefContext;
import kd.fi.gl.accountref.constant.AcctSumBalContext;
import kd.fi.gl.accountref.constant.AssistCache;

public class SingleAccountRefContext {
    private Set<Long> oldAcctIds;
    private Map<Long, Long> vchEntryAndAssgrpMap = new HashMap<Long, Long>(1024);
    private AccountRefContext parentContext;
    private AcctSumBalContext acctSumBalCtx;
    private static final int INIT_CAPACITY = 1024;
    private Collection<AbstractBalData> oldBalDatas = new ArrayList<AbstractBalData>(1024);
    private List<AbstractBalData> insertBalDatas = new ArrayList<AbstractBalData>(1024);
    private List<AbstractBalData> updateBalDatas = new ArrayList<AbstractBalData>(1024);
    private List<AbstractBalData> deleteBalDatas = new ArrayList<AbstractBalData>(1024);
    private Map<String, List<AbstractBalData>> existNewAcctBalDatas = new HashMap<String, List<AbstractBalData>>(1024);
    private Set<String> existsFutureBalKeys = new HashSet<String>(1024);
    private Set<Long> futurePeriodIds = new TreeSet<Long>();
    private boolean isClosed = false;

    public SingleAccountRefContext(AccountRefContext accountRefContext) {
        this.parentContext = accountRefContext;
    }

    public Long getOrgId() {
        return this.parentContext.getOrgId();
    }

    public Long getBookTypeId() {
        return this.parentContext.getBookTypeId();
    }

    public Long getPeriodId() {
        return this.parentContext.getPeriodId();
    }

    public Date getDate() {
        return this.parentContext.getDate();
    }

    public Long getPrePeriodId() {
        return this.parentContext.getPrePeriodId();
    }

    public boolean isCrossYear() {
        return this.parentContext.isCrossYear();
    }

    public int getPeriodYear() {
        return this.parentContext.getPeriodYear();
    }

    public AccountTableRef getAcctTblRef() {
        return this.parentContext.getAcctTblRef();
    }

    public Set<Long> getOldAccountIds() {
        return this.oldAcctIds;
    }

    public void setOldAccountIds(Set<Long> accountIds) {
        this.oldAcctIds = accountIds;
    }

    public AssistCache getAssistCache() {
        return this.parentContext.getAssistCache();
    }

    public AccountCache getAccountCache() {
        return this.parentContext.getAccountCache();
    }

    public Collection<AbstractBalData> getOldBalDatas() {
        return this.oldBalDatas;
    }

    public void addOldBalData(AbstractBalData balData) {
        this.oldBalDatas.add(balData);
    }

    public List<AbstractBalData> getInsertBalDatas() {
        return this.insertBalDatas;
    }

    public void addInsertBalData(AbstractBalData balData) {
        this.insertBalDatas.add(balData);
    }

    public List<AbstractBalData> getUpdateBalDatas() {
        return this.updateBalDatas;
    }

    public void addUpdateBalData(AbstractBalData balData) {
        this.updateBalDatas.add(balData);
    }

    public List<AbstractBalData> getDeleteBalDatas() {
        return this.deleteBalDatas;
    }

    public void addDeleteBalData(AbstractBalData balData) {
        this.deleteBalDatas.add(balData);
    }

    public Map<String, List<AbstractBalData>> getAllExistNewAcctBalDatas() {
        return this.existNewAcctBalDatas;
    }

    public void addExistNewAcctBalDatas(String balKey, AbstractBalData balData) {
        List balDatas = this.existNewAcctBalDatas.computeIfAbsent(balKey, k -> new ArrayList(8));
        balDatas.add(balData);
    }

    public List<AbstractBalData> getExistNewAcctBalDatas(String balKey) {
        return this.existNewAcctBalDatas.get(balKey);
    }

    public void addExistsFutureBalKey(String balKey) {
        this.existsFutureBalKeys.add(balKey);
    }

    public Set<String> getExistsFutureBalKeys() {
        return this.existsFutureBalKeys;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public Collection<Long> getVchEntryAssgrps() {
        return this.vchEntryAndAssgrpMap.values();
    }

    public Long getAssgrpByVchEntry(Long vchEntryId) {
        return this.vchEntryAndAssgrpMap.get(vchEntryId);
    }

    public void addVchEntryAndAssgrpMap(Long vchEntryId, Long assgrpId) {
        this.vchEntryAndAssgrpMap.put(vchEntryId, assgrpId);
    }

    public Set<Long> getFuturePeriodIds() {
        return this.futurePeriodIds;
    }

    public void setFuturePeriodIds(Set<Long> futurePeriodIds) {
        this.futurePeriodIds = futurePeriodIds;
    }

    public void setAcctSumBalCtx(AcctSumBalContext acctSumBalCtx) {
        this.acctSumBalCtx = acctSumBalCtx;
    }

    public AcctSumBalContext getAcctSumBalCtx() {
        return this.acctSumBalCtx;
    }
}

