/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.AssGrpDefaultVal;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.AcccurrentData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.reciprocal.FlexSaveService;

public class AcccurrentTransHandler
extends AbstractBalDataHandler {
    @Override
    public void handle(SingleAccountRefContext context) {
        Collection<AbstractBalData> oldBalDatas = context.getOldBalDatas();
        AccountTableRef accountTableRef = context.getAcctTblRef();
        ArrayList<FlexEntireData> flexEntireDatas = new ArrayList<FlexEntireData>(1024);
        ArrayList<AcccurrentData> newbalDatas = new ArrayList<AcccurrentData>(1024);
        for (AbstractBalData oldData : oldBalDatas) {
            AcccurrentData oldAcccurrentData = (AcccurrentData)oldData;
            Long oldAccountId = oldAcccurrentData.getAcctPKId();
            Long newAccountId = accountTableRef.getNewAccountId(oldAccountId);
            this.collectAssvals(context, accountTableRef, oldAcccurrentData, flexEntireDatas);
            AcccurrentData newbalData = this.buildAcccurrentData(context, oldAcccurrentData, newAccountId);
            newbalDatas.add(newbalData);
        }
        this.createAndCacheNewAssgrpIds(context, flexEntireDatas);
        this.addInsertDatas(context, newbalDatas);
    }

    private void addInsertDatas(SingleAccountRefContext context, Collection<AcccurrentData> newbalDatas) {
        for (AcccurrentData balData : newbalDatas) {
            Long assgrpId;
            String newAssval = balData.getAssval();
            if (balData.isAssgrpMatch()) {
                assgrpId = balData.getAssgrpId();
            } else if (StringUtils.isEmpty((String)newAssval)) {
                assgrpId = 0L;
            } else {
                assgrpId = context.getAssistCache().getNewAssgrpId(newAssval);
                if (assgrpId == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408%s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684assgrpid\uff0c\u4f59\u989d\u751f\u6210\u5931\u8d25\u3002", (String)"AcccurrentTransHandler_0", (String)"fi-gl-common", (Object[])new Object[0]), newAssval));
                }
            }
            balData.setAssgrpId(assgrpId);
            context.addInsertBalData(balData);
        }
    }

    private void createAndCacheNewAssgrpIds(SingleAccountRefContext context, List<FlexEntireData> flexEntireDatas) {
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        Map<String, Long> valAndAssgrpIdMap = FlexSaveService.batchSaveFlexData(mainEntity, flexEntireDatas);
        for (Map.Entry<String, Long> entry : valAndAssgrpIdMap.entrySet()) {
            context.getAssistCache().cacheAssvalAndAssgrp(entry.getKey(), entry.getValue());
        }
    }

    private AcccurrentData buildAcccurrentData(SingleAccountRefContext context, AcccurrentData oldAcccurrentData, Long newAccountId) {
        AcccurrentData acccurrentData = new AcccurrentData();
        acccurrentData.setMasterId(oldAcccurrentData.getMasterId());
        acccurrentData.setAcctPKId(newAccountId);
        acccurrentData.setAcctMasterId(context.getAccountCache().getNewAccountDetails(newAccountId).getMasterId());
        if (oldAcccurrentData.isAssgrpMatch()) {
            acccurrentData.setAssgrpId(oldAcccurrentData.getAssgrpId());
            acccurrentData.setAssgrpMatch(true);
        } else {
            acccurrentData.setAssgrpId(0L);
        }
        acccurrentData.setAssval(oldAcccurrentData.getAssval());
        acccurrentData.setCurrencyId(oldAcccurrentData.getCurrencyId());
        acccurrentData.setLocalCurrency(oldAcccurrentData.getLocalCurrency());
        acccurrentData.setPeriodId(oldAcccurrentData.getPeriodId());
        acccurrentData.setAmount(oldAcccurrentData.getAmount());
        acccurrentData.setAmountFor(oldAcccurrentData.getAmountFor());
        acccurrentData.setAmountBal(oldAcccurrentData.getAmountBal());
        acccurrentData.setAmountBalFor(oldAcccurrentData.getAmountBalFor());
        acccurrentData.setBizDate(oldAcccurrentData.getBizDate());
        acccurrentData.setBizNum(oldAcccurrentData.getBizNum());
        acccurrentData.setDescription(oldAcccurrentData.getDescription());
        acccurrentData.setExpireDate(oldAcccurrentData.getExpireDate());
        acccurrentData.setSourceType(oldAcccurrentData.getSourceType());
        acccurrentData.setStatus(oldAcccurrentData.getStatus());
        acccurrentData.setVchEntryId(oldAcccurrentData.getVchEntryId());
        acccurrentData.setVoucherId(oldAcccurrentData.getVoucherId());
        oldAcccurrentData.setUneffectivedate(context.getDate());
        acccurrentData.setEffectivedate(context.getDate());
        acccurrentData.setUneffectivedate(BalanceTransferUtils.getEndDate());
        acccurrentData.setEntryDc(oldAcccurrentData.getEntryDc());
        acccurrentData.setCreator(oldAcccurrentData.getCreator());
        acccurrentData.setWriteOffPerson(oldAcccurrentData.getWriteOffPerson());
        acccurrentData.setBookedDate(oldAcccurrentData.getBookedDate());
        return acccurrentData;
    }

    private void collectAssvals(SingleAccountRefContext context, AccountTableRef accountTableRef, AcccurrentData oldBalData, List<FlexEntireData> flexEntireDatas) {
        FlexEntireData flexEntireData = new FlexEntireData();
        Long oldAccountId = oldBalData.getAcctPKId();
        AssGrpDefaultVal newAssgrpVals = accountTableRef.getNewDefaultAssgrp(oldAccountId);
        Long newAccountId = accountTableRef.getNewAccountId(oldAccountId);
        Set<String> newFlexFields = context.getAccountCache().getNewAccountDetails(newAccountId).getFlexFields();
        if (newFlexFields == null || newFlexFields.isEmpty()) {
            DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)newAccountId, (String)"bd_accountview");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f80\u6765\u79d1\u76ee\u65b0\u79d1\u76ee%s\u7684\u5f80\u6765\u6838\u7b97\u7eac\u5ea6\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b0\u79d1\u76ee\u5c5e\u6027\u662f\u5426\u5305\u542b\u5f80\u6765\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AcccurrentTransHandler_1", (String)"fi-gl-common", (Object[])new Object[0]), acct != null ? acct.getString("number") : newAccountId));
        }
        Map<String, Object> oldAssgrpVals = context.getAssistCache().getOldAssvalFromCache(oldBalData.getAssgrpId());
        if (oldAssgrpVals != null) {
            boolean isAllMatch = true;
            if (newFlexFields.size() == oldAssgrpVals.size()) {
                for (String newFlexField : newFlexFields) {
                    if (oldAssgrpVals.containsKey(newFlexField)) continue;
                    isAllMatch = false;
                    break;
                }
            } else {
                isAllMatch = false;
            }
            if (isAllMatch) {
                oldBalData.setAssgrpMatch(true);
                return;
            }
        }
        this.buildAssvalWithNoZeorAssgrp(context, oldBalData, flexEntireDatas, flexEntireData, oldAccountId, newAssgrpVals, newAccountId, newFlexFields);
    }

    private void buildAssvalWithNoZeorAssgrp(SingleAccountRefContext context, AcccurrentData oldBalData, List<FlexEntireData> flexEntireDatas, FlexEntireData flexEntireData, Long oldAccountId, AssGrpDefaultVal newAssgrpVals, Long newAccountId, Set<String> newFlexFields) {
        List<FlexEntireData.FlexData> flexDatas = this.buildFlexData(context, newAccountId, flexEntireData, newAssgrpVals, newFlexFields, oldBalData);
        if (!flexDatas.isEmpty()) {
            flexEntireData.setFlexDatas(flexDatas);
            String newAssval = flexEntireData.concatFlexData();
            oldBalData.setAssval(newAssval);
            if (!context.getAssistCache().existsNewAssgrpCache(newAssval)) {
                flexEntireDatas.add(flexEntireData);
            }
        } else {
            this.logError(String.format(ResManager.loadKDString((String)"\u5f80\u6765\u79d1\u76ee\u65e7\u79d1\u76ee%1$s\uff0c\u7ef4\u5ea6\u503c%2$s\uff0c\u5bf9\u65b0\u79d1\u76ee%3$s\u7684\u6620\u5c04\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u5408\u3002", (String)"AcccurrentTransHandler_2", (String)"fi-gl-common", (Object[])new Object[0]), oldAccountId, oldBalData.getAssgrpId(), newAccountId));
            DynamicObject oldAcct = BusinessDataServiceHelper.loadSingleFromCache((Object)oldAccountId, (String)"bd_accountview");
            String oldNumber = oldAcct != null ? oldAcct.getString("number") : "";
            DynamicObject newAcct = BusinessDataServiceHelper.loadSingleFromCache((Object)newAccountId, (String)"bd_accountview");
            String newNumber = newAcct != null ? newAcct.getString("number") : "";
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f80\u6765\u79d1\u76ee\u65e7\u79d1\u76ee%1$s\uff0c\u5bf9\u65b0\u79d1\u76ee%2$s\u7684\u6620\u5c04\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u5408\u3002", (String)"AcccurrentTransHandler_3", (String)"fi-gl-common", (Object[])new Object[0]), oldNumber, newNumber));
        }
    }

    private List<FlexEntireData.FlexData> buildFlexData(SingleAccountRefContext context, Long newAccountId, FlexEntireData flexEntireData, AssGrpDefaultVal newAssgrpVals, Set<String> newFlexFields, AcccurrentData oldBalData) {
        Long oldVchAssgrpId;
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>(32);
        Long oldAssgrpId = oldBalData.getAssgrpId();
        Map<String, Object> oldAssgrpVals = context.getAssistCache().getOldAssvalFromCache(oldAssgrpId);
        if (oldAssgrpVals == null) {
            oldAssgrpVals = new HashMap<String, Object>(32);
        }
        Map<Object, Object> oldVchAssgrpVals = null;
        if (!oldBalData.getVchEntryId().equals(0L) && (oldVchAssgrpId = context.getAssgrpByVchEntry(oldBalData.getVchEntryId())) != null) {
            oldVchAssgrpVals = context.getAssistCache().getOldAssvalFromCache(oldVchAssgrpId);
        }
        if (oldVchAssgrpVals == null) {
            oldVchAssgrpVals = new HashMap(32);
        }
        for (String flexField : newFlexFields) {
            FlexEntireData.FlexData flexData = null;
            Object vchAssval = oldVchAssgrpVals.get(flexField);
            if (vchAssval != null) {
                flexData = this.buildFlexData(flexField, vchAssval, flexEntireData);
            } else {
                Object assval = oldAssgrpVals.get(flexField);
                if (assval != null) {
                    flexData = this.buildFlexData(flexField, assval, flexEntireData);
                } else {
                    Object defaultAssval = newAssgrpVals.getDefaultAssgrpId(flexField);
                    if (defaultAssval != null) {
                        flexData = this.buildFlexData(flexField, defaultAssval, flexEntireData);
                    } else {
                        this.logError(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5f80\u6765\u79d1\u76ee%1$s\u7684\u6838\u7b97\u7ef4\u5ea6%2$s\u627e\u4e0d\u5230\u5bf9\u5e94\u503c\uff0c\u8bf7\u68c0\u67e5\u539f\u79d1\u76ee\u7ef4\u5ea6%3$s\uff0c\u6216\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u9ed8\u8ba4\u503c\u3002", (String)"AcccurrentTransHandler_4", (String)"fi-gl-common", (Object[])new Object[0]), newAccountId, flexField, oldAssgrpId));
                        DynamicObject newAcct = BusinessDataServiceHelper.loadSingleFromCache((Object)newAccountId, (String)"bd_accountview");
                        String newNumber = newAcct != null ? newAcct.getString("number") : "";
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5f80\u6765\u79d1\u76ee%s\u7684\u6838\u7b97\u7ef4\u5ea6\u627e\u4e0d\u5230\u5bf9\u5e94\u503c\uff0c\u8bf7\u68c0\u67e5\u539f\u79d1\u76ee\u7ef4\u5ea6\uff0c\u6216\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u9ed8\u8ba4\u503c\u3002", (String)"AcccurrentTransHandler_5", (String)"fi-gl-common", (Object[])new Object[0]), newNumber));
                    }
                }
            }
            if (flexData == null) continue;
            flexDatas.add(flexData);
        }
        return flexDatas;
    }

    private FlexEntireData.FlexData buildFlexData(String flexField, Object assval, FlexEntireData flexEntireData) {
        FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
        if (assval instanceof String) {
            flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
        } else {
            flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
        }
        flexData.setPropId(flexField);
        flexData.setValue(assval);
        return flexData;
    }
}

