/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.util.Collection;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.AssistCache;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;

public class AssgrpCollectHandler
extends AbstractBalDataHandler {
    private static final String GL_ASSIST_BD = "gl_assist_bd";
    private static final String GL_ASSIST_TXT = "gl_assist_txt";

    @Override
    public void handle(SingleAccountRefContext context) {
        Collection<AbstractBalData> balDatas = context.getOldBalDatas();
        HashSet<Long> assgrpIds = new HashSet<Long>(1024);
        for (AbstractBalData balData : balDatas) {
            Long assgrpId = balData.getAssgrpId();
            if (context.getAssistCache().existsOldAssvalCache(assgrpId)) continue;
            assgrpIds.add(assgrpId);
        }
        for (Long assgrpId : context.getVchEntryAssgrps()) {
            if (context.getAssistCache().existsOldAssvalCache(assgrpId)) continue;
            assgrpIds.add(assgrpId);
        }
        AssistCache cache = context.getAssistCache();
        try (DataSet assistSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".handle"), (String)GL_ASSIST_BD, (String)"hg, asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);){
            for (Row row : assistSet) {
                cache.cacheOldAssval(row.getLong("hg"), row.getString("asstype"), row.get("assval"));
            }
        }
        assistSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".handle"), (String)GL_ASSIST_TXT, (String)"hg, asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);
        var6_6 = null;
        try {
            for (Row row : assistSet) {
                cache.cacheOldAssval(row.getLong("hg"), row.getString("asstype"), row.get("assval"));
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (assistSet != null) {
                if (var6_6 != null) {
                    try {
                        assistSet.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    assistSet.close();
                }
            }
        }
    }
}

