/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.AssGrpDefaultVal;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accountref.constant.AcctSumBalContext;
import kd.fi.gl.accountref.constant.BalData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.util.GLUtil;

public class BalanceDataHandler
extends AbstractBalDataHandler {
    private static final String ASSVAL = "assval";
    private static final String SORT_FIELDS = "account,currency,assgrp,measureunit,period";
    private static final String PERIODYEAR = "periodyear";
    private static final String ASSTACTITEM_FLEXFIELD = "asstactitem.flexfield";
    private static final String SELECT_FIELDS = "id, account, assgrp, assgrp.value assval, currency, measureunit, period, endperiod, period.periodyear periodyear, count,beginqty, beginfor, beginlocal,debitfor, debitlocal, debitqty, creditfor, creditlocal, creditqty,yeardebitqty, yeardebitfor, yeardebitlocal, yearcreditqty, yearcreditfor, yearcreditlocal,endqty, endfor, endlocal";
    private static final String SUM_SELECT_FIELDS = "id, account, currency, measureunit, period, endperiod, period.periodyear periodyear, count,beginqty, beginfor, beginlocal,debitfor, debitlocal, debitqty, creditfor, creditlocal, creditqty,yeardebitqty, yeardebitfor, yeardebitlocal, yearcreditqty, yearcreditfor, yearcreditlocal,endqty, endfor, endlocal";

    @Override
    public void handle(SingleAccountRefContext context) {
        BalData balData;
        Set<Long> oldActIds = this.checkValidateAccount(context);
        if (oldActIds.isEmpty()) {
            context.setClosed(true);
            return;
        }
        context.setOldAccountIds(oldActIds);
        try (DataSet resultSet = this.queryOldAcctBalanceData(context);){
            for (Row row : resultSet) {
                balData = this.buildBalData(context, row, true);
                context.addOldBalData(balData);
            }
        }
        resultSet = this.queryNewAcctBalanceData(context);
        var4_4 = null;
        try {
            for (Row row : resultSet) {
                balData = this.buildBalData(context, row, false);
                context.addExistNewAcctBalDatas(this.getBalKey(row), balData);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (var4_4 != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        this.initAcctSumBalData(context);
    }

    protected void initAcctSumBalData(SingleAccountRefContext context) {
        AcctSumBalContext sumBalCtx = context.getAcctSumBalCtx();
        try (DataSet resultSet = this.queryNewAcctSumBalanceData(context);){
            for (Row row : resultSet) {
                BalData balData = this.buildBalData(context, row, false);
                sumBalCtx.addExistNewAcctBalDatas(this.getBalKey(row), balData);
            }
        }
    }

    protected Set<Long> checkValidateAccount(SingleAccountRefContext context) {
        HashSet<Long> newAccountIds = new HashSet<Long>(1024);
        AccountTableRef accountTableRef = context.getAcctTblRef();
        Set<Long> oldAccontIds = context.getOldAccountIds();
        Map<Long, DynamicObject> oldAcctIds = BalanceTransferUtils.queryAccountInfos(oldAccontIds, false);
        for (Long oldAcctId : oldAcctIds.keySet()) {
            Long newAccountId = accountTableRef.getNewAccountId(oldAcctId);
            if (null == newAccountId) continue;
            newAccountIds.add(newAccountId);
        }
        Map<Long, DynamicObject> newAcctIds = BalanceTransferUtils.queryAccountInfos(newAccountIds, false);
        HashSet<Long> oldActIds = new HashSet<Long>(1024);
        for (Map.Entry<Long, DynamicObject> entry : newAcctIds.entrySet()) {
            Long newAccountId = entry.getKey();
            DynamicObject newAccount = entry.getValue();
            Set oldIds = accountTableRef.getOldAccountIds(newAccountId);
            for (Long oldId : oldIds) {
                DynamicObject oldAccount = oldAcctIds.get(oldId);
                if (null == oldAccount || !this.checkNeedBalTrans(context, newAccount, oldAccount)) continue;
                oldActIds.add(oldId);
            }
        }
        return oldActIds;
    }

    private boolean checkNeedBalTrans(SingleAccountRefContext context, DynamicObject newAccount, DynamicObject oldAccount) {
        long oldMasterId;
        long newMasterId = newAccount.getLong("masterid");
        if (newMasterId != (oldMasterId = oldAccount.getLong("masterid"))) {
            return true;
        }
        List<String> newAssists = this.getFlexFields(newAccount);
        List<String> oldAssists = this.getFlexFields(oldAccount);
        int newSize = newAssists.size();
        if (newSize != oldAssists.size()) {
            return true;
        }
        long oldId = oldAccount.getLong("id");
        AssGrpDefaultVal defAssVal = context.getAcctTblRef().getNewDefaultAssgrp(Long.valueOf(oldId));
        for (String assist : newAssists) {
            if (defAssVal.getDefaultAssgrpId(assist) == null) continue;
            return true;
        }
        newAssists.retainAll(oldAssists);
        int retainSize = newAssists.size();
        return newSize != retainSize;
    }

    private List<String> getFlexFields(DynamicObject account) {
        DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
        ArrayList<String> lstFields = new ArrayList<String>(assistEntry.size());
        for (DynamicObject assistRow : assistEntry) {
            String fieldName = assistRow.getString(ASSTACTITEM_FLEXFIELD);
            lstFields.add(fieldName);
        }
        return lstFields;
    }

    protected BalData buildBalData(SingleAccountRefContext context, Row row, boolean isOldData) {
        BalData balData = new BalData();
        balData.setId(row.getLong("id"));
        Long masterId = row.getLong("account");
        balData.setAcctMasterId(masterId);
        if (isOldData) {
            balData.setAcctPKId(context.getAccountCache().getOldAccountId(masterId));
        }
        balData.setAssgrpId(row.getLong("assgrp"));
        balData.setAssval(row.getString(ASSVAL));
        balData.setCurrencyId(row.getLong("currency"));
        balData.setMeasureUnitId(row.getLong("measureunit"));
        balData.setPeriodId(row.getLong("period"));
        balData.setEndPeriodId(row.getLong("endperiod"));
        balData.setPeriodYear(row.getInteger(PERIODYEAR));
        balData.setCount(row.getInteger("count"));
        balData.setBeginFor(row.getBigDecimal("beginfor"));
        balData.setBeginLocal(row.getBigDecimal("beginlocal"));
        balData.setBeginQty(row.getBigDecimal("beginqty"));
        balData.setDebitFor(row.getBigDecimal("debitfor"));
        balData.setDebitLocal(row.getBigDecimal("debitlocal"));
        balData.setDebitQty(row.getBigDecimal("debitqty"));
        balData.setCreditFor(row.getBigDecimal("creditfor"));
        balData.setCreditLocal(row.getBigDecimal("creditlocal"));
        balData.setCreditQty(row.getBigDecimal("creditqty"));
        if (isOldData) {
            Long periodId = context.getPeriodId();
            Long yearPeriodId = periodId / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L;
            if (periodId.compareTo(balData.getEndPeriodId()) <= 0 && periodId.compareTo(balData.getPeriodId()) >= 0 && yearPeriodId.compareTo(balData.getPeriodId()) < 0) {
                balData.setYearDebitFor(row.getBigDecimal("yeardebitfor"));
                balData.setYearDebitLocal(row.getBigDecimal("yeardebitlocal"));
                balData.setYearDebitQty(row.getBigDecimal("yeardebitqty"));
                balData.setYearCreditFor(row.getBigDecimal("yearcreditfor"));
                balData.setYearCreditLocal(row.getBigDecimal("yearcreditlocal"));
                balData.setYearCreditQty(row.getBigDecimal("yearcreditqty"));
            } else {
                balData.setYearDebitFor(BigDecimal.ZERO);
                balData.setYearDebitLocal(BigDecimal.ZERO);
                balData.setYearDebitQty(BigDecimal.ZERO);
                balData.setYearCreditFor(BigDecimal.ZERO);
                balData.setYearCreditLocal(BigDecimal.ZERO);
                balData.setYearCreditQty(BigDecimal.ZERO);
            }
        } else {
            balData.setYearDebitFor(row.getBigDecimal("yeardebitfor"));
            balData.setYearDebitLocal(row.getBigDecimal("yeardebitlocal"));
            balData.setYearDebitQty(row.getBigDecimal("yeardebitqty"));
            balData.setYearCreditFor(row.getBigDecimal("yearcreditfor"));
            balData.setYearCreditLocal(row.getBigDecimal("yearcreditlocal"));
            balData.setYearCreditQty(row.getBigDecimal("yearcreditqty"));
        }
        balData.setEndFor(row.getBigDecimal("endfor"));
        balData.setEndLocal(row.getBigDecimal("endlocal"));
        balData.setEndQty(row.getBigDecimal("endqty"));
        return balData;
    }

    protected DataSet queryNewAcctBalanceData(SingleAccountRefContext context) {
        List<QFilter> filters = this.getNewAcctBalanceFilter(context);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance", (String)SELECT_FIELDS, (QFilter[])filters.toArray(new QFilter[0]), (String)SORT_FIELDS);
    }

    protected DataSet queryOldAcctBalanceData(SingleAccountRefContext context) {
        List<QFilter> filters = this.getOldAcctBalanceFilter(context);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance", (String)SELECT_FIELDS, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    protected DataSet queryNewAcctSumBalanceData(SingleAccountRefContext context) {
        List<QFilter> filters = this.getNewAcctBalanceFilter(context);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acctbalance", (String)SUM_SELECT_FIELDS, (QFilter[])filters.toArray(new QFilter[0]), null);
        dataSet = dataSet.addField("0", "assgrp");
        dataSet = dataSet.addNullField(ASSVAL);
        dataSet = dataSet.orderBy(SORT_FIELDS.split(","));
        return dataSet;
    }

    private List<QFilter> getOldAcctBalanceFilter(SingleAccountRefContext context) {
        Long prePeriodId = context.getPrePeriodId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)context.getOrgId()));
        filters.add(new QFilter("booktype", "=", (Object)context.getBookTypeId()));
        filters.add(new QFilter("accounttable", "=", (Object)context.getAcctTblRef().getOldAccountTableId()));
        filters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)prePeriodId, (Long[])new Long[]{context.getOrgId()})));
        filters.add(new QFilter("period", "<=", (Object)prePeriodId));
        filters.add(new QFilter("period", ">=", (Object)(prePeriodId / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        Set<Long> acctMasterIdSet = this.getAccountMasterIds(context.getOldAccountIds());
        filters.add(new QFilter("account", "in", acctMasterIdSet));
        return filters;
    }

    private Set<Long> getAccountMasterIds(Set<Long> accountIds) {
        HashSet<Long> acctMasterIdSet = new HashSet<Long>(1024);
        try (DataSet acctSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", accountIds)}, null);){
            for (Row row : acctSet) {
                acctMasterIdSet.add(row.getLong("masterid"));
            }
        }
        return acctMasterIdSet;
    }

    private List<QFilter> getNewAcctBalanceFilter(SingleAccountRefContext context) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)context.getOrgId()));
        filters.add(new QFilter("booktype", "=", (Object)context.getBookTypeId()));
        filters.add(new QFilter("accounttable", "=", (Object)context.getAcctTblRef().getNewAccountTableId()));
        filters.add(new QFilter("period", ">=", (Object)context.getPeriodId()));
        AccountTableRef accountTableRef = context.getAcctTblRef();
        HashSet<Long> newAccountIds = new HashSet<Long>(1024);
        for (Long oldAccountId : context.getOldAccountIds()) {
            Long newAccountId = accountTableRef.getNewAccountId(oldAccountId);
            if (newAccountId == null) continue;
            newAccountIds.add(newAccountId);
        }
        Set<Long> acctMasterIdSet = this.getAccountMasterIds(newAccountIds);
        filters.add(new QFilter("account", "in", acctMasterIdSet));
        return filters;
    }

    protected String getBalKey(Row row) {
        return BalanceTransferUtils.getAccountBalanceKey(row.getLong("account"), row.getLong("currency"), row.getLong("assgrp"), row.getLong("measureunit"));
    }
}

