/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.BalData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractSaveDataHandler;
import kd.fi.gl.balcal.BalExtendTrigger;
import kd.fi.gl.balcal.log.ChangeType;
import kd.fi.gl.interfaces.service.bal.log.BalChangeLogger;
import kd.sdk.fi.gl.extpoint.bal.AccountKey;
import kd.sdk.fi.gl.extpoint.bal.BalKey;

public class SaveBalDataHandler
extends AbstractSaveDataHandler {
    protected static final String T_GL_BALANCE = "T_GL_BALANCE";
    private static final String INSERT_BAL_SQL = "INSERT INTO T_GL_BALANCE(FID,FORGID,FBOOKTYPEID,FPERIODID,FENDPERIODID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID,FASSGRPID,FMEASUREUNITID,FBEGINFOR,FBEGINLOCAL,FBEGINQTY,FYEARDEBITFOR,FYEARDEBITLOCAL,FYEARDEBITQTY,FYEARCREDITFOR,FYEARCREDITLOCAL,FYEARCREDITQTY,FENDFOR,FENDLOCAL,FENDQTY,FMODIFYTIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_BAL_SQL = "UPDATE T_GL_BALANCE SET FBEGINFOR=?,FBEGINLOCAL=?,FBEGINQTY=?,FYEARDEBITFOR=?,FYEARDEBITLOCAL=?,FYEARDEBITQTY=?,FYEARCREDITFOR=?,FYEARCREDITLOCAL=?,FYEARCREDITQTY=?,FENDFOR=?,FENDLOCAL=?,FENDQTY=?,FMODIFYTIME=? WHERE FID=?";
    protected final BalChangeLogger balLogger = BalChangeLogger.create();

    @Override
    public void handle(SingleAccountRefContext context) {
        Date updateTime = new Date();
        this.insertBalData(context);
        this.updateBalData(context);
        BalExtendTrigger.updateBal(context.getOrgId(), context.getBookTypeId(), updateTime, true);
        this.balLogger.recordBalTransData(context, T_GL_BALANCE, context.getDeleteBalDatas(), ChangeType.delete, new long[0]);
        this.deleteBalData(context.getDeleteBalDatas(), T_GL_BALANCE);
        ArrayList<BalKey> demission = new ArrayList<BalKey>();
        context.getDeleteBalDatas().forEach(x -> {
            BalData data = (BalData)x;
            AccountKey key = new AccountKey(data.getAcctMasterId().longValue(), data.getAssgrpId().longValue(), data.getCurrencyId().longValue(), data.getMeasureUnitId(), data.getPeriodId().longValue(), data.getEndPeriodId(), data.getId().longValue(), new ArrayList());
            demission.add((BalKey)key);
        });
        BalExtendTrigger.delBal(context.getOrgId(), context.getBookTypeId(), demission, true);
    }

    protected void updateBalData(SingleAccountRefContext context) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        List<AbstractBalData> updateBalDatas = context.getUpdateBalDatas();
        this.balLogger.recordBalTransData(context, T_GL_BALANCE, updateBalDatas, ChangeType.updateBal, new long[0]);
        for (AbstractBalData updateBalData : updateBalDatas) {
            BalData balData = (BalData)updateBalData;
            Object[] updateParam = new Object[]{balData.getBeginFor(), balData.getBeginLocal(), balData.getBeginQty(), balData.getYearDebitFor(), balData.getYearDebitLocal(), balData.getYearDebitQty(), balData.getYearCreditFor(), balData.getYearCreditLocal(), balData.getYearCreditQty(), balData.getEndFor(), balData.getEndLocal(), balData.getEndQty(), new Date(), balData.getId()};
            updateParams.add(updateParam);
            if (updateParams.size() < 5000) continue;
            this.patchExecute(UPDATE_BAL_SQL, updateParams);
            updateParams.clear();
        }
        if (!updateParams.isEmpty()) {
            this.patchExecute(UPDATE_BAL_SQL, updateParams);
        }
    }

    private void insertBalData(SingleAccountRefContext context) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(1024);
        List<AbstractBalData> newBalDatas = context.getInsertBalDatas();
        long[] pkIds = DB.genLongIds((String)T_GL_BALANCE, (int)newBalDatas.size());
        this.balLogger.recordBalTransData(context, T_GL_BALANCE, newBalDatas, ChangeType.insert, pkIds);
        int pkIdx = 0;
        Long orgId = context.getOrgId();
        Long bookTypeId = context.getBookTypeId();
        Long acctTblId = context.getAcctTblRef().getNewAccountTableId();
        Long periodId = context.getPeriodId();
        for (AbstractBalData newBalData : newBalDatas) {
            BalData balData = (BalData)newBalData;
            Object[] insertParam = new Object[]{pkIds[pkIdx], orgId, bookTypeId, periodId, balData.getEndPeriodId(), acctTblId, balData.getAcctMasterId(), balData.getCurrencyId(), balData.getAssgrpId(), balData.getMeasureUnitId(), balData.getBeginFor(), balData.getBeginLocal(), balData.getBeginQty(), balData.getYearDebitFor(), balData.getYearDebitLocal(), balData.getYearDebitQty(), balData.getYearCreditFor(), balData.getYearCreditLocal(), balData.getYearCreditQty(), balData.getEndFor(), balData.getEndLocal(), balData.getEndQty(), new Date()};
            insertParams.add(insertParam);
            ++pkIdx;
            if (insertParams.size() < 5000) continue;
            this.patchExecute(INSERT_BAL_SQL, insertParams);
            insertParams.clear();
        }
        if (!insertParams.isEmpty()) {
            this.patchExecute(INSERT_BAL_SQL, insertParams);
        }
    }
}

