/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.transferbal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.accountref.constant.AccountRefContext;
import kd.fi.gl.accountref.constant.AcctSumBalContext;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.IBalDataHandler;
import kd.fi.gl.accountref.transferbal.IAccountRefBalTransfer;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;

public abstract class AbstractAccountRefBalTransfer
implements IAccountRefBalTransfer {
    private AccountRefContext context;
    protected static final int INIT_CAPACITY = 1024;
    private static final int SPLIT_QUERY_COUNT = 20;
    private static final Log logger = LogFactory.getLog(BalanceTransferUtils.class);

    public AbstractAccountRefBalTransfer(AccountRefContext ctx) {
        this.context = ctx;
    }

    protected abstract LockKey getLockKey();

    protected abstract List<IBalDataHandler> buildHandlers();

    protected abstract List<IBalDataHandler> buildUnTransHandlers();

    @Override
    public void transBal() {
        Lock.tryLock(this.context.getOrgId(), this.context.getBookTypeId(), this.getLockKey(), () -> this.process());
    }

    @Override
    public void transBalWithoutBalLock() {
        this.process();
    }

    private void process() {
        List<Set<Long>> splitAccountIds = this.splitAccountFilter(this.context.getAcctTblRef());
        List<IBalDataHandler> handlers = this.buildHandlers();
        block2: for (Set<Long> splitAccountIdSet : splitAccountIds) {
            try {
                SingleAccountRefContext singleCtx = new SingleAccountRefContext(this.context);
                singleCtx.setAcctSumBalCtx(new AcctSumBalContext());
                singleCtx.setOldAccountIds(splitAccountIdSet);
                for (IBalDataHandler handler : handlers) {
                    if (singleCtx.isClosed()) continue block2;
                    handler.handle(singleCtx);
                }
            }
            catch (Exception e) {
                this.logError(e);
                throw e;
            }
        }
    }

    @Override
    public void unTransBal() {
        Lock.tryLock(this.context.getOrgId(), this.context.getOrgId(), this.getLockKey(), () -> {
            List<Set<Long>> splitAccountIds = this.splitAccountFilter(this.context.getAcctTblRef());
            CountDownLatch countDownLatch = new CountDownLatch(splitAccountIds.size());
            List<IBalDataHandler> handlers = this.buildUnTransHandlers();
            for (Set<Long> splitAccountIdSet : splitAccountIds) {
                ThreadService.execute(() -> {
                    try {
                        SingleAccountRefContext singleCtx = new SingleAccountRefContext(this.context);
                        singleCtx.setAcctSumBalCtx(new AcctSumBalContext());
                        singleCtx.setOldAccountIds(splitAccountIdSet);
                        for (IBalDataHandler handler : handlers) {
                            if (singleCtx.isClosed()) {
                                break;
                            }
                            handler.handle(singleCtx);
                        }
                    }
                    catch (Exception e) {
                        this.logError(e);
                        throw e;
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }, (TaskType)TaskType.GL_ACCOUNT_REF_UNTRANS_BAL);
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                this.logError(e);
            }
        });
    }

    protected void logError(Exception e) {
        logger.error("\u79d1\u76ee\u7248\u672c\u5316\u4f59\u989d\u7ed3\u8f6c\u65e5\u5fd7\uff1a" + e);
    }

    private List<Set<Long>> splitAccountFilter(AccountTableRef acctTblRef) {
        Set newAccountIds = acctTblRef.getNewAccountIdSet();
        ArrayList<Set<Long>> splitAccountIds = new ArrayList<Set<Long>>(1024);
        HashSet tmpAcctIds = new HashSet(1024);
        for (Long newId : newAccountIds) {
            Set oldAccountIds = acctTblRef.getOldAccountIds(newId);
            tmpAcctIds.addAll(oldAccountIds);
            if (tmpAcctIds.size() < 20) continue;
            splitAccountIds.add(tmpAcctIds);
            tmpAcctIds = new HashSet(1024);
        }
        if (tmpAcctIds.size() > 0) {
            splitAccountIds.add(tmpAcctIds);
        }
        return splitAccountIds;
    }
}

