/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accountref.constant.AccountRefContext;
import kd.fi.gl.accountref.constant.BalTransferType;
import kd.fi.gl.accountref.transferbal.AcccurrentBalTransfer;
import kd.fi.gl.accountref.transferbal.AcctBalanceBalTransfer;
import kd.fi.gl.accountref.transferbal.DefaultBalTransfer;
import kd.fi.gl.accountref.transferbal.IAccountRefBalTransfer;
import kd.fi.gl.accountref.utils.GLAccountRefUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.GLUtil;

public class BalanceTransferUtils {
    private static Date endDate;
    private static Date initBegindate;

    public static void transfer(Long orgId, Long bookTypeId, Date date, Long periodId, AccountTableRef acctTblRef, BalTransferType type) {
        if (!BalanceTransferUtils.isBizUnit(orgId, bookTypeId)) {
            return;
        }
        AccountRefContext context = BalanceTransferUtils.buildContext(orgId, bookTypeId, date, periodId, acctTblRef, type);
        IAccountRefBalTransfer accountRefBalTrans = BalanceTransferUtils.getTransBalConstructor(context, type);
        accountRefBalTrans.transBal();
    }

    public static void transBalWithoutBalLock(Long orgId, Long bookTypeId, Date date, Long periodId, AccountTableRef acctTblRef, BalTransferType type) {
        if (!BalanceTransferUtils.isBizUnit(orgId, bookTypeId)) {
            return;
        }
        AccountRefContext context = BalanceTransferUtils.buildContext(orgId, bookTypeId, date, periodId, acctTblRef, type);
        IAccountRefBalTransfer accountRefBalTrans = BalanceTransferUtils.getTransBalConstructor(context, type);
        accountRefBalTrans.transBalWithoutBalLock();
    }

    public static String getBalTranferKey(Long orgId, Long bookTypeId, Long accountTableId) {
        return orgId + "-" + bookTypeId + "-" + accountTableId;
    }

    private static boolean isBizUnit(long orgId, Long bookTypeId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        QFilter qBTFilter = new QFilter("bookstype", "=", (Object)bookTypeId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"isbizunit", (QFilter[])new QFilter[]{qFilter, qBTFilter});
        if (dyn == null) {
            return false;
        }
        return dyn.getBoolean("isbizunit");
    }

    public static void unTransfer(Long orgId, Long bookTypeId, Date date, Long periodId, AccountTableRef acctTblRef, BalTransferType type) {
        if (!AccSysUtil.isBizUnit(orgId)) {
            return;
        }
        AccountRefContext context = BalanceTransferUtils.buildContext(orgId, bookTypeId, date, periodId, acctTblRef, type);
        IAccountRefBalTransfer accountRefBalTrans = BalanceTransferUtils.getTransBalConstructor(context, type);
        accountRefBalTrans.unTransBal();
    }

    private static IAccountRefBalTransfer getTransBalConstructor(AccountRefContext context, BalTransferType type) {
        if (BalTransferType.ACCOUNTBALANCE == type) {
            return new AcctBalanceBalTransfer(context);
        }
        if (BalTransferType.ACCCURRENT == type) {
            return new AcccurrentBalTransfer(context);
        }
        return new DefaultBalTransfer(context);
    }

    private static AccountRefContext buildContext(Long orgId, Long bookTypeId, Date date, Long periodId, AccountTableRef acctTblRef, BalTransferType type) {
        return new AccountRefContext(orgId, bookTypeId, date, periodId, acctTblRef, type);
    }

    public static String getAccountBalanceKey(Object accountId, Object currencyId, Object assgrpId, Object measureUnitId) {
        StringBuilder balKey = new StringBuilder();
        balKey.append(accountId);
        balKey.append(",");
        balKey.append(currencyId);
        balKey.append(",");
        balKey.append(assgrpId);
        balKey.append(",");
        balKey.append(measureUnitId);
        return balKey.toString();
    }

    public static String getAcccurrentKey(Object vchEntryId) {
        return vchEntryId.toString();
    }

    public static Date getEndDate() {
        if (endDate != null) {
            return endDate;
        }
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            endDate = dt.parse("2999-12-31");
            return endDate;
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"BalanceTransferUtils_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
    }

    public static Date getInitBeginDate() {
        if (initBegindate != null) {
            return initBegindate;
        }
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            initBegindate = dt.parse("1900-01-01");
            return initBegindate;
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"BalanceTransferUtils_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
    }

    public static QFilter getAccountRefFilter(Date bookDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date effectiveDate = null;
        try {
            effectiveDate = simpleDateFormat.parse(simpleDateFormat.format(bookDate));
        }
        catch (ParseException e) {
            GLUtil.printError(e);
        }
        return new QFilter("startdate", "<=", (Object)effectiveDate).and(new QFilter("enddate", ">", (Object)effectiveDate));
    }

    public static boolean isAccountTableVersion(Long orgId, Long bookTypeId) {
        return QueryServiceHelper.exists((String)"gl_book_version", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("booktype", "=", (Object)bookTypeId)});
    }

    public static Set<Long> queryEffectivePeriod(Long orgId, Long bookTypeId) {
        HashSet<Long> periods = new HashSet<Long>(8);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"BalanceTransferUtils.queryEffectiveBookInfo", (String)"gl_book_version", (String)"enableperiod", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("booktype", "=", (Object)bookTypeId)}, null);){
            for (Row row : dSet) {
                periods.add(row.getLong("enableperiod"));
            }
        }
        return periods;
    }

    public static Set<Long> queryAccountTableIds(Long orgId, Long bookTypeId) {
        Map<Object, DynamicObject> bookVersions = BalanceTransferUtils.queryBookVersions(orgId, bookTypeId);
        HashSet<Long> acctTblIds = new HashSet<Long>(8);
        if (bookVersions == null || bookVersions.isEmpty()) {
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(orgId, (long)bookTypeId);
            if (bookInfo != null) {
                acctTblIds.add(bookInfo.getAccountTableId());
            }
        } else {
            for (DynamicObject bookVersion : bookVersions.values()) {
                acctTblIds.add(bookVersion.getLong("oldaccttab.id"));
                acctTblIds.add(bookVersion.getLong("accounttable.id"));
            }
        }
        return acctTblIds;
    }

    private static Map<Object, DynamicObject> queryBookVersions(Long orgId, Long bookTypeId) {
        return BusinessDataServiceHelper.loadFromCache((String)"gl_book_version", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("booktype", "=", (Object)bookTypeId)});
    }

    public static DynamicObject queryEffectiveVersionInfo(Long orgId, Long bookTypeId, Long period) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_book_version", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("booktype", "=", (Object)bookTypeId), new QFilter("enableperiod", "=", (Object)period)});
    }

    public static Map<Object, DynamicObject> queryVersionInfosByDate(Long orgId, Long oldAcctTblId, Long newAcctTblId, Date date) {
        return BusinessDataServiceHelper.loadFromCache((String)"gl_book_version", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("enabledate", "<=", (Object)date), new QFilter("disabledate", ">", (Object)date), new QFilter("oldaccttab", "=", (Object)oldAcctTblId), new QFilter("accounttable", "=", (Object)newAcctTblId)});
    }

    public static Map<Long, DynamicObject> queryAccountInfos(Set<Long> accountIds, boolean isAccCheck) {
        DynamicObject[] accounts = BusinessDataServiceHelper.load((Object[])accountIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        HashMap<Long, DynamicObject> results = new HashMap<Long, DynamicObject>(accounts.length);
        for (DynamicObject account : accounts) {
            Boolean accheck;
            if (isAccCheck && !(accheck = Boolean.valueOf(account.getBoolean("accheck"))).booleanValue()) continue;
            results.put(account.getLong("id"), account);
        }
        return results;
    }

    public static GLAccountRefUtil.AccountBookCheckResult getEnableableAccountBook(long orgId, Date enableDate, AccountTableRef accountTableRef, boolean isEnable) {
        if (accountTableRef.getNewAccountTableId() == accountTableRef.getOldAccountTableId()) {
            GLAccountRefUtil.AccountBookCheckResult accountBookCheckResult = new GLAccountRefUtil.AccountBookCheckResult();
            try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"BalanceTransferUtils.getEnableableAccountBook", (String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("accounttable", "=", (Object)accountTableRef.getOldAccountTableId()), new QFilter("isbizunit", "=", (Object)true)}, null);){
                for (Row row : dSet) {
                    AccountBookInfo bookInfo = new AccountBookInfo(row.getLong("id"));
                    DynamicObject period = GLUtil.getPeriodByDate(enableDate, bookInfo.getPeriodTypeId());
                    if (period != null) {
                        bookInfo.setCurPeriodId(period.getLong("id"));
                    }
                    accountBookCheckResult.addBook(bookInfo);
                }
            }
            return accountBookCheckResult;
        }
        if (isEnable) {
            return GLAccountRefUtil.getEnableableAccountBook(orgId, enableDate, accountTableRef);
        }
        return GLAccountRefUtil.getDisableableAccountBook(orgId, enableDate, accountTableRef);
    }
}

