/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.CheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.constant.AccountBook;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.SystemParamHelper;

public class GLAccountRefUtil {
    private GLAccountRefUtil() {
    }

    public static AccountBookCheckResult getEnableableAccountBook(long orgId, Date enableDate, AccountTableRef accountTableRef) {
        long oldAccountTableId = accountTableRef.getOldAccountTableId();
        return (AccountBookCheckResult)ThreadCache.get((Object)ThreadCacheKey.getEnableableAccountBookKey(orgId, enableDate, oldAccountTableId), () -> {
            DynamicObject[] accountBooks;
            AccountBookCheckResult accountBookCheckResult = new AccountBookCheckResult();
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("org", "=", orgId);
            qfBuilder.add("accounttable", "=", oldAccountTableId);
            for (DynamicObject accountBook : accountBooks = GLAccountRefUtil.getBusinessDataDO("gl_accountbook", qfBuilder.toArray(), "org", "curperiod", "bookstype", "accounttable", "isbizunit", "periodtype")) {
                DynamicObject periodDO;
                long curPeriodId;
                String errorMsg;
                long bookTypeId = accountBook.getLong("bookstype_id");
                if (accountBook.getBoolean("isbizunit") && StringUtils.isNotBlank((CharSequence)(errorMsg = GLAccountRefUtil.isTheYearLastAdjustPeriod(curPeriodId = accountBook.getLong(GLField.id_("curperiod")), enableDate)))) {
                    accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7-%1$s\u8d26\u7c3f\u7c7b\u578b-%2$s\uff1a%3$s", (String)"GLAccountRefUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), accountBook.getString("org.name"), accountBook.getString("bookstype.name"), errorMsg));
                    accountBookCheckResult.setSuccess(false);
                }
                if (Objects.isNull(periodDO = GLUtil.getPeriodByDate(enableDate, accountBook.getLong("periodtype_id")))) {
                    accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7-%1$s\u8d26\u7c3f\u7c7b\u578b-%2$s\uff1a%3$s", (String)"GLAccountRefUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), accountBook.getString("org.name"), accountBook.getString("bookstype.name"), ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"GLAccountRefUtil_1", (String)"fi-gl-common", (Object[])new Object[0])));
                    accountBookCheckResult.setSuccess(false);
                } else {
                    long enablePeriod = periodDO.getLong("id");
                    qfBuilder.clear();
                    qfBuilder.add("org", "=", orgId);
                    qfBuilder.add("booktype", "=", bookTypeId);
                    qfBuilder.add("enableperiod", "=", enablePeriod);
                    if (QueryServiceHelper.exists((String)"gl_book_version", (QFilter[])qfBuilder.toArray())) {
                        accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7-%1$s\u8d26\u7c3f\u7c7b\u578b-%2$s\uff1a%3$s", (String)"GLAccountRefUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), accountBook.getString("org.name"), accountBook.getString("bookstype.name"), ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u5b58\u5728\u7248\u672c\u5316\u8bb0\u5f55\u3002", (String)"GLAccountRefUtil_2", (String)"fi-gl-common", (Object[])new Object[0])));
                        accountBookCheckResult.setSuccess(false);
                    } else if (accountBook.getBoolean("isbizunit")) {
                        boolean isACEndInit;
                        qfBuilder.clear();
                        qfBuilder.add("org", "=", orgId);
                        qfBuilder.add("booktype", "=", bookTypeId);
                        qfBuilder.add("entries.account", "in", accountTableRef.getOldAccountIdSet());
                        qfBuilder.add("period", ">=", enablePeriod);
                        boolean autoUpdateFutureVoucher = SystemParamHelper.getBooleanParam("accversionupdatevoucher", orgId, false);
                        if (!autoUpdateFutureVoucher && VoucherQueryUtils.exists((QFilter[])qfBuilder.toArray())) {
                            accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7-%1$s\u8d26\u7c3f\u7c7b\u578b-%2$s\uff1a%3$s", (String)"GLAccountRefUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), accountBook.getString("org.name"), accountBook.getString("bookstype.name"), ResManager.loadKDString((String)"\u5728\u542f\u7528\u671f\u95f4\u53ca\u4ee5\u540e\u671f\u95f4\u5b58\u5728\u4f7f\u7528\u6e90\u79d1\u76ee\u7684\u51ed\u8bc1\u3002", (String)"GLAccountRefUtil_3", (String)"fi-gl-common", (Object[])new Object[0])));
                            accountBookCheckResult.setSuccess(false);
                        }
                        if (!(isACEndInit = ReciprocalUtils.isEndInit(orgId, bookTypeId, enablePeriod))) {
                            accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7-%1$s\u8d26\u7c3f\u7c7b\u578b-%2$s\uff1a%3$s", (String)"GLAccountRefUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), accountBook.getString("org.name"), accountBook.getString("bookstype.name"), ResManager.loadKDString((String)"\u5728\u542f\u7528\u671f\u95f4\u8fd8\u672a\u7ed3\u675f\u5f80\u6765\u521d\u59cb\u5316\u6216\u5b58\u5728\u5f80\u6765\u521d\u59cb\u5316\u4e1a\u52a1\u3002", (String)"GLAccountRefUtil_4", (String)"fi-gl-common", (Object[])new Object[0])));
                            accountBookCheckResult.setSuccess(false);
                        }
                    }
                }
                if (!accountBookCheckResult.getCheckResult().isSuccess()) continue;
                accountBookCheckResult.addBook(new AccountBookInfo(accountBook.getLong("id")));
            }
            if (!accountBookCheckResult.getCheckResult().isSuccess()) {
                accountBookCheckResult.getBooks().clear();
            } else {
                DynamicObject[] accountTableRefRecordDOs;
                qfBuilder.clear();
                qfBuilder.add("org", "=", orgId);
                qfBuilder.add("oldaccttab", "=", oldAccountTableId);
                qfBuilder.add("accounttable", "=", accountTableRef.getNewAccountTableId());
                qfBuilder.add("enabledate", "=", enableDate);
                qfBuilder.add("disabledate", "=", GLUtil.getEndDate());
                for (DynamicObject recordDO : accountTableRefRecordDOs = GLAccountRefUtil.getBusinessDataDO("gl_book_version", qfBuilder.toArray(), "booktype", "enableperiod")) {
                    qfBuilder.clear();
                    qfBuilder.add("org", "=", orgId);
                    qfBuilder.add("bookstype", "=", recordDO.getLong("booktype_id"));
                    qfBuilder.add("curperiod", "=", recordDO.getLong("enableperiod_id"));
                    List bookIds = QueryServiceHelper.queryPrimaryKeys((String)"gl_accountbook", (QFilter[])qfBuilder.toArray(), null, (int)1);
                    if (bookIds.isEmpty()) continue;
                    accountBookCheckResult.addBook(new AccountBookInfo(Long.parseLong(bookIds.get(0).toString())));
                }
            }
            return accountBookCheckResult;
        });
    }

    public static AccountBookCheckResult getDisableableAccountBook(long orgId, Date enableDate, AccountTableRef accountTableRef) {
        long oldAccountTableId = accountTableRef.getOldAccountTableId();
        return (AccountBookCheckResult)ThreadCache.get((Object)ThreadCacheKey.getDisableableAccountBookKey(orgId, enableDate, oldAccountTableId), () -> {
            AccountBookCheckResult accountBookCheckResult = new AccountBookCheckResult();
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("org", "=", orgId);
            qfBuilder.add("oldaccttab", "=", oldAccountTableId);
            qfBuilder.add("accounttable", "!=", oldAccountTableId);
            qfBuilder.add("enabledate", "=", enableDate);
            DynamicObject[] accountTableRefRecordDOs = GLAccountRefUtil.getBusinessDataDO("gl_book_version", qfBuilder.toArray(), "oldaccttab", "oldyearacct", "accounttable", "booktype", "enableperiod", "enabledate", "disabledate");
            List bookTypeIds = Stream.of(accountTableRefRecordDOs).map(x -> x.getLong("booktype_id")).collect(Collectors.toList());
            qfBuilder.clear();
            qfBuilder.add("org", "=", orgId);
            qfBuilder.add("bookstype", "in", bookTypeIds);
            DynamicObject[] accountBooks = GLAccountRefUtil.getBusinessDataDO("gl_accountbook", qfBuilder.toArray(), "org", "curperiod", "bookstype", "accounttable", "isbizunit");
            Map<Long, DynamicObject> allBookDOs = Stream.of(accountBooks).collect(Collectors.toMap(x -> x.getLong("bookstype_id"), x -> x));
            for (DynamicObject accountTableRefRecordDO : accountTableRefRecordDOs) {
                long newAccountTableId;
                long bookTypeId = accountTableRefRecordDO.getLong("booktype_id");
                DynamicObject accountBookDO = allBookDOs.get(bookTypeId);
                if (Objects.isNull(accountBookDO)) {
                    accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7ID\u201c%1$s\u201d,\u8d26\u7c3f\u7c7b\u578bID\u201c%2$s\u201d\u5bf9\u5e94\u7684\u8d26\u7c3f\u5b58\u5728\u79d1\u76ee\u8868\u7248\u672c\u5316\uff0c\u4f46\u662f\u8d26\u7c3f\u5df2\u7ecf\u4e22\u5931\u3002", (String)"GLAccountRefUtil_5", (String)"fi-gl-common", (Object[])new Object[0]), orgId, bookTypeId));
                    continue;
                }
                if (GLUtil.getEndDate().compareTo(accountTableRefRecordDO.getDate("disabledate")) != 0) {
                    accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u8d26\u7c3f\u7c7b\u578b\u201c%2$s\u201d\uff1a\u542f\u7528\u8be5\u76ee\u6807\u79d1\u76ee\u8868\u540e\uff0c\u8d26\u7c3f\u7684\u79d1\u76ee\u8868\u6216\u672c\u5e74\u5229\u6da6\u79d1\u76ee\u5df2\u7ecf\u518d\u6b21\u53d1\u751f\u8fc7\u7248\u672c\u5316\u3002", (String)"GLAccountRefUtil_6", (String)"fi-gl-common", (Object[])new Object[0]), accountBookDO.getString("org.name"), accountBookDO.getString("bookstype.name")));
                    accountBookCheckResult.setSuccess(false);
                    continue;
                }
                long curAccountTableId = accountBookDO.getLong(AccountBook.id_("accounttable"));
                if (curAccountTableId != (newAccountTableId = accountTableRefRecordDO.getLong("accounttable_id"))) {
                    accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u8d26\u7c3f\u7c7b\u578b\u201c%2$s\u201d\uff1a\u5f53\u524d\u79d1\u76ee\u8868\u5e76\u4e0d\u662f\u539f\u5148\u542f\u7528\u7684\u76ee\u6807\u79d1\u76ee\u8868\u3002", (String)"GLAccountRefUtil_7", (String)"fi-gl-common", (Object[])new Object[0]), accountBookDO.getString("org.name"), accountBookDO.getString("bookstype.name")));
                    accountBookCheckResult.setSuccess(false);
                    continue;
                }
                if (accountBookDO.getBoolean("isbizunit")) {
                    long enablePeriodId;
                    long curPeriodId = accountBookDO.getLong(AccountBook.id_("curperiod"));
                    if (curPeriodId != (enablePeriodId = accountTableRefRecordDO.getLong("enableperiod_id"))) {
                        accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u8d26\u7c3f\u7c7b\u578b\u201c%2$s\u201d\uff1a\u5f53\u524d\u671f\u95f4\u4e0d\u662f\u542f\u7528\u671f\u95f4\u3002", (String)"GLAccountRefUtil_8", (String)"fi-gl-common", (Object[])new Object[0]), accountBookDO.getString("org.name"), accountBookDO.getString("bookstype.name")));
                        accountBookCheckResult.setSuccess(false);
                        continue;
                    }
                    qfBuilder.clear();
                    qfBuilder.add("org", "=", orgId);
                    qfBuilder.add("booktype", "=", accountBookDO.getLong("bookstype_id"));
                    qfBuilder.add("period", ">=", enablePeriodId);
                    qfBuilder.add("entries.account", "in", accountTableRef.getNewAccountIdSet());
                    boolean autoUpdateFutureVoucher = SystemParamHelper.getBooleanParam("accversionupdatevoucher", orgId, false);
                    if (!autoUpdateFutureVoucher && VoucherQueryUtils.exists((QFilter[])qfBuilder.toArray())) {
                        accountBookCheckResult.addErrorMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7-%1$s\u8d26\u7c3f\u7c7b\u578b-%2$s\uff1a%3$s", (String)"GLAccountRefUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), accountBookDO.getString("org.name"), accountBookDO.getString("bookstype.name"), ResManager.loadKDString((String)"\u5728\u542f\u7528\u671f\u95f4\u53ca\u4ee5\u540e\u671f\u95f4\u5b58\u5728\u4f7f\u7528\u76ee\u6807\u79d1\u76ee\u7684\u51ed\u8bc1\u3002", (String)"GLAccountRefUtil_9", (String)"fi-gl-common", (Object[])new Object[0])));
                        accountBookCheckResult.setSuccess(false);
                        continue;
                    }
                }
                if (!accountBookCheckResult.getCheckResult().isSuccess()) continue;
                accountBookCheckResult.addBook(new AccountBookInfo(accountBookDO.getLong("id")));
            }
            if (!accountBookCheckResult.getCheckResult().isSuccess()) {
                accountBookCheckResult.getBooks().clear();
            } else {
                DynamicObject[] doneBooks;
                qfBuilder.clear();
                qfBuilder.add("org", "=", orgId);
                qfBuilder.add("accounttable", "=", oldAccountTableId);
                qfBuilder.add("bookstype", "not in", allBookDOs.keySet());
                qfBuilder.add("isbizunit", "=", true);
                for (DynamicObject doneBook : doneBooks = GLAccountRefUtil.getBusinessDataDO("gl_accountbook", qfBuilder.toArray(), "id")) {
                    accountBookCheckResult.addBook(new AccountBookInfo(doneBook.getLong("id")));
                }
            }
            return accountBookCheckResult;
        });
    }

    private static String isTheYearLastAdjustPeriod(long periodId, Date date) {
        DynamicObject periodDO = GLAccountRefUtil.getPeriodDO(periodId, "periodtype", "periodyear", "periodnumber", "isadjustperiod", "begindate", "enddate");
        if (null == periodDO) {
            return ResManager.loadKDString((String)"\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"GLAccountRefUtil_10", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        if (periodDO.getDate("begindate").compareTo(date) > 0 || periodDO.getDate("enddate").compareTo(date) <= 0) {
            return ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f\u4e0d\u5728\u5f53\u524d\u671f\u95f4\u8303\u56f4\u5185\u3002", (String)"GLAccountRefUtil_11", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        if (!periodDO.getBoolean("isadjustperiod")) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u662f\u6700\u540e\u4e00\u671f\u8c03\u6574\u671f\u95f4\u3002", (String)"GLAccountRefUtil_12", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("periodtype", "=", periodDO.getLong("periodtype_id"));
        qfBuilder.add("periodyear", "=", periodDO.getLong("periodyear"));
        qfBuilder.add("periodnumber", ">", periodDO.getInt("periodnumber"));
        if (QueryServiceHelper.exists((String)"bd_period", (QFilter[])qfBuilder.toArray())) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u662f\u6700\u540e\u4e00\u671f\u8c03\u6574\u671f\u95f4\u3002", (String)"GLAccountRefUtil_12", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        return "";
    }

    private static DynamicObject getPeriodDO(long periodId, String ... fields) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", periodId);
        return GLAccountRefUtil.getSingleBusinessDataDO("bd_period", qfBuilder.toArray(), fields);
    }

    private static DynamicObject getSingleBusinessDataDO(String entityName, QFilter[] filters, String ... fields) {
        if (null == fields) {
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, null, (int)1);
            return primaryKeys.isEmpty() ? null : BusinessDataServiceHelper.loadSingle(primaryKeys.get(0), (String)entityName);
        }
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)String.join((CharSequence)",", fields), (QFilter[])filters);
    }

    private static DynamicObject[] getBusinessDataDO(String entityName, QFilter[] filters, String ... fields) {
        if (null == fields) {
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, null, (int)-1);
            return primaryKeys.isEmpty() ? null : BusinessDataServiceHelper.load((Object[])primaryKeys.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        }
        return BusinessDataServiceHelper.load((String)entityName, (String)String.join((CharSequence)",", fields), (QFilter[])filters);
    }

    public static class AccountBookCheckResult {
        private List<AccountBookInfo> books = new ArrayList<AccountBookInfo>(10);
        private CheckResult checkResult = new CheckResult();

        public final void addBook(AccountBookInfo book) {
            this.books.add(book);
        }

        public final void addErrorMsg(String msg) {
            if (StringUtils.isBlank((CharSequence)this.checkResult.getMessage())) {
                this.checkResult.setMessage(msg);
            } else {
                StringBuilder sb = new StringBuilder(this.checkResult.getMessage());
                sb.append("\n");
                sb.append(msg);
                this.checkResult.setMessage(sb.toString());
            }
        }

        public final void setSuccess(boolean isSuccess) {
            this.checkResult.setSuccess(isSuccess);
        }

        public final List<AccountBookInfo> getBooks() {
            return this.books;
        }

        public final CheckResult getCheckResult() {
            return this.checkResult;
        }
    }
}

