/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.assistitem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.assistitem.IEntityRelationValueMapper;
import kd.fi.gl.assistitem.MerchantsAssistValueQueryer;

public class BizPartnerValueMapper
implements IEntityRelationValueMapper {
    private static final String ENABLE = "enable";
    private static final String INTERNAL_COMPANY = "internal_company";
    private static final String BIZPARTNER = "bizpartner";

    protected BizPartnerValueMapper() {
    }

    @Override
    public Map<String, Object> getMappingValue(Object originalValue, String originalValueEntity, long useOrgId) {
        long bizPartnerId = Long.parseLong(originalValue.toString());
        DynamicObject bizpartnerDO = QueryServiceHelper.queryOne((String)"bd_bizpartner", (String)INTERNAL_COMPANY, (QFilter[])QFilterBuilder.create((String)"id", (String)"=", (Object)bizPartnerId).toArray(new QFilter[0]));
        if (Objects.isNull(bizpartnerDO)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        long internalCompanyId = bizpartnerDO.getLong(INTERNAL_COMPANY);
        result.put("bos_org", internalCompanyId);
        MerchantsAssistValueQueryer customerQueryer = new MerchantsAssistValueQueryer("bd_customer", useOrgId);
        Optional<Long> valueBuf = customerQueryer.queryByBizPartner(bizPartnerId);
        if (valueBuf.isPresent()) {
            result.put("bd_customer", valueBuf.get());
        } else {
            valueBuf = customerQueryer.queryByInternalCompanyId(internalCompanyId);
            if (valueBuf.isPresent()) {
                result.put("bd_customer", valueBuf.get());
            }
        }
        MerchantsAssistValueQueryer supplierQueryer = new MerchantsAssistValueQueryer("bd_supplier", useOrgId);
        valueBuf = supplierQueryer.queryByBizPartner(bizPartnerId);
        if (valueBuf.isPresent()) {
            result.put("bd_supplier", valueBuf.get());
        } else {
            valueBuf = supplierQueryer.queryByInternalCompanyId(internalCompanyId);
            if (valueBuf.isPresent()) {
                result.put("bd_supplier", valueBuf.get());
            }
        }
        return result;
    }
}

