/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.assistitem;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.util.MasterBaseDataUtils;

public class MerchantsAssistValueQueryer {
    private final String entityName;
    private final QFilterBuilder baseQFilterBuilder;
    private final String masterIdField;
    private static final String INTERNAL_COMPANY = "internal_company";
    private static final String BIZPARTNER = "bizpartner";

    public MerchantsAssistValueQueryer(String entityName, long useOrgId) {
        this.entityName = entityName;
        this.baseQFilterBuilder = QFilterBuilder.create((String)"enable", (String)"=", (Object)Boolean.TRUE).add(BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)useOrgId));
        String masterIdField = MasterBaseDataUtils.getMasterIdField(entityName);
        this.masterIdField = StringUtils.isBlank((CharSequence)masterIdField) ? "id" : masterIdField;
    }

    public Optional<Long> queryByBizPartner(long bizPartnerId) {
        return this.queryInternal(BIZPARTNER, bizPartnerId);
    }

    public Optional<Long> queryByInternalCompanyId(long internalCompanyId) {
        return this.queryInternal(INTERNAL_COMPANY, internalCompanyId);
    }

    private Optional<Long> queryInternal(String filterProperty, long filterId) {
        if (filterId <= 0L) {
            return Optional.empty();
        }
        DynamicObject targetDyn = QueryServiceHelper.queryOne((String)this.entityName, (String)this.masterIdField, (QFilter[])this.baseQFilterBuilder.toArray(new QFilter[]{new QFilter(filterProperty, "=", (Object)filterId)}));
        return targetDyn == null ? Optional.empty() : Optional.of(targetDyn.getLong(this.masterIdField));
    }
}

