/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.autotrans;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.MasterBaseDataUtils;

public class FinalProcessAssgrp {
    private static final String Key_Assgrp = "fieldname";
    private Map<String, AssgrpValues> flex2values;
    private Map<String, AssgrpValues> number2values;
    private Set<Long> hgIds;
    private DataSet hgIdSet;
    private FlexEntireData tempFlexEntireData = new FlexEntireData();
    private static final int SAVE_THRESHOLD = 999;
    private final PerformanceWatch watch = new PerformanceWatch(this.getClass(), "finalProcessAssgrp", false);

    public static FinalProcessAssgrp create(DynamicObjectCollection expEntries) {
        if (expEntries == null || expEntries.isEmpty()) {
            return null;
        }
        HashMap<String, AssgrpValues> flex2values = new HashMap<String, AssgrpValues>(expEntries.size());
        HashMap<String, AssgrpValues> number2values = new HashMap<String, AssgrpValues>(expEntries.size());
        for (DynamicObject row : expEntries) {
            DynamicObject assgrp = row.getDynamicObject(Key_Assgrp);
            String valueType = assgrp.getString("valuetype");
            String entity = null;
            Set values = null;
            Boolean isBaseData = Boolean.TRUE;
            Tuple2<Set<Object>, List<String>> baseDataVal2Num = new Tuple2<Set<Object>, List<String>>(null, null);
            if ("1".equals(valueType)) {
                entity = assgrp.getString("valuesource.number");
                baseDataVal2Num = FinalProcessAssgrp.getBaseDataVal2Num(entity, row);
                values = (Set)baseDataVal2Num.t1;
            } else if ("2".equals(valueType)) {
                entity = "bos_assistantdata_detail";
                baseDataVal2Num = FinalProcessAssgrp.getBaseDataVal2Num(entity, row);
                values = (Set)baseDataVal2Num.t1;
            } else {
                String txtVal = row.getString("txtval");
                if (StringUtils.isNotBlank((CharSequence)txtVal)) {
                    isBaseData = Boolean.FALSE;
                    String[] split = txtVal.split(";");
                    values = Stream.of(split).collect(Collectors.toSet());
                }
            }
            AssgrpValues assgrpValues = new AssgrpValues(values, isBaseData, (List)baseDataVal2Num.t2);
            flex2values.put(assgrp.getString("flexfield"), assgrpValues);
            number2values.put(assgrp.getString("number"), assgrpValues);
        }
        return new FinalProcessAssgrp(flex2values, number2values);
    }

    public static FinalProcessAssgrp create(String assgrpJsonVal) {
        if (StringUtils.isNotBlank((CharSequence)assgrpJsonVal)) {
            JSONObject valueJson = JSONObject.parseObject((String)assgrpJsonVal);
            Set flexs = valueJson.keySet();
            DynamicObjectCollection flexDyns = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield, valuetype", (QFilter[])new QFilter("flexfield", "in", (Object)flexs).toArray());
            Map<String, Boolean> flex2isBaseData = flexDyns.stream().collect(Collectors.toMap(x -> x.getString("flexfield"), x -> !"3".equals(x.getString("valuetype"))));
            Map<String, AssgrpValues> flex2values = flex2isBaseData.entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> {
                Object value = valueJson.get(x.getKey());
                Set<Object> values = Stream.of(value).collect(Collectors.toSet());
                AssgrpValues assgrpValues = new AssgrpValues(values, (Boolean)x.getValue(), null);
                return assgrpValues;
            }));
            return new FinalProcessAssgrp(flex2values, null);
        }
        return null;
    }

    private static Tuple2<Set<Object>, List<String>> getBaseDataVal2Num(String entity, DynamicObject row) {
        DynamicObjectCollection values = row.getDynamicObjectCollection("value");
        HashSet<Long> ids = new HashSet<Long>(values.size());
        for (DynamicObject value : values) {
            ids.add(value.getLong("fbasedataid_id"));
        }
        QFilter filter = new QFilter("id", "in", ids);
        String masterIDField = MasterBaseDataUtils.getMasterIdField(entity);
        String selectField = "number" + (!StringUtils.isEmpty((CharSequence)masterIDField) ? ", " + masterIDField : "");
        Map valueDyns = BusinessDataServiceHelper.loadFromCache((String)entity, (String)selectField, (QFilter[])filter.toArray());
        List baseDataNumbers = valueDyns.values().stream().map(v -> v.getString("number")).collect(Collectors.toList());
        Set masterIDs = valueDyns.values().stream().map(dyo -> !StringUtils.isEmpty((CharSequence)masterIDField) ? dyo.get(masterIDField) : dyo.getPkValue()).collect(Collectors.toSet());
        return new Tuple2(masterIDs, baseDataNumbers);
    }

    private FinalProcessAssgrp(Map<String, AssgrpValues> flex2values, Map<String, AssgrpValues> number2values) {
        this.flex2values = flex2values;
        this.number2values = number2values;
    }

    protected FinalProcessAssgrp() {
    }

    public Map<String, AssgrpValues> getFlex2values() {
        return this.flex2values;
    }

    public void setFlex2values(Map<String, AssgrpValues> flex2values) {
        this.flex2values = flex2values;
    }

    public Map<String, AssgrpValues> getNumber2values() {
        return this.number2values;
    }

    public void setNumber2values(Map<String, AssgrpValues> number2values) {
        this.number2values = number2values;
    }

    public Set<Long> getHgIds() {
        if (this.hgIds == null) {
            this.parseToHgIds();
        }
        return this.hgIds;
    }

    public DataSet getHgIdSet() {
        if (this.hgIdSet == null) {
            this.parseToHgIdSet();
        }
        return this.hgIdSet;
    }

    public AssgrpValues getValuesByAssgrpNumber(String number) {
        AssgrpValues result = null;
        if (StringUtils.isNotBlank((CharSequence)number)) {
            for (Map.Entry<String, AssgrpValues> entry : this.getNumber2values().entrySet()) {
                if (!number.equals(entry.getKey())) continue;
                result = entry.getValue();
                break;
            }
        }
        return result;
    }

    private void parseToHgIds() {
        List<Tuple<FlexProperty, AssgrpValues>> valuesList = this.getFlex2values().entrySet().stream().filter(e -> !((AssgrpValues)e.getValue()).getValues().isEmpty()).map(e -> Tuple.create(FlexUtils.getFlexProperty((String)e.getKey()), e.getValue())).collect(Collectors.toList());
        LinkedList<FlexEntireData.FlexData> path = new LinkedList<FlexEntireData.FlexData>();
        int cartesianProductCount = valuesList.stream().mapToInt(tuple -> ((AssgrpValues)tuple.item2).getValues().size()).reduce((s1, s2) -> s1 * s2).orElse(0);
        this.hgIds = new HashSet<Long>(cartesianProductCount);
        int initialCapacity = Math.min(cartesianProductCount, 999);
        ArrayList<FlexEntireData> result = new ArrayList<FlexEntireData>(initialCapacity);
        this.backtrack(valuesList, 0, path, result);
        if (!result.isEmpty()) {
            this.watch.start("execute last batch save");
            this.hgIds.addAll(FlexUtils.batchSaveFlexData(result));
            this.watch.stop();
        }
    }

    private void backtrack(List<Tuple<FlexProperty, AssgrpValues>> valuesList, int curIndex, LinkedList<FlexEntireData.FlexData> path, List<FlexEntireData> result) {
        if (curIndex == valuesList.size()) {
            FlexEntireData flexEntireData = new FlexEntireData();
            flexEntireData.setFlexDatas(new ArrayList<FlexEntireData.FlexData>(path));
            result.add(flexEntireData);
            this.saveIfExceedThreshold(result);
            return;
        }
        Tuple<FlexProperty, AssgrpValues> flexPropertyAssgrpValuesTuple = valuesList.get(curIndex);
        AssgrpValues assgrpValues = (AssgrpValues)flexPropertyAssgrpValuesTuple.item2;
        for (Object value : assgrpValues.getValues()) {
            FlexEntireData flexEntireData = this.tempFlexEntireData;
            flexEntireData.getClass();
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData, (FlexProperty)flexPropertyAssgrpValuesTuple.item1, value);
            flexData.setDbType(assgrpValues.isBaseData != false ? FlexEntireData.FlexFieldDataType.LONG : FlexEntireData.FlexFieldDataType.STRING);
            path.addLast(flexData);
            this.backtrack(valuesList, curIndex + 1, path, result);
            path.removeLast();
        }
    }

    private void saveIfExceedThreshold(List<FlexEntireData> flexEntireDataList) {
        if (flexEntireDataList.size() >= 999) {
            this.watch.start("execute saveIfExceedThreshold()");
            this.hgIds.addAll(FlexUtils.batchSaveFlexData(flexEntireDataList));
            flexEntireDataList.clear();
            this.watch.stop();
        }
    }

    private void parseToHgIdSet() {
        for (Map.Entry<String, AssgrpValues> row : this.flex2values.entrySet()) {
            Set<Object> values;
            String flex = row.getKey();
            AssgrpValues assgrpValues = row.getValue();
            if (assgrpValues == null || (values = assgrpValues.getValues()) == null || values.isEmpty() || assgrpValues.isBaseData.booleanValue() && values.size() == 1 && Long.valueOf(0L).equals(values.iterator().next())) continue;
            DataSet hgDataSet = this.getHgDataSet(flex, values, assgrpValues.isBaseData);
            if (this.hgIdSet == null) {
                this.hgIdSet = hgDataSet;
                continue;
            }
            this.hgIdSet = this.hgIdSet.join(hgDataSet, JoinType.INNER).on("hg", "hg").select(new String[]{"hg"}).finish();
        }
    }

    private DataSet getHgDataSet(String flexField, Set<Object> values, boolean isBaseData) {
        QFilter flexFilter = new QFilter("asstype", "=", (Object)flexField);
        QFilter valueFilter = new QFilter("assval", "in", values);
        String entity = "gl_assist_txt";
        if (isBaseData) {
            valueFilter = valueFilter.and(new QFilter("assval", "!=", (Object)0));
            entity = "gl_assist_bd";
        }
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".getHgDataSet"), (String)entity, (String)"hg", (QFilter[])new QFilter[]{flexFilter, valueFilter}, null);
    }

    public static class AssgrpValues {
        private Set<Object> values;
        private Boolean isBaseData;
        private List<String> baseDataNumbers;

        public AssgrpValues(Set<Object> values, Boolean isBaseData, List<String> baseDataNumbers) {
            this.values = values;
            this.isBaseData = isBaseData;
            this.baseDataNumbers = baseDataNumbers;
        }

        public Set<Object> getValues() {
            if (this.values == null) {
                this.values = new HashSet<Object>(0);
            }
            return this.values;
        }

        public void setValues(Set<Object> values) {
            this.values = values;
        }

        public List<String> getBaseDataNumbers() {
            return this.baseDataNumbers;
        }

        public void setBaseDataNumbers(List<String> baseDataNumbers) {
            this.baseDataNumbers = baseDataNumbers;
        }

        public Boolean getIsBaseData() {
            return this.isBaseData;
        }

        public void setIsBaseData(Boolean isBaseData) {
            this.isBaseData = isBaseData;
        }
    }
}

