/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.service.voucher.TempVoucherCFService;
import kd.fi.bd.service.voucher.TempVoucherService;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.balcal.BalExtendTrigger;
import kd.fi.gl.balcal.BalanceCalculator;
import kd.fi.gl.balcal.Data;
import kd.fi.gl.balcal.Key;
import kd.fi.gl.balcal.Log;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.balcal.Params;
import kd.fi.gl.balcal.log.BalChangeAction;
import kd.fi.gl.balcal.log.DataChangeLog;
import kd.fi.gl.business.dao.balance.BalanceDelLogDao;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.interfaces.service.bal.log.BalChangeLogger;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.GLUtil;
import kd.sdk.fi.gl.extpoint.bal.BalKey;

public abstract class AbstractCalculator<D extends Data, L extends Log, K extends Key>
implements ICalculator {
    protected static final int MAX_RECORD_NUM = 200;
    protected static final int MAX_UPDATE_PARAM_NUM = 2000;
    protected static final DBRoute gl = DBRoute.of((String)"gl");
    protected static kd.bos.logging.Log logger = LogFactory.getLog((String)"kd.fi.gl.balcal.AbstractCalculator");
    protected static final String STANDALONE_TRANSACTION_PARAM = "balance_calculator_standalone_transaction";
    protected List<CommonAssist> comassist = new ArrayList<CommonAssist>(2);
    protected Collection<LocalCurrencyConfigVO> localCurList = new ArrayList<LocalCurrencyConfigVO>(3);
    private List<BalKey> delBal = new ArrayList<BalKey>();
    private BalChangeLogger balChangeLogger;

    protected BalChangeLogger getBalChangeLogger() {
        if (this.balChangeLogger == null) {
            this.balChangeLogger = BalChangeLogger.create();
        }
        return this.balChangeLogger;
    }

    @Override
    public int calculate(long orgId, long bookTypeId) {
        Date updateTime = new Date();
        this.initComassist(orgId, bookTypeId);
        this.initMulLocalCurrency(orgId, bookTypeId);
        DataSet ds = DB.queryDataSet((String)"AbstractCalculator.reCalculate", (DBRoute)gl, (String)this.getLogSql(), (Object[])this.getLogParams(orgId, bookTypeId));
        Integer count = this.updateBalance(orgId, bookTypeId, ds, false, 0L);
        BalExtendTrigger.updateBal(orgId, bookTypeId, updateTime, this instanceof BalanceCalculator);
        if (!this.delBal.isEmpty()) {
            BalExtendTrigger.delBal(orgId, bookTypeId, this.delBal, this instanceof BalanceCalculator);
            if (this instanceof BalanceCalculator) {
                BalanceDelLogDao.saveAcctLog(orgId, bookTypeId, this.delBal);
            } else {
                BalanceDelLogDao.saveCfitemLog(orgId, bookTypeId, this.delBal);
            }
        }
        return count;
    }

    @Override
    public int reCalculate(long orgId, long bookTypeId, long periodId) {
        Date updateTime = new Date();
        this.initComassist(orgId, bookTypeId);
        this.initMulLocalCurrency(orgId, bookTypeId);
        DataSet dataSet = this.getBillDataSet(orgId, bookTypeId, periodId);
        dataSet = this.transferMid(dataSet);
        Integer count = this.updateBalance(orgId, bookTypeId, dataSet, true, periodId);
        BalExtendTrigger.updateBal(orgId, bookTypeId, updateTime, this instanceof BalanceCalculator);
        return count;
    }

    @Override
    public int reCalculateByAccount(long orgId, long bookTypeId, long periodId, Set<Long> accountMasterIds) {
        this.initComassist(orgId, bookTypeId);
        this.initMulLocalCurrency(orgId, bookTypeId);
        boolean entryRedundantFilterEnable = VoucherQueryUtils.isEntryRedundantFilterEnable();
        DataSet ds = DB.queryDataSet((String)"reCalculateByAccount", (DBRoute)gl, (String)this.getBillSqlAccount(orgId, accountMasterIds.size(), entryRedundantFilterEnable), (Object[])this.getBillParams(orgId, bookTypeId, periodId, accountMasterIds, entryRedundantFilterEnable));
        ds = this.transferMid(ds);
        return this.updateBalance(orgId, bookTypeId, ds, true, periodId);
    }

    protected void initComassist(long orgId, long bookTypeId) {
        Optional<ComAssistTable> assistTable = ComAssistTable.get(orgId, bookTypeId);
        this.comassist = assistTable.get().getCommonAssists();
    }

    protected void initMulLocalCurrency(long orgId, long bookTypeId) {
        this.localCurList = LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)bookTypeId);
    }

    protected DataSet transferMid(DataSet ds) {
        HashMap<Integer, Set> map = new HashMap<Integer, Set>();
        int size = this.comassist.size();
        HashSet<Integer> hasMid = new HashSet<Integer>(2);
        for (int i = 1; i <= size; ++i) {
            if (!CommonAssistUtil.hasMasteridProp(this.comassist.get((int)(i - 1)).valueSource)) continue;
            hasMid.add(i);
        }
        if (!hasMid.isEmpty()) {
            for (Row row : ds.copy()) {
                Iterator iterator = hasMid.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    Set ids = map.computeIfAbsent(i, x -> new HashSet());
                    ids.add(row.getLong("fcomassist" + i + "id"));
                }
            }
            Iterator iterator = hasMid.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String comField = "fcomassist" + i + "id";
                DataSet comds = QueryServiceHelper.queryDataSet((String)"AbstractCalculator.reCalculate", (String)this.comassist.get((int)(i - 1)).valueSource, (String)("id " + comField + ",masterid"), (QFilter[])new QFilter[]{new QFilter("id", "in", map.get(i))}, null);
                List<String> fields = GLUtil.getDataSetCols(ds);
                int finalI = i;
                fields.removeIf(x -> x.equals("fcomassist" + finalI + "id"));
                ds = ds.join(comds, JoinType.LEFT).on(comField, comField).select(fields.toArray(new String[0]), new String[]{"masterid " + comField}).finish();
            }
        }
        ds = ds.orderBy(this.getOrderBy());
        return ds;
    }

    protected abstract Integer updateBalance(long var1, long var3, DataSet var5, boolean var6, long var7);

    protected void updateBalance(long orgId, long bookTypeId, long periodId, LogList<K> logList, List<Long> logIds, Tuple<List<Long>, List<Long>> periodList, boolean reCal, long startPeriodId, Set<Long> voucherIds) {
        LogList<K> sumLogList;
        if (DebugTrace.enable()) {
            logger.info("update_balance perildId= " + periodId + ", periodList:" + StringUtils.join((Object[])new Serializable[]{periodList, ","}));
        }
        this.getBalChangeLogger().recordDataChangeSource(this.getTab(), logIds);
        Map<K, List<D>> balData = this.getBalanceData(orgId, bookTypeId, logList, (List)periodList.item1, reCal, this.getTab());
        Params params = new Params();
        this.buildBalParams(orgId, bookTypeId, periodId, logList, reCal, startPeriodId, balData, params, true);
        Map<String, DataChangeLog> dataId2Log = this.getBalChangeLogger().getDataId2Log(this.getTab(), balData);
        Params sumParams = new Params();
        if (!reCal && !(sumLogList = this.sumLogList(logList)).getData().isEmpty()) {
            Map<K, List<D>> sumBalData = this.getBalanceData(orgId, bookTypeId, sumLogList, (List)periodList.item2, reCal, this.getSumupTab());
            Map<String, DataChangeLog> sumDataId2Log = this.getBalChangeLogger().getDataId2Log(this.getSumupTab(), sumBalData);
            dataId2Log.putAll(sumDataId2Log);
            this.buildBalParams(orgId, bookTypeId, periodId, sumLogList, reCal, startPeriodId, sumBalData, sumParams, false);
        }
        Tuple<Params, Params> tuple = new Tuple<Params, Params>(params, sumParams);
        HintCondition hintOrg = new HintCondition("forgid", "=", (Object)orgId);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.getTab(), (HintCondition[])new HintCondition[]{hintOrg}).prepareShardingIndex();){
            this.storeDB(tuple, logIds, reCal, voucherIds, dataId2Log);
        }
        logList.clear();
    }

    protected void buildBalParams(long orgId, long bookTypeId, long periodId, LogList<K> logList, boolean reCal, long startPeriodId, Map<K, List<D>> balData, Params params, boolean isDetail) {
        for (Map.Entry<K, Log> entry : logList.getData().entrySet()) {
            Key key = (Key)entry.getKey();
            Log logData = entry.getValue();
            List balList = balData.computeIfAbsent(key, k -> null);
            if (balList != null && !balList.isEmpty()) {
                Iterator it = balList.iterator();
                if (!it.hasNext()) continue;
                Data bal = (Data)it.next();
                Data preBal = null;
                while (it.hasNext() && bal.getEndPeriodId() < periodId) {
                    preBal = bal = (Data)it.next();
                }
                if (bal.getEndPeriodId() == periodId && it.hasNext()) {
                    preBal = bal;
                    bal = (Data)it.next();
                }
                if (!it.hasNext()) {
                    this.putCache(bal);
                }
                long curBalId = bal.getId();
                long preEndPeriodId = bal.getEndPeriodId();
                if (bal.getPeriodId() == periodId) {
                    Object[] param;
                    if (bal.getCount() + logData.getCount() == 0 && (preBal != null || this.isBalZero(bal, logData))) {
                        params.addRemoveBalId(bal.getId());
                        if (isDetail) {
                            this.delBal.add(this.buildExtBalKey(key, periodId, bal.getEndPeriodId(), curBalId));
                        }
                        if (preBal != null) {
                            params.addUpdateEndPeriodParam(new Object[]{bal.getEndPeriodId(), DateUtils.now(), preBal.getId()});
                        }
                    }
                    if ((param = this.getUpdateBalParam(periodId, logData, bal, preBal, reCal, startPeriodId)).length <= 0) continue;
                    params.addUpdateBalParam(param);
                    if (!reCal) {
                        this.dealNext(periodId, logData, it, params, curBalId, preEndPeriodId);
                        continue;
                    }
                    this.recalDealNext(periodId, logData, it, params, bal, curBalId, preEndPeriodId);
                    continue;
                }
                if (bal.getPeriodId() < periodId) {
                    long endPeriodId = it.hasNext() ? bal.getEndPeriodId() : GLUtil.MAX_PERIOD.longValue();
                    params.addUpdateEndPeriodParam(new Object[]{periodId, DateUtils.now(), bal.getId()});
                    params.addNewBalParam(this.getNewBalParam(orgId, bookTypeId, periodId, key, logData, bal, endPeriodId, isDetail));
                    this.dealNext(periodId, logData, it, params, 0L, endPeriodId);
                    continue;
                }
                long endPeriodId = bal.getPeriodId();
                params.addNewBalParam(this.getNewBalParam(orgId, bookTypeId, periodId, key, logData, null, endPeriodId, isDetail));
                this.dealNext(periodId, logData, balList.iterator(), params, 0L, endPeriodId);
                continue;
            }
            params.addNewBalParam(this.getNewBalParam(orgId, bookTypeId, periodId, key, logData, null, GLUtil.MAX_PERIOD, isDetail));
            this.putCache(logData, key, orgId, bookTypeId, periodId);
        }
    }

    protected abstract BalKey buildExtBalKey(K var1, long var2, long var4, long var6);

    protected abstract LogList<K> sumLogList(LogList<K> var1);

    protected abstract boolean isBalZero(D var1, L var2);

    protected abstract void updateVerBalance();

    protected abstract void putCache(D var1);

    protected String getDynparam(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(",?");
        }
        return sb.toString();
    }

    protected abstract void putCache(L var1, K var2, long var3, long var5, long var7);

    protected abstract DataSet getBillDataSet(long var1, long var3, long var5);

    protected void storeDB(Tuple<Params, Params> tupleParam, List<Long> logIds, boolean reCal, Set<Long> voucherIds, Map<String, DataChangeLog> dataId2Log) {
        boolean isStandAloneTran = true;
        Object transactionParam = ThreadCache.get((Object)STANDALONE_TRANSACTION_PARAM);
        if (transactionParam != null) {
            isStandAloneTran = Boolean.parseBoolean(transactionParam.toString());
        }
        try (TXHandle h = isStandAloneTran ? TX.requiresNew((String)(this.getClass().getName() + "update")) : TX.required((String)(this.getClass().getName() + "update"));){
            try {
                Params params = (Params)tupleParam.item1;
                this.storeBalData(reCal, params, dataId2Log);
                Params sumParams = (Params)tupleParam.item2;
                this.storeSumBalData(reCal, sumParams, dataId2Log);
                this.setCalculateStatus(logIds);
                if (!voucherIds.isEmpty()) {
                    TempVoucherService.deleteByIds((Long[])voucherIds.toArray(new Long[0]));
                    TempVoucherCFService.deleteByIds((Long[])voucherIds.toArray(new Long[0]));
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
                throw e;
            }
            finally {
                logIds.clear();
            }
        }
    }

    protected void storeBalData(boolean reCal, Params params, Map<String, DataChangeLog> dataId2Log) {
        BalChangeAction action;
        BalChangeAction balChangeAction = action = reCal ? BalChangeAction.RE_CAL : BalChangeAction.CAL_BAL_LOG;
        if (!params.getRemoveBalIds().isEmpty()) {
            this.getBalChangeLogger().recordRemoveData(this.getTab(), params.getRemoveBalIds().toArray(), dataId2Log, action);
            DB.execute((DBRoute)gl, (SqlBuilder)this.getRemoveBalSql(new ArrayList<Object>(params.getRemoveBalIds()), this.getTab()));
        }
        if (!params.getUpdateEndPeriodParams().isEmpty()) {
            this.getBalChangeLogger().recordUpdateEndPeriod(this.getTab(), params.getUpdateEndPeriodParams(), dataId2Log, reCal);
            DB.executeBatch((DBRoute)gl, (String)("UPDATE " + this.getTab() + " set fendperiodid = ?,fmodifytime=? where fid = ?"), params.getUpdateEndPeriodParams());
        }
        if (!params.getNewBalParams().isEmpty()) {
            this.getBalChangeLogger().recordInsertData(this.getTab(), params.getNewBalParams(), reCal, this.comassist.size());
            DB.executeBatch((DBRoute)gl, (String)this.getInsertBalSql(), params.getNewBalParams());
        }
        if (!params.getUpdateBalParams().isEmpty()) {
            this.getBalChangeLogger().recordUpdateBal(this.getTab(), params.getUpdateBalParams(), dataId2Log, reCal);
            DB.executeBatch((DBRoute)gl, (String)this.getUpdBalSql(reCal), params.getUpdateBalParams());
        }
        if (!params.getUpdateCurrYBalParams().isEmpty()) {
            this.getBalChangeLogger().recordUpdateCurrYBal(this.getTab(), params.getUpdateCurrYBalParams(), dataId2Log, reCal);
            DB.executeBatch((DBRoute)gl, (String)this.getUpdCurrYBalSql(), params.getUpdateCurrYBalParams());
        }
        if (!params.getUpdateLaterYBalParams().isEmpty()) {
            this.getBalChangeLogger().recordUpdateLaterYBal(this.getTab(), params.getUpdateLaterYBalParams(), dataId2Log, reCal);
            DB.executeBatch((DBRoute)gl, (String)this.getUpdLaterYBalSql(), params.getUpdateLaterYBalParams());
        }
    }

    protected void storeSumBalData(boolean reCal, Params params, Map<String, DataChangeLog> dataId2Log) {
        BalChangeAction action = reCal ? BalChangeAction.RE_CAL : BalChangeAction.CAL_BAL_LOG;
        logger.info("store_sumbal_data: {}", (Object)SerializationUtils.toJsonString((Object)params));
        if (!params.getRemoveBalIds().isEmpty()) {
            this.getBalChangeLogger().recordRemoveData(this.getTab(), params.getRemoveBalIds().toArray(), dataId2Log, action);
            DB.execute((DBRoute)gl, (SqlBuilder)this.getRemoveBalSql(new ArrayList<Object>(params.getRemoveBalIds()), this.getSumupTab()));
        }
        if (!params.getUpdateEndPeriodParams().isEmpty()) {
            this.getBalChangeLogger().recordUpdateEndPeriod(this.getTab(), params.getUpdateEndPeriodParams(), dataId2Log, reCal);
            DB.executeBatch((DBRoute)gl, (String)("UPDATE " + this.getSumupTab() + " set fendperiodid = ?,fmodifytime=? where fid = ?"), params.getUpdateEndPeriodParams());
        }
        if (!params.getNewBalParams().isEmpty()) {
            this.getBalChangeLogger().recordInsertData(this.getSumupTab(), params.getNewBalParams(), reCal, this.comassist.size());
            DB.executeBatch((DBRoute)gl, (String)this.getInsertSumBalSql(), params.getNewBalParams());
        }
        if (!params.getUpdateBalParams().isEmpty()) {
            this.getBalChangeLogger().recordUpdateBal(this.getTab(), params.getUpdateBalParams(), dataId2Log, reCal);
            DB.executeBatch((DBRoute)gl, (String)this.getUpdSumBalSql(reCal), params.getUpdateBalParams());
        }
        if (!params.getUpdateCurrYBalParams().isEmpty()) {
            this.getBalChangeLogger().recordUpdateCurrYBal(this.getTab(), params.getUpdateCurrYBalParams(), dataId2Log, reCal);
            DB.executeBatch((DBRoute)gl, (String)this.getUpdCurrYSumBalSql(), params.getUpdateCurrYBalParams());
        }
        if (!params.getUpdateLaterYBalParams().isEmpty()) {
            this.getBalChangeLogger().recordUpdateLaterYBal(this.getTab(), params.getUpdateLaterYBalParams(), dataId2Log, reCal);
            DB.executeBatch((DBRoute)gl, (String)this.getUpdLaterYSumBalSql(), params.getUpdateLaterYBalParams());
        }
    }

    private SqlBuilder getRemoveBalSql(List<Object> ids, String tablename) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from ", new Object[0]);
        sql.append(tablename, new Object[0]);
        sql.appendIn(" where fid ", ids);
        return sql;
    }

    public void setLocalCurList(Collection<LocalCurrencyConfigVO> localCurList) {
        this.localCurList = localCurList;
    }

    protected Map<K, List<D>> getBalanceData(long orgId, long bookTypeId, LogList<K> logList, List<Long> periodIdList, boolean reCal, String tablename) {
        SqlBuilder sqlBuilder = this.getBalSqlBuilder(orgId, bookTypeId, periodIdList, logList, reCal, tablename);
        DataSet ds = DB.queryDataSet((String)"AbstractCalculator.getBalanceData", (DBRoute)gl, (SqlBuilder)sqlBuilder);
        HashMap<Key, List> data = new HashMap<Key, List>();
        for (Row rs : ds) {
            K key = this.getTab().equals(tablename) ? this.getPK(rs) : this.getSumupPK(rs);
            List dataList = data.computeIfAbsent((Key)key, k -> new ArrayList());
            dataList.add(this.getBalanceData(rs, reCal));
        }
        return data;
    }

    private SqlBuilder getBalSqlBuilder(long orgId, long bookTypeId, List<Long> periodIdList, LogList<K> logList, boolean reCal, String tablename) {
        String[] keys;
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT fid,fperiodid,fendperiodid,forgid,fbooktypeid,", new Object[0]);
        for (String string : keys = this.getTab().equals(tablename) ? this.getKeyFields() : this.getSumupKeyFields()) {
            sql.append(string, new Object[0]).append(",", new Object[0]);
        }
        sql.append(this.getAmountSelectFields(reCal), new Object[0]);
        sql.append(", fcount FROM", new Object[0]).append(tablename, new Object[0]).append(" where forgid = ?", new Object[]{orgId}).append(" and fbooktypeid=? and", new Object[]{bookTypeId}).appendIn(" fendperiodid", periodIdList.toArray());
        Object[] params = new Object[keys.length];
        for (int j = 0; j < keys.length; ++j) {
            params[j] = new HashSet(200);
        }
        Set<K> logKeys = logList.getData().keySet();
        for (Key key : logKeys) {
            Long[] keyValue;
            int i = 0;
            for (Long p : keyValue = this.getTab().equals(tablename) ? key.getKeyValues() : key.getSumupKeyValues()) {
                ((Set)params[i]).add(p);
                ++i;
            }
        }
        for (int j = 0; j < keys.length; ++j) {
            sql.append(" and ", new Object[0]);
            sql.appendIn(keys[j], ((Set)params[j]).toArray());
        }
        sql.append(" ORDER BY fendperiodid", new Object[0]);
        return sql;
    }

    private Object[] getLogParams(long orgId, long bookTypeId) {
        return new Object[]{orgId, bookTypeId};
    }

    protected abstract Object[] getBillParams(long var1, long var3, long var5);

    protected abstract Object[] getBillParams(long var1, long var3, long var5, Set<Long> var7, boolean var8);

    protected void setCalculateStatus(List<Long> logIds) {
        if (logIds.isEmpty()) {
            return;
        }
        ArrayList<Long> logs = new ArrayList<Long>(2000);
        for (Long id : logIds) {
            if (logs.size() > 2000) {
                this.updateLogStatus(logs);
                logs.clear();
            }
            logs.add(id);
        }
        if (!logs.isEmpty()) {
            this.updateLogStatus(logs);
        }
    }

    private void updateLogStatus(List<Long> logIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update ", new Object[0]);
        sqlBuilder.append(this.getLogTab(), new Object[0]);
        sqlBuilder.appendIn(" set fcalculated='1' where fid ", logIds.toArray());
        DB.execute((DBRoute)gl, (SqlBuilder)sqlBuilder);
    }

    protected Object[] getNewBalParam(long orgId, long bookTypeId, long periodId, K pk, L logData, D preBalData, long endPeriodId, boolean isDetail) {
        Long[] keys = isDetail ? ((Key)pk).getKeyValues() : ((Key)pk).getSumupKeyValues();
        ArrayList<Serializable> param = new ArrayList<Serializable>(keys.length);
        long balId = this.genId();
        param.add(Long.valueOf(balId));
        param.add(Long.valueOf(orgId));
        param.add(Long.valueOf(bookTypeId));
        param.add(Long.valueOf(periodId));
        param.add(Long.valueOf(endPeriodId));
        for (int i = 0; i < keys.length; ++i) {
            param.add(keys[i]);
        }
        param.addAll(this.getNewBalAmtParam(pk, periodId, logData, preBalData));
        param.add(Integer.valueOf(((Log)logData).getCount()));
        param.add(DateUtils.now());
        return param.toArray();
    }

    private Object[] getUpdateBalParam(long periodId, L logData, D bal, D preBal, boolean reCal, long startPeriodId) {
        List<BigDecimal> updParam = this.getUpdateBalAmtParam(periodId, logData, bal, preBal, reCal, startPeriodId);
        if (reCal && this.equals(bal, updParam.toArray(new BigDecimal[0]))) {
            return new Object[0];
        }
        ArrayList<Serializable> param = new ArrayList<Serializable>();
        param.addAll(updParam);
        param.add(Integer.valueOf(((Log)logData).getCount()));
        param.add(DateUtils.now());
        param.add(Long.valueOf(((Data)bal).getId()));
        return param.toArray();
    }

    protected long genId() {
        return DB.genLongId((String)this.getTab());
    }

    protected abstract boolean equals(D var1, BigDecimal[] var2);

    protected abstract List<BigDecimal> getNewBalAmtParam(K var1, long var2, L var4, D var5);

    protected abstract List<BigDecimal> getUpdateBalAmtParam(long var1, L var3, D var4, D var5, boolean var6, long var7);

    protected abstract void dealNext(long var1, L var3, Iterator<D> var4, Params var5, long var6, long var8);

    protected abstract void recalDealNext(long var1, L var3, Iterator<D> var4, Params var5, D var6, long var7, long var9);

    protected abstract String getTab();

    protected abstract String getSumupTab();

    protected abstract String getLogTab();

    protected abstract String getLogSql();

    protected String getComassistField() {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= this.comassist.size(); ++i) {
            sb.append("fcomassist").append(i).append("id,");
        }
        return sb.toString();
    }

    protected abstract String[] getOrderBy();

    protected abstract String getBillSqlAccount(long var1, int var3, boolean var4);

    protected abstract String getAmountSelectFields(boolean var1);

    protected abstract String[] getKeyFields();

    protected abstract String[] getSumupKeyFields();

    protected abstract String getUpdBalSql(boolean var1);

    protected abstract String getInsertBalSql();

    protected abstract String getUpdCurrYBalSql();

    protected abstract String getUpdLaterYBalSql();

    protected String getUpdSumBalSql(boolean reCal) {
        return "";
    }

    protected String getInsertSumBalSql() {
        return "";
    }

    protected String getUpdCurrYSumBalSql() {
        return "";
    }

    protected String getUpdLaterYSumBalSql() {
        return "";
    }

    protected abstract K getPK(ResultSet var1) throws SQLException;

    protected abstract K getSumupPK(Row var1);

    protected abstract K getPK(Row var1);

    protected abstract L getLogData(Row var1);

    protected abstract D getBalanceData(Row var1, boolean var2);
}

