/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import kd.fi.gl.balcal.BalanceLog;
import kd.fi.gl.balcal.Log;

public class AcctBalanceLog
extends BalanceLog {
    private BigDecimal beginFor = BigDecimal.ZERO;
    private BigDecimal beginLocal = BigDecimal.ZERO;
    private BigDecimal beginQty = BigDecimal.ZERO;

    @Override
    public void add(Log log) {
        if (log instanceof AcctBalanceLog) {
            super.add(log);
            AcctBalanceLog data = (AcctBalanceLog)log;
            this.beginFor = this.beginFor.add(data.beginFor);
            this.beginLocal = this.beginLocal.add(data.beginLocal);
            this.beginQty = this.beginQty.add(data.beginQty);
        }
    }

    @Override
    public void subtract(Log log) {
        super.subtract(log);
        if (log instanceof AcctBalanceLog) {
            AcctBalanceLog data = (AcctBalanceLog)log;
            this.beginFor = this.beginFor.subtract(data.beginFor);
            this.beginLocal = this.beginLocal.subtract(data.beginLocal);
            this.beginQty = this.beginQty.subtract(data.beginQty);
        }
    }

    @Override
    public void negate() {
        super.negate();
        this.beginFor = this.beginFor.negate();
        this.beginLocal = this.beginLocal.negate();
        this.beginQty = this.beginQty.negate();
    }

    public BigDecimal getBeginFor() {
        return this.beginFor;
    }

    public void setBeginFor(BigDecimal beginFor) {
        this.beginFor = beginFor;
    }

    public BigDecimal getBeginLocal() {
        return this.beginLocal;
    }

    public void setBeginLocal(BigDecimal beginLocal) {
        this.beginLocal = beginLocal;
    }

    public BigDecimal getBeginQty() {
        return this.beginQty;
    }

    public void setBeginQty(BigDecimal beginQty) {
        this.beginQty = beginQty;
    }

    @Override
    public boolean isZero() {
        return super.isZero() && BigDecimal.ZERO.compareTo(this.beginFor) == 0 && BigDecimal.ZERO.compareTo(this.beginLocal) == 0 && BigDecimal.ZERO.compareTo(this.beginQty) == 0;
    }

    @Override
    public String toString() {
        return "AcctBalanceLog{beginFor=" + this.beginFor + ", beginLocal=" + this.beginLocal + '}' + super.toString();
    }
}

