/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.balcal.BalanceKey;
import kd.fi.gl.comassist.ComassistMidTransterModel;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.util.CommonAssistUtil;

public class BalanceLogKey
extends BalanceKey {
    private long voucherId;
    private long orgId;
    private long bookTypeId;
    private long periodId;

    public BalanceLogKey(Row row, long acctTableId, ComassistMidTransterModel table) {
        super(acctTableId, row.getLong("masterid"), row.getLong("currency"), row.getLong("assgrp"), row.getLong("measureunit"), new ArrayList<Long>(2));
        this.voucherId = row.getLong("id");
        this.orgId = row.getLong("org");
        this.bookTypeId = row.getLong("booktype");
        this.periodId = row.getLong("period");
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        for (int i = 1; i <= size; ++i) {
            this.comassist.add(table.convertMid(i, row.getLong(CommonAssistUtil.getComassistField(i))));
        }
    }

    public BalanceLogKey(DynamicObject v, DynamicObject ve, ComassistMidTransterModel table) {
        super(ve.getLong("account.accounttable.id"), ve.getLong("account.masterid"), ve.getLong("currency.id"), ve.getLong("assgrp.id"), ve.getLong("measureunit.id"), new ArrayList<Long>(2));
        this.voucherId = v.getLong("id");
        this.orgId = v.getLong("org.id");
        this.bookTypeId = v.getLong("booktype.id");
        this.periodId = v.getLong("period.id");
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        for (int i = 1; i <= size; ++i) {
            this.comassist.add(table.convertMid(i, ve.getLong(CommonAssistUtil.getComassistField(i) + ".id")));
        }
    }

    @Override
    public Long[] getKeyValues() {
        ArrayList<Long> value = new ArrayList<Long>(10);
        value.add(this.voucherId);
        value.add(this.orgId);
        value.add(this.bookTypeId);
        value.add(this.periodId);
        value.add(this.getAccountId());
        value.add(this.getAccountTableId());
        value.add(this.getCurrencyId());
        value.add(this.getAssgrpId());
        value.add(this.getMeasureunitId());
        value.addAll(this.comassist);
        return value.toArray(new Long[0]);
    }

    public long getVoucherId() {
        return this.voucherId;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    @Override
    public List<Long> getComassist() {
        return this.comassist;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.bookTypeId ^ this.bookTypeId >>> 32);
        result = 31 * result + (int)(this.orgId ^ this.orgId >>> 32);
        result = 31 * result + (int)(this.periodId ^ this.periodId >>> 32);
        result = 31 * result + (int)(this.voucherId ^ this.voucherId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BalanceLogKey other = (BalanceLogKey)obj;
        if (this.bookTypeId != other.bookTypeId) {
            return false;
        }
        if (this.orgId != other.orgId) {
            return false;
        }
        if (this.periodId != other.periodId) {
            return false;
        }
        return this.voucherId == other.voucherId;
    }

    @Override
    public String toString() {
        return "voucherId=" + this.voucherId + ",orgId=" + this.orgId + ", bookTypeId=" + this.bookTypeId + ", periodId=" + this.periodId + "," + super.toString();
    }
}

