/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accountref.constant.BalTransferType;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.balcal.AbstractCalculatorVersionBal;
import kd.fi.gl.balcal.TransBalHandler;

public class BalanceVersionBalCal
extends AbstractCalculatorVersionBal {
    @Override
    protected void updateBal4One(long orgId, long btId, long acctTableId, long periodId, List<Long> acctIds, boolean isMasterId, TransBalHandler handler) {
        Map<Long, AccountTableRef> ref = this.getAcctTableRecord(orgId, btId, acctTableId, periodId, isMasterId);
        if (!ref.isEmpty()) {
            AccountTableRef aft = ref.values().iterator().next();
            AccountRef acctRef = new AccountRef();
            long nPid = ref.keySet().iterator().next();
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)nPid, (String)"bd_period");
            ArrayList<Long> newIds = new ArrayList<Long>(10);
            if (isMasterId) {
                Map<Long, Long> oldMap = this.getMaster2Id(orgId, period.getDate("enddate"), aft.getOldAccountTableId());
                Map<Long, Long> newMap = this.getMaster2Id(orgId, period.getDate("enddate"), aft.getNewAccountTableId());
                for (Long acctId : acctIds) {
                    Long newAcctMasterId = (Long)aft.getAccountRef().getOldAndNewAccountRef().get(acctId);
                    if (!Objects.nonNull(newAcctMasterId)) continue;
                    long newAcctId = newMap.get(newAcctMasterId);
                    Set oldMasterIds = aft.getOldAccountIds(newAcctMasterId);
                    Iterator ite = oldMasterIds.iterator();
                    while (ite.hasNext()) {
                        long id = (Long)ite.next();
                        acctRef.addAccountRef(Long.valueOf(newAcctId), (Long)oldMap.get(id), aft.getNewDefaultAssgrp(Long.valueOf(id)).getAssgrpRef());
                    }
                    newIds.add(newAcctId);
                }
            } else {
                for (Long acctId : acctIds) {
                    Long newAcctId = (Long)aft.getAccountRef().getOldAndNewAccountRef().get(acctId);
                    if (!Objects.nonNull(newAcctId)) continue;
                    Set oldIds = aft.getOldAccountIds(newAcctId);
                    Iterator ite = oldIds.iterator();
                    while (ite.hasNext()) {
                        long id = (Long)ite.next();
                        acctRef.addAccountRef(newAcctId, Long.valueOf(id), aft.getNewDefaultAssgrp(Long.valueOf(id)).getAssgrpRef());
                    }
                    newIds.add(newAcctId);
                }
            }
            AccountTableRef acctTableRef = new AccountTableRef(aft.getOldAccountTableId(), aft.getNewAccountTableId(), acctRef);
            handler.handle(orgId, btId, period.getDate("begindate"), nPid, acctTableRef);
            this.updateBal4One(orgId, btId, aft.getNewAccountTableId(), nPid, newIds, false, handler);
        }
    }

    private Map<Long, Long> getMaster2Id(long orgId, Date date, long acctTableId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("startdate", "<=", (Object)date));
        filters.add(new QFilter("enddate", ">", (Object)date));
        HashMap<Long, Long> map = new HashMap<Long, Long>(10);
        try (DataSet dataSet = AccountUtils.queryAccountDataSet((long)orgId, (long)acctTableId, (String)"id,masterid", filters);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.getLong("masterid"), row.getLong("id"));
            }
        }
        return map;
    }

    private Map<Long, AccountTableRef> getAcctTableRecord(long orgId, long btId, long acctTableId, long periodId, boolean isMasterId) {
        QFilter forg = new QFilter("org", "=", (Object)orgId);
        QFilter fbt = new QFilter("booktype", "=", (Object)btId);
        QFilter faccttable = new QFilter("oldaccttab", "=", (Object)acctTableId);
        QFilter fep = new QFilter("enableperiod", ">=", (Object)periodId);
        DynamicObjectCollection verCol = QueryServiceHelper.query((String)"gl_book_version", (String)"org,oldaccttab,accounttable,enableperiod", (QFilter[])new QFilter[]{forg, fbt, faccttable, fep}, (String)"enableperiod");
        LinkedHashMap<Long, AccountTableRef> ref = new LinkedHashMap<Long, AccountTableRef>(3);
        for (DynamicObject obj : verCol) {
            AccountTableRef acctTableRef = null;
            acctTableRef = isMasterId ? AccountRefUtils.getMasterAccountTableRef((long)orgId, (long)acctTableId, (long)obj.getLong("accounttable")) : AccountRefUtils.getAccountTableRef((long)orgId, (long)acctTableId, (long)obj.getLong("accounttable"));
            ref.put(obj.getLong("enableperiod"), acctTableRef);
        }
        return ref;
    }

    @Override
    protected TransBalHandler getTransBalHandler() {
        return new TransBalHandler(){

            @Override
            public void handle(Long orgId, Long bookTypeId, Date date, Long periodId, AccountTableRef acctTblRef) {
                BalanceTransferUtils.transBalWithoutBalLock(orgId, bookTypeId, date, periodId, acctTblRef, BalTransferType.ACCOUNTBALANCE);
            }
        };
    }
}

