/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.balcal.CashflowKey;
import kd.fi.gl.bean.VchCfRowInfo;
import kd.fi.gl.comassist.ComassistMidTransterModel;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.CommonAssistUtil;

public class CashflowLogKey
extends CashflowKey {
    private long voucherId;
    private long orgId;
    private long bookTypeId;
    private long periodId;
    private long vchentryId;
    private long accountId;
    private String type = "";
    private String dc = "";
    private Date bookedDate;
    private int count = 0;

    public CashflowLogKey(Row row, long cfItemId) {
        this(row, cfItemId, 0L);
    }

    public CashflowLogKey(Row row, long cfItemId, long assgrpId) {
        super(cfItemId, row.getLong("localcur"), assgrpId, new ArrayList<Long>(2));
        this.voucherId = row.getLong("id");
        this.orgId = row.getLong("org");
        this.bookTypeId = row.getLong("booktype");
        this.periodId = row.getLong("period");
        this.accountId = row.getLong("account");
        this.vchentryId = row.getLong("entries.id");
    }

    public CashflowLogKey(Row row, long cfItemId, long assgrpId, ComassistMidTransterModel table) {
        super(cfItemId, row.getLong("localcur"), assgrpId, new ArrayList<Long>(2));
        this.voucherId = row.getLong("id");
        this.orgId = row.getLong("org");
        this.bookTypeId = row.getLong("booktype");
        this.periodId = row.getLong("period");
        this.accountId = row.getLong("account");
        this.vchentryId = row.getLong("entries.id");
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        for (int i = 1; i <= size; ++i) {
            this.comassist.add(table.convertMid(i, row.getLong(CommonAssistUtil.getComassistField(i))));
        }
    }

    public CashflowLogKey(Row row, long cfItemId, long assgrpId, ComassistMidTransterModel table, String type) {
        super(cfItemId, row.getLong("localcur"), assgrpId, new ArrayList<Long>(2));
        this.voucherId = row.getLong("id");
        this.orgId = row.getLong("org");
        this.bookTypeId = row.getLong("booktype");
        this.periodId = row.getLong("period");
        this.accountId = row.getLong("account");
        this.vchentryId = row.getLong("entries.id");
        this.bookedDate = row.getDate("bookeddate");
        this.type = type;
        this.dc = "0";
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        for (int i = 1; i <= size; ++i) {
            this.comassist.add(table.convertMid(i, row.getLong(CommonAssistUtil.getComassistField(i))));
        }
    }

    public CashflowLogKey(DynamicObject v, DynamicObject ve, long cfItemId, long assgrpId, ComassistMidTransterModel table) {
        super(cfItemId, v.getLong("book.basecurrency.id"), assgrpId, new ArrayList<Long>(2));
        this.voucherId = v.getLong("id");
        this.orgId = v.getLong("org.id");
        this.bookTypeId = v.getLong("booktype.id");
        this.periodId = v.getLong("period.id");
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        for (int i = 1; i <= size; ++i) {
            this.comassist.add(table.convertMid(i, ve.getLong(GLField.id_(CommonAssistUtil.getComassistField(i)))));
        }
    }

    public CashflowLogKey(VchCfRowInfo row, long cfItemId, long assgrpId, ComassistMidTransterModel table, String type) {
        super(cfItemId, row.getLocalcurId(), assgrpId, new ArrayList<Long>(2));
        this.voucherId = row.getVoucherId();
        this.orgId = row.getOrgId();
        this.bookTypeId = row.getBookTypeId();
        this.periodId = row.getPeriodId();
        this.accountId = row.getAccountId();
        this.vchentryId = row.getEntryId();
        this.bookedDate = row.getBookedDate();
        this.type = type;
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        List<Long> comassistIds = row.getComassistIds();
        for (int i = 1; i <= size; ++i) {
            this.comassist.add(table.convertMid(i, comassistIds.get(i - 1)));
        }
    }

    @Override
    public Long[] getKeyValues() {
        ArrayList<Long> value = new ArrayList<Long>(10);
        value.add(this.voucherId);
        value.add(this.orgId);
        value.add(this.bookTypeId);
        value.add(this.periodId);
        value.add(this.vchentryId);
        value.add(this.getCfItemId());
        value.add(this.getCurrencyId());
        value.add(this.getAssgrpId());
        value.addAll(this.comassist);
        return value.toArray(new Long[0]);
    }

    public Object[] getKeyValue() {
        ArrayList<Object> value = new ArrayList<Object>(12);
        value.add(this.voucherId);
        value.add(this.orgId);
        value.add(this.bookTypeId);
        value.add(this.periodId);
        value.add(this.vchentryId);
        value.add(this.getCfItemId());
        value.add(this.getCurrencyId());
        value.add(this.getAssgrpId());
        value.add(this.getAccountId());
        value.add(this.getType());
        value.add(this.getDc());
        value.add(this.getBookedDate());
        value.addAll(this.comassist);
        return value.toArray(new Object[0]);
    }

    public long getVoucherId() {
        return this.voucherId;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public String getType() {
        return this.type;
    }

    public String getDc() {
        return this.dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public long getVchentryId() {
        return this.vchentryId;
    }

    public Date getBookedDate() {
        return this.bookedDate;
    }

    public void setBookedDate(Date bookedDate) {
        this.bookedDate = bookedDate;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.bookTypeId ^ this.bookTypeId >>> 32);
        result = 31 * result + (int)(this.orgId ^ this.orgId >>> 32);
        result = 31 * result + (int)(this.periodId ^ this.periodId >>> 32);
        result = 31 * result + (int)(this.voucherId ^ this.voucherId >>> 32);
        result = 31 * result + (int)(this.vchentryId ^ this.vchentryId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CashflowLogKey other = (CashflowLogKey)obj;
        if (this.bookTypeId != other.bookTypeId) {
            return false;
        }
        if (this.orgId != other.orgId) {
            return false;
        }
        if (this.periodId != other.periodId) {
            return false;
        }
        if (this.voucherId != other.voucherId) {
            return false;
        }
        if (this.vchentryId != other.vchentryId) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (!this.dc.equals(other.dc)) {
            return false;
        }
        if (this.accountId != other.accountId) {
            return false;
        }
        return this.count == other.count;
    }

    @Override
    public String toString() {
        return "voucherId=" + this.voucherId + ", orgId=" + this.orgId + ", bookTypeId=" + this.bookTypeId + ", periodId=" + this.periodId + "," + super.toString();
    }
}

