/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal.carriedintoleaf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.balcal.carriedintoleaf.BalData;
import kd.fi.gl.balcal.carriedintoleaf.SaveBalanceHandler;

public class BalanceCarriedIntoLeafHelper {
    public List<Map<String, Object>> update(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> param : params) {
            List<BalData> balData = this.convertToBal(param);
            if (balData.size() == 0) {
                return resultList;
            }
            new SaveBalanceHandler().handle(balData);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(16);
            result.put("success", true);
            resultList.add(result);
        }
        return resultList;
    }

    private List<BalData> convertToBal(Map<String, Object> acct) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("org.id");
        selectFields.append(",").append("booktype.id");
        selectFields.append(",").append("accounttable.id");
        selectFields.append(",").append("period.id");
        selectFields.append(",").append("endperiod.id");
        selectFields.append(",").append("account.id");
        selectFields.append(",").append("currency");
        selectFields.append(",").append("assgrp");
        selectFields.append(",").append("measureunit");
        selectFields.append(",").append("beginfor");
        selectFields.append(",").append("beginlocal");
        selectFields.append(",").append("beginqty");
        selectFields.append(",").append("yeardebitfor");
        selectFields.append(",").append("yeardebitlocal");
        selectFields.append(",").append("yeardebitqty");
        selectFields.append(",").append("yearcreditfor");
        selectFields.append(",").append("yearcreditlocal");
        selectFields.append(",").append("yearcreditqty");
        selectFields.append(",").append("endfor");
        selectFields.append(",").append("endlocal");
        selectFields.append(",").append("endqty");
        QFilter orgFilter = new QFilter("org.id", "=", acct.get("orgid"));
        QFilter acctFilter = new QFilter("account.id", "=", acct.get("parentacctid"));
        QFilter[] qFilters = new QFilter[]{orgFilter, acctFilter};
        DataSet queryBalanceDataSet = QueryServiceHelper.queryDataSet((String)"insertBalData", (String)"gl_balance", (String)selectFields.toString(), (QFilter[])qFilters, (String)"endperiod desc");
        ArrayList<BalData> objs = new ArrayList<BalData>(10);
        for (Row row : queryBalanceDataSet) {
            BalData balData = new BalData();
            balData.setOrgId(row.getLong("org.id"));
            balData.setBookTypeId(row.getLong("booktype.id"));
            balData.setAcctTblId(row.getLong("accounttable.id"));
            balData.setPeriod(row.getLong("period.id"));
            balData.setEndPeriodId(row.getLong("endperiod.id"));
            balData.setAcctMasterId((Long)acct.get("acctid"));
            balData.setCurrency(row.getLong("currency"));
            balData.setAssgrp(row.getLong("assgrp"));
            balData.setMeasureUnitId(row.getLong("measureunit"));
            balData.setBeginFor(row.getBigDecimal("beginfor"));
            balData.setBeginLocal(row.getBigDecimal("beginlocal"));
            balData.setBeginQty(row.getBigDecimal("beginqty"));
            balData.setYearDebitFor(row.getBigDecimal("yeardebitfor"));
            balData.setYearDebitLocal(row.getBigDecimal("yeardebitlocal"));
            balData.setYearDebitQty(row.getBigDecimal("yeardebitqty"));
            balData.setYearCreditFor(row.getBigDecimal("yearcreditfor"));
            balData.setYearCreditLocal(row.getBigDecimal("yearcreditlocal"));
            balData.setYearCreditQty(row.getBigDecimal("yearcreditqty"));
            balData.setEndFor(row.getBigDecimal("endfor"));
            balData.setEndLocal(row.getBigDecimal("endlocal"));
            balData.setEndQty(row.getBigDecimal("endqty"));
            if (objs.contains(balData)) continue;
            objs.add(balData);
        }
        return objs;
    }
}

