/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal.repair;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.balcal.BalanceCalculator;
import kd.fi.gl.balcal.repair.IBalanceRepairable;
import org.apache.commons.lang3.StringUtils;

public class BalanceRepairService
extends BalanceCalculator
implements IBalanceRepairable {
    private static final Log LOG = LogFactory.getLog(BalanceRepairService.class);
    private static final String BILL_SQL = "SELECT ve.fid,v.fperiodid,av.faccounttableid,av.fmasterid faccountid,ve.fassgrpid,ve.fmeasureunitid,ve.fcurrencyid,%1$s ve.FORIGINALDEBIT fdebitfor,ve.FORIGINALCREDIT fcreditfor,ve.FLOCALDEBIT fdebitlocal,ve.FLOCALCREDIT fcreditlocal, case when fentrydc = '1' then fquantity else 0 end fdebitqty,case when fentrydc = '-1' then fquantity else 0 end fcreditqty,1 fcount FROM t_gl_voucher v left outer join t_gl_voucherentry ve ON v.fid = ve.fid left outer join t_bd_account av ON av.fid = ve.faccountid WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid = ? AND ve.fassgrpid in {assistid} AND v.fbillstatus in ('B','C') order by v.fperiodid ASC";
    private static final String PERIODS_SQL = "SELECT distinct(v.fperiodid) fperiodid FROM t_gl_voucher v inner join t_gl_voucherentry ve ON v.fid = ve.fid WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid >= ? AND v.fperiodid <= ? AND ve.fassgrpid in {assistid} AND v.fbillstatus in ('B','C') order by v.fperiodid asc ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reCalculateByAssist(long orgId, long bookTypeId, Set<Long> assistIds, long startPeriodId, long endPeriodId) {
        if (CollectionUtils.isEmpty(assistIds)) {
            throw new KDBizException("param assistIds is empty. ");
        }
        LOG.info("reCalculateByAssist on balance: org: {}, booktypeid: {}, startperiod: {}, endperiod: {}, assistid: {}", new Object[]{orgId, bookTypeId, startPeriodId, endPeriodId, assistIds});
        ThreadCache.put((Object)"balance_calculator_standalone_transaction", (Object)Boolean.FALSE.toString());
        try {
            this.initComassist(orgId, bookTypeId);
            for (long curPeriod : this.queryDistinctPeriods(orgId, bookTypeId, assistIds, startPeriodId, endPeriodId)) {
                String sql = String.format(BILL_SQL, this.getComassistField()).replace("{assistid}", "(" + StringUtils.join(assistIds, (String)",") + ")");
                Object[] params = new Object[]{orgId, bookTypeId, curPeriod};
                DataSet dataSet = DB.queryDataSet((String)"queryVoucherOnBalanceRepair", (DBRoute)gl, (String)sql, (Object[])params);
                dataSet = this.transferMid(dataSet);
                this.updateBalance(orgId, bookTypeId, dataSet, true, curPeriod);
            }
        }
        finally {
            ThreadCache.remove((Object)"balance_calculator_standalone_transaction");
        }
    }

    private List<Long> queryDistinctPeriods(long orgId, long bookTypeId, Set<Long> assistIds, long startPeriodId, long endPeriodId) {
        String sql = PERIODS_SQL.replace("{assistid}", "(" + StringUtils.join(assistIds, (String)",") + ")");
        Object[] params = new Object[]{orgId, bookTypeId, startPeriodId, endPeriodId};
        DataSet dataSet = DB.queryDataSet((String)"queryVoucherOnBalanceRepair", (DBRoute)gl, (String)sql, (Object[])params);
        ArrayList<Long> periodIds = new ArrayList<Long>(8);
        while (dataSet.hasNext()) {
            periodIds.add(dataSet.next().getLong("fperiodid"));
        }
        return periodIds;
    }
}

