/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.dao.closeperiod;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.business.vo.closeperiod.ClosePeriodBookVO;

public class ClosePeriodDAO {
    public static Map<String, ClosePeriodBookVO> queryClosePeriodBooks(List<String> orgNumbers, String bookTypeNumber, Long periodTypeId) {
        ArrayList result = new ArrayList(orgNumbers.size());
        List distinct = orgNumbers.stream().distinct().collect(Collectors.toList());
        int splitSize = HugeInConfig.inThreshold() > 0 ? HugeInConfig.inThreshold() : 1000;
        Lists.partition(distinct, (int)splitSize).stream().map(x -> ClosePeriodDAO.doQueryClosePeriodBooks(x, bookTypeNumber, periodTypeId)).forEach(result::addAll);
        return result.stream().collect(Collectors.toMap(ClosePeriodBookVO::getOrgNumber, x -> x, (o, n) -> n));
    }

    private static List<ClosePeriodBookVO> doQueryClosePeriodBooks(List<String> orgNumbers, String bookTypeNumber, Long periodTypeId) {
        QFilter filter = new QFilter("org.number", "in", orgNumbers).and("bookstype.number", "=", (Object)bookTypeNumber).and("periodtype", "=", (Object)periodTypeId).and("isbizunit", "=", (Object)true).and("isendinit", "=", (Object)true);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"org.id,org.numher,bookstype.id", (QFilter[])filter.toArray());
        return loadFromCache.values().stream().map(x -> {
            ClosePeriodBookVO closePeriodBookVO = new ClosePeriodBookVO();
            closePeriodBookVO.setOrgId(x.getLong("org.id"));
            closePeriodBookVO.setOrgNumber(x.getString("org.number"));
            closePeriodBookVO.setBookTypeId(x.getLong("bookstype.id"));
            return closePeriodBookVO;
        }).collect(Collectors.toList());
    }
}

