/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.dao.voucher;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.fi.gl.business.dao.voucher.IEntryReader;
import kd.fi.gl.business.dao.voucher.ReadException;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;

public class BufferedEntryReader<E extends IVoucherEntry>
implements IEntryReader<E> {
    private final IEntryReader<E> reader;
    private Iterator<List<Long>> entryIdsIter;
    private Iterator<E> buffer;
    private final Object lock = new Object();

    public BufferedEntryReader(IEntryReader<E> reader, List<Long> allEntryIds, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Size need larger than 0");
        }
        this.reader = reader;
        this.entryIdsIter = Lists.partition(allEntryIds, (int)bufferSize).iterator();
    }

    @Override
    public E read(Long entryId) throws ReadException {
        return this.assertResult(entryId, this.read());
    }

    @Override
    public List<E> read(List<Long> entryIds) throws ReadException {
        return this.assertResult(entryIds, this.read(entryIds.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E read() throws ReadException {
        Object object = this.lock;
        synchronized (object) {
            if (!(this.buffer != null && this.buffer.hasNext() || (this.buffer = this.resetBuffer()).hasNext())) {
                return null;
            }
            return (E)((IVoucherEntry)this.buffer.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<E> read(int size) throws ReadException {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<E> result;
            if (size <= 0) {
                result = new ArrayList<E>(1);
            } else {
                E read;
                result = new ArrayList(size);
                for (int i = 0; i < size && (read = this.read()) != null; ++i) {
                    result.add(read);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<E> resetBuffer() throws ReadException {
        Object object = this.lock;
        synchronized (object) {
            List entries;
            if (this.entryIdsIter != null && this.entryIdsIter.hasNext()) {
                List<Long> next = this.entryIdsIter.next();
                entries = this.reader.read(next);
            } else {
                entries = new ArrayList(1);
            }
            this.buffer = entries.iterator();
            return this.buffer;
        }
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        finally {
            this.entryIdsIter = null;
            this.buffer = null;
        }
    }
}

