/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.dao.voucher;

import java.util.ArrayList;
import java.util.List;
import kd.fi.gl.business.dao.voucher.IEntryWriter;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;

public class BufferedEntryWriter<E extends IVoucherEntry>
implements IEntryWriter<E> {
    private final IEntryWriter<E> writer;
    private final int bufferSize;
    private final List<E> buffer;
    private final Object lock = new Object();

    public BufferedEntryWriter(IEntryWriter<E> writer, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Size need larger than 0");
        }
        this.writer = writer;
        this.bufferSize = bufferSize;
        this.buffer = new ArrayList(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(List<E> entries) {
        Object object = this.lock;
        synchronized (object) {
            for (IVoucherEntry entry : entries) {
                this.buffer.add(entry);
                if (this.buffer.size() < this.bufferSize) continue;
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(E entry) {
        Object object = this.lock;
        synchronized (object) {
            this.buffer.add(entry);
            if (this.buffer.size() >= this.bufferSize) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.buffer.isEmpty()) {
                    this.writer.write(this.buffer);
                }
            }
            finally {
                this.buffer.clear();
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.flush();
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

