/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.cf;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.util.StringUtils;
import kd.fi.gl.assistitem.IAccountingItemValueMapper;
import kd.fi.gl.business.service.cf.CashFlowFlexValueMapper;
import kd.fi.gl.interfaces.service.cf.ICashFlowFlexService;
import kd.fi.gl.util.SystemParamHelper;

public class CashFlowFlexServiceImpl
implements ICashFlowFlexService {
    @Override
    public boolean isGetFromAccountFlexValueEnable(long orgId) {
        return !this.getSystemParamSettings(orgId).isEmpty();
    }

    @Override
    public List<IAccountingItemValueMapper> getMappers(long orgId) {
        List<String> settings = this.getSystemParamSettings(orgId);
        return settings.stream().map(CashFlowFlexValueMapper::get).filter(Optional::isPresent).map(x -> ((CashFlowFlexValueMapper)((Object)((Object)x.get()))).getMapper()).sorted(Comparator.comparing(IAccountingItemValueMapper::priority)).collect(Collectors.toList());
    }

    protected List<String> getSystemParamSettings(long orgId) {
        return (List)ThreadCache.get((Object)("CashFlowFlexServiceImpl_getSystemParamSetting_" + orgId), () -> {
            Object paramVal = SystemParamHelper.getObjectParam("cfflexbyacct", orgId);
            if (paramVal == null) {
                return Collections.emptyList();
            }
            String paramValStr = paramVal.toString();
            if (StringUtils.isBlank((String)paramValStr)) {
                return Collections.emptyList();
            }
            return Arrays.stream(paramValStr.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        });
    }
}

