/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.closeperiod.job.impl.mq;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.operation.closeperiod.result.ClosePeriodResultServiceHelper;
import kd.fi.gl.business.service.closeperiod.job.impl.mq.MQClosePeriodSubJobState;

public class MQClosePeriodJobHelper {
    private static final DistributeSessionlessCache ROOT_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CacheKeyUtil.getAcctId() + ".gl_appcache_periodClose_");

    public static void updateSubJobStates(String jobId, List<MQClosePeriodSubJobState> states) {
        Map<String, String> stateMap = states.stream().collect(Collectors.toMap(MQClosePeriodSubJobState::getSubJobId, SerializationUtils::toJsonString, (o, n) -> n));
        ROOT_CACHE.put(jobId + "_states", stateMap);
    }

    public static List<MQClosePeriodSubJobState> getSubJobStates(String jobId) {
        Map all = ROOT_CACHE.getAll(jobId + "_states");
        return all.values().stream().map(x -> (MQClosePeriodSubJobState)SerializationUtils.fromJsonString((String)x, MQClosePeriodSubJobState.class)).collect(Collectors.toList());
    }

    public static List<CloseCheckItemResult> getSubJobItemResults(String jobId, String subJobId) {
        return ClosePeriodResultServiceHelper.getResults((String)MQClosePeriodJobHelper.getSubJobItemResultsKey(jobId, subJobId));
    }

    public static void recordSubJobItemResult(String jobId, String subJobId, CloseCheckItemResult itemResult) {
        ClosePeriodResultServiceHelper.recordItemResult((String)MQClosePeriodJobHelper.getSubJobItemResultsKey(jobId, subJobId), Collections.singletonList(itemResult));
    }

    public static String getSubJobItemResultsKey(String jobId, String subJobId) {
        return "CLOSE_PERIOD." + jobId + "_" + subJobId;
    }

    public static void clearSubJobStates(String jobId) {
        ROOT_CACHE.remove(jobId + "_states");
    }
}

