/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.closeperiod.job.impl.mq;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodJobInfo;
import kd.fi.gl.business.service.closeperiod.job.ClosePeriodSubJobInfo;
import kd.fi.gl.business.service.closeperiod.job.IClosePeriodJobService;
import kd.fi.gl.business.service.closeperiod.job.impl.mq.MQClosePeriodJob;
import kd.fi.gl.business.service.closeperiod.job.impl.mq.MQClosePeriodJobHelper;
import kd.fi.gl.business.service.closeperiod.job.impl.mq.MQClosePeriodSubJobState;
import kd.fi.gl.constant.closeperiod.ClosePeriodInfo;
import kd.fi.gl.enums.ClosePeriodStateEnum;
import kd.fi.gl.enums.GLBillParamEnum;

public class MQClosePeriodJobService
implements IClosePeriodJobService<MQClosePeriodJob> {
    private static final MQClosePeriodJobService INSTANCE = new MQClosePeriodJobService();

    public static MQClosePeriodJobService getInstance() {
        return INSTANCE;
    }

    private MQClosePeriodJobService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asyncCommit(MQClosePeriodJob job) {
        List<MQClosePeriodSubJobState> initStates = job.getCloseOrgIds().stream().map(x -> MQClosePeriodSubJobState.empty(String.valueOf(x))).collect(Collectors.toList());
        MQClosePeriodJobHelper.updateSubJobStates(job.getJobId(), initStates);
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("fi", "fi.gl.closeperiod_queue");){
            ClosePeriodInfo closePeriodInfo = this.buildMQParams(job);
            List partition = Lists.partition(job.getCloseOrgIds(), (int)GLBillParamEnum.CLOSE_PERIOD_MQ_CONSUME_ORG_SIZE.getIntegerValue());
            for (List orgIds : partition) {
                ClosePeriodInfo copy = closePeriodInfo.copy();
                copy.setOrgs(orgIds);
                publisher.publish(SerializationUtils.toJsonString((Object)copy));
            }
        }
        return job.getJobId();
    }

    private ClosePeriodInfo buildMQParams(MQClosePeriodJob job) {
        ClosePeriodInfo closeInfo = new ClosePeriodInfo();
        closeInfo.setPageId(job.getJobId());
        closeInfo.setBizapp(job.getAppNumber());
        closeInfo.setBooktype(job.getBookTypeId());
        closeInfo.setAwaitPeriodId(job.getAwaitPeriodId());
        closeInfo.setRequestContextStr(SerializationUtils.serializeToBase64((Object)RequestContext.get()));
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)job.getAppNumber());
        closeInfo.setFormId(bookRegisterInfo.getCloseEntityOfCloseOp());
        closeInfo.setOrgFieldName(bookRegisterInfo.getOrgFieldOnCloseEntity());
        closeInfo.setTypeFieldName(bookRegisterInfo.getBookTypeFieldOnCloseEntity());
        return closeInfo;
    }

    @Override
    public ClosePeriodJobInfo getJobInfo(String jobId) {
        ClosePeriodJobInfo closePeriodJobInfo = new ClosePeriodJobInfo(jobId);
        List<MQClosePeriodSubJobState> subJobStates = MQClosePeriodJobHelper.getSubJobStates(jobId);
        ArrayList<ClosePeriodSubJobInfo> subJobInfos = new ArrayList<ClosePeriodSubJobInfo>(subJobStates.size());
        for (MQClosePeriodSubJobState subJobState : subJobStates) {
            String orgId = subJobState.getSubJobId();
            ClosePeriodSubJobInfo subJobInfo = new ClosePeriodSubJobInfo();
            subJobInfo.setSubJobId(orgId);
            subJobInfo.setState(subJobState.getState());
            subJobInfo.setCustomInfos(Collections.singletonMap("openedPeriodId", subJobState.getOpenedPeriodId()));
            if (ClosePeriodStateEnum.UNFINISHED.getCode().equals(subJobState.getState())) {
                closePeriodJobInfo.setFinish(false);
            } else {
                subJobInfo.setItemResults(MQClosePeriodJobHelper.getSubJobItemResults(jobId, orgId));
            }
            subJobInfos.add(subJobInfo);
        }
        closePeriodJobInfo.setSubJobInfos(subJobInfos);
        return closePeriodJobInfo;
    }

    @Override
    public void clearJobInfo(String jobId) {
        MQClosePeriodJobHelper.clearSubJobStates(jobId);
    }
}

