/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.baldeduct.result;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.fi.gl.business.service.reciprocal.baldeduct.result.AgingResult;
import kd.fi.gl.business.vo.reciprocal.AccountFlexVO;
import kd.fi.gl.enums.writeoff.WriteOffField;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalRecord;

public class AgingDetailResult
extends AgingResult {
    public AgingDetailResult(List<AccountFlexVO> accountFlexVOS) {
        super(accountFlexVOS);
        this.initialize();
    }

    public AgingDetailResult(List<AccountFlexVO> accountFlexVOS, boolean showByExpireDate, Date expiredate, boolean isSynCurrency) {
        super(accountFlexVOS, showByExpireDate, expiredate, isSynCurrency);
        this.initialize();
    }

    @Override
    protected RowMeta buildRowMeta() {
        ArrayList<Field> writeOffFields = new ArrayList<Field>(18 + this.acctFlexVOs.size());
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ID));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ORG));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.BOOKTYPE));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ACCOUNT));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ASSGRP));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ASSGRPVALUE));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYID));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYFOR));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYLOCAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.AMOUNTBAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.AMOUNTBALFOR));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.BIZDATE));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.EXPIREDATE));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.VOUCHERID));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.DESCRIPTION));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.BIZNUM));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.FORWRITEOFFDATE));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.LOCALWRITEOFFDATE));
        for (AccountFlexVO accountFlexVO : this.acctFlexVOs) {
            writeOffFields.add(RcpWriteOffUtils.buildField(accountFlexVO.getFlexField(), WriteOffField.ASSGRPITEM.getType()));
        }
        return new RowMeta(writeOffFields.toArray(new Field[0]));
    }

    @Override
    public void add(ReciprocalRecord record) {
        ArrayList<Object> values = new ArrayList<Object>(this.rowMeta.getFieldCount());
        values.add(record.getId());
        values.add(record.getOrg());
        values.add(record.getBookType());
        values.add(record.getAccount());
        values.add(record.getAssgrp());
        values.add(record.getAssgrpValStr());
        if (this.isSynCurrency) {
            values.add(record.getLocalCurrency());
        } else {
            values.add(record.getCurrency());
        }
        values.add(record.getCurrency());
        values.add(record.getLocalCurrency());
        values.add(record.getLeavingAmount());
        values.add(record.getLeavingAmountFor());
        values.add(record.getBizDate());
        values.add(record.getExpireDate());
        values.add(record.getVoucherId());
        values.add(record.getDescription());
        values.add(record.getBizNum());
        values.add(record.getForWriteOffDate());
        values.add(record.getLocalWriteOffDate());
        for (AccountFlexVO accountFlexVO : this.acctFlexVOs) {
            Long assgrpValue = record.getAssgrpVals().get(accountFlexVO.getFlexField()) == null ? Long.valueOf(0L) : record.getAssgrpVals().get(accountFlexVO.getFlexField());
            Set<Long> assValue = accountFlexVO.getValues();
            if (assValue != null && assValue.size() > 0 && !assValue.contains(Long.parseLong(String.valueOf(assgrpValue)))) {
                return;
            }
            values.add(record.getAssgrpVals().get(accountFlexVO.getFlexField()));
        }
        this.dsBuilder.append(values.toArray());
    }

    @Override
    public DataSet getAgingResult() {
        return this.dsBuilder.build();
    }
}

