/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.realtime;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.business.dao.balance.BalanceLogDAO;
import kd.fi.gl.business.dao.recip.AcccurrentDAO;
import kd.fi.gl.business.dao.recip.UnAcccurrentDAO;
import kd.fi.gl.business.service.GLServiceFactory;
import kd.fi.gl.business.service.reciprocal.baldeduct.FiFoSimulateParam;
import kd.fi.gl.business.service.reciprocal.realtime.BaseKey;
import kd.fi.gl.business.service.reciprocal.realtime.GroupKey;
import kd.fi.gl.business.service.reciprocal.realtime.OriginPoint;
import kd.fi.gl.business.service.reciprocal.realtime.RealTimeWriteOffContext;
import kd.fi.gl.business.service.reciprocal.realtime.UnAcccurrentHandle;
import kd.fi.gl.constant.AccCurrent;
import kd.fi.gl.constant.reciprocal.UnAcccurrent;
import kd.fi.gl.interfaces.service.reciprocal.IFifoRealTimeWriteOffService;
import kd.fi.gl.interfaces.service.reciprocal.IFifoSimulateService;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang3.tuple.Pair;

public class FifoRealTimeWriteOffServiceImpl
implements IFifoRealTimeWriteOffService {
    private static final Log LOGGER = LogFactory.getLog(FifoRealTimeWriteOffServiceImpl.class);
    private IFifoSimulateService simulateService = GLServiceFactory.getService(IFifoSimulateService.class);

    @Override
    public void calculateBalanceLog(Long orgId, Long bookTypeId) {
        RealTimeWriteOffContext ctx = new RealTimeWriteOffContext(orgId, bookTypeId);
        this.balLogOriPointBatchHandle(ctx);
    }

    @Override
    public void calculateUnAcccurrentStatus(Long orgId, Long bookTypeId, Long acctTableId, Long acctMasterId, Long currencyId, Set<Long> assgrpIds) {
        RealTimeWriteOffContext ctx = new RealTimeWriteOffContext(orgId, bookTypeId);
        ctx.setAcctTableId(acctTableId);
        ctx.getAcctMasterIds().add(acctMasterId);
        if (Objects.nonNull(currencyId) && currencyId > 0L) {
            ctx.getCurrencyIds().add(currencyId);
        }
        if (Objects.nonNull(assgrpIds)) {
            ctx.getAssgrpIds().addAll(assgrpIds);
        }
        this.realTimeWriteOff(ctx);
        BalanceLogDAO.updateAcccalculated(ctx.getOrgId(), ctx.getBookTypeId(), ctx.getAcctTableId(), ctx.getAcctMasterIds());
    }

    protected void balLogOriPointBatchHandle(RealTimeWriteOffContext cxt) {
        String selectFields = "id,org,booktype,accounttable,account,currency,accassgrp,bizdate,debitfor,debitlocal,creditfor,creditlocal,voucherid";
        QFilter filter = new QFilter("org", "=", (Object)cxt.getOrgId());
        filter.and(new QFilter("booktype", "=", (Object)cxt.getBookTypeId()));
        filter.and(new QFilter("accassgrp", ">", (Object)0));
        filter.and(new QFilter("acccalculated", "=", (Object)"0"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FifoRealTimeWriteOffServiceImpl.class.getName(), (String)"gl_balance_log", (String)selectFields, (QFilter[])filter.toArray(), (String)"account asc, currency asc, accassgrp asc");){
            HashSet<String> handleKey = new HashSet<String>(32);
            String preRowKey = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long account = row.getLong("account");
                Long currency = row.getLong("currency");
                Long accassgrp = row.getLong("accassgrp");
                String currentRowKey = account + "-" + currency + "-" + accassgrp;
                if (handleKey.size() > 2000 && !Objects.equals(preRowKey, currentRowKey)) {
                    this.batchRealTimeWriteOff(cxt);
                    cxt = new RealTimeWriteOffContext(cxt.getOrgId(), cxt.getBookTypeId());
                    handleKey.clear();
                }
                cxt.addAcctToBalLogIds((Pair<Long, Long>)Pair.of((Object)account, (Object)accassgrp), row.getLong("voucherid"), row.getLong("id"));
                if (cxt.getAcctTableId() == 0L) {
                    cxt.setAcctTableId(row.getLong("accounttable"));
                }
                cxt.getAcctMasterIds().add(account);
                cxt.getCurrencyIds().add(currency);
                cxt.getAssgrpIds().add(accassgrp);
                Date bizdate = row.getDate("bizdate");
                if (Objects.nonNull(accassgrp) && accassgrp > 0L) {
                    BaseKey baseKey = BaseKey.of(account, currency);
                    String lastAmtDc = this.getBalAmtDc(row, "debitfor", "creditfor");
                    OriginPoint originPointFor = cxt.getBalLogOriPoint().computeIfAbsent(baseKey, x -> new HashMap(16)).computeIfAbsent(GroupKey.of(accassgrp, GroupKey.CurrencyType.FOR), y -> OriginPoint.of(bizdate, lastAmtDc));
                    if (!originPointFor.getBalDc().equals(lastAmtDc)) {
                        originPointFor.setLastWriteOffDate(bizdate);
                        originPointFor.setBalDc("0");
                    } else if (originPointFor.getLastWriteOffDate().compareTo(bizdate) > 0) {
                        originPointFor.setLastWriteOffDate(bizdate);
                    }
                    String lastAmtLocalDc = this.getBalAmtDc(row, "debitlocal", "creditlocal");
                    OriginPoint originPointLocal = cxt.getBalLogOriPoint().computeIfAbsent(baseKey, x -> new HashMap(16)).computeIfAbsent(GroupKey.of(accassgrp, GroupKey.CurrencyType.LOCAL), y -> OriginPoint.of(bizdate, lastAmtLocalDc));
                    if (!originPointLocal.getBalDc().equals(lastAmtLocalDc)) {
                        originPointLocal.setLastWriteOffDate(bizdate);
                        originPointLocal.setBalDc("0");
                    } else if (originPointLocal.getLastWriteOffDate().compareTo(bizdate) > 0) {
                        originPointLocal.setLastWriteOffDate(bizdate);
                    }
                }
                preRowKey = currentRowKey;
                handleKey.add(preRowKey);
            }
            if (handleKey.size() > 0) {
                this.batchRealTimeWriteOff(cxt);
                handleKey.clear();
            }
        }
    }

    protected void batchRealTimeWriteOff(RealTimeWriteOffContext ctx) {
        Map<BaseKey, Set<Long>> noNeedCalAssgrp;
        if (ctx.getAcctToBalLogIds().size() == 0) {
            return;
        }
        this.setCtxUnAccOriPoint(ctx);
        Map<BaseKey, Set<Long>> needCalAssgrp = ctx.getNeedCalAssgrp();
        if (needCalAssgrp.size() > 0) {
            if (DebugTrace.enable()) {
                LOGGER.info("FifoRealWriteOffService#simulateWriteOff: needCalAssgrp:{}", needCalAssgrp);
            }
            this.realTimeWriteOff(ctx);
        }
        if ((noNeedCalAssgrp = ctx.getNoNeedCalAssgrp()).size() > 0) {
            if (DebugTrace.enable()) {
                LOGGER.info("FifoRealWriteOffService#simulateWriteOff: noNeedCalAssgrp:{}", noNeedCalAssgrp);
            }
            this.saveObjectData(ctx, noNeedCalAssgrp);
        }
    }

    protected void saveObjectData(RealTimeWriteOffContext cxt, Map<BaseKey, Set<Long>> noNeedCalAssgrp) {
        int size = noNeedCalAssgrp.size();
        HashSet<Long> vchIds = new HashSet<Long>(size);
        HashSet<Long> assgrpIds = new HashSet<Long>(size);
        ArrayList balLogIds = new ArrayList(size);
        cxt.getAcctToBalLogIds().forEach((pair, vchToBalLogIds) -> noNeedCalAssgrp.forEach((baseKey, assgrpId) -> {
            if (Objects.equals(baseKey.getAcctId(), pair.getLeft()) && assgrpId.contains(pair.getRight())) {
                assgrpIds.addAll((Collection<Long>)assgrpId);
                for (Map.Entry entry : vchToBalLogIds.entrySet()) {
                    vchIds.add((Long)entry.getKey());
                    balLogIds.addAll((Collection)entry.getValue());
                }
            }
        }));
        try (TXHandle h = TX.requiresNew((String)(FifoRealTimeWriteOffServiceImpl.class.getName() + "saveObjectData"));){
            try {
                QFilter filter = new QFilter("voucherid", "in", vchIds);
                filter.and(new QFilter("assgrp", "in", assgrpIds));
                DeleteServiceHelper.delete((String)UnAcccurrent.ENTITY, (QFilter[])filter.toArray());
                this.newUnAcccurrent(cxt.getOrgId(), cxt.getBookTypeId(), vchIds, assgrpIds);
                cxt.getAcctToBalLogIds().forEach((pair, vchToBalLogIds) -> noNeedCalAssgrp.forEach((k, v) -> {
                    if (Objects.equals(k.getAcctId(), pair.getLeft()) && v.contains(pair.getRight())) {
                        balLogIds.addAll(vchToBalLogIds.entrySet().stream().flatMap(x -> ((List)x.getValue()).stream()).collect(Collectors.toSet()));
                    }
                }));
                BalanceLogDAO.updateAcccalculated(balLogIds.toArray(new Long[0]));
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    protected void newUnAcccurrent(Long orgId, Long bookTypeId, Set<Long> vchIds, Set<Long> assgrpIds) {
        QFilter accFilter = new QFilter("org", "=", (Object)orgId);
        accFilter.and(new QFilter("booktype", "=", (Object)bookTypeId));
        accFilter.and(new QFilter("voucherid", "in", vchIds));
        accFilter.and(new QFilter("assgrp", "in", assgrpIds));
        ArrayList<ReciprocalRecord> records = new ArrayList<ReciprocalRecord>(128);
        long[] longIds = DB.genLongIds((String)UnAcccurrent.Table, (int)999);
        int i = 0;
        String selFields = "id, org, booktype, account,assgrp.id assgrpid,assgrp.value assval, sourcetype, currency, localcurrency, amountfor, amount , amountbalfor, amountbal, voucherid, voucherentry, description, biznum, entrydc,bizdate,expiredate, bookeddate, status,accounttable,masterid,period";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FifoRealTimeWriteOffServiceImpl.class.getName(), (String)AccCurrent.ENTITY, (String)selFields, (QFilter[])accFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                boolean isLastRow;
                Row row = dataSet.next();
                ReciprocalRecord acccurrent = AcccurrentDAO.createAcccurrent(row);
                acccurrent.setId(longIds[i++]);
                acccurrent.setLeavingAmount(row.getBigDecimal("amount"));
                acccurrent.setLeavingAmountFor(row.getBigDecimal("amountfor"));
                records.add(acccurrent);
                boolean bl = isLastRow = !dataSet.hasNext();
                if (records.size() <= 999 && !isLastRow) continue;
                List<DynamicObject> unAcccurrent = UnAcccurrentDAO.createUnAcccurrent(records);
                SaveServiceHelper.save((DynamicObject[])unAcccurrent.toArray(new DynamicObject[0]));
                records.clear();
                if (isLastRow) continue;
                longIds = DB.genLongIds((String)UnAcccurrent.Table, (int)999);
                i = 0;
            }
        }
    }

    public void realTimeWriteOff(RealTimeWriteOffContext ctx) {
        Map acctMaps = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"id, dc, checkitementry.asstactitem, checkitementry.enaccheck", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ctx.getAcctMasterIds().toArray(new Long[0]))});
        Map<Long, Date> acctToEndDate = this.queryAcctLastPeriod(ctx);
        for (Long acctId : ctx.getAcctMasterIds()) {
            DynamicObject acctDyn;
            if (Objects.isNull(acctMaps) || Objects.isNull(acctDyn = (DynamicObject)acctMaps.get(acctId))) continue;
            int acctDc = "1".equals(acctDyn.getString("dc")) ? 1 : -1;
            Date bookedDate = new Date();
            if (!acctToEndDate.isEmpty() && null == (bookedDate = acctToEndDate.get(acctId))) {
                DebugTrace.action(() -> LOGGER.info("FifoRealTimeWriteOffServiceImpl#realTimeWriteOff acctId:{}", (Object)acctId));
                continue;
            }
            FiFoSimulateParam fifoParam = new FiFoSimulateParam().setOrgId(ctx.getOrgId()).setBookTypeId(ctx.getBookTypeId()).setAcctTableId(ctx.getAcctTableId()).setAccountId(acctId).setCurrencyIds(ctx.getCurrencyIds()).setAcctDc(acctDc).setBookedDate(bookedDate);
            HashMap<Long, Set> needCalAssgrp = new HashMap<Long, Set>(8);
            for (Long currencyId : ctx.getCurrencyIds()) {
                needCalAssgrp.computeIfAbsent(currencyId, x -> new HashSet(8)).addAll(ctx.getAssgrpIds());
            }
            ctx.getNeedCalAssgrp().forEach((k, v) -> {
                if (k.getAcctId().equals(acctId)) {
                    needCalAssgrp.computeIfAbsent(k.getCurrencyId(), x -> new HashSet(10)).addAll(v);
                }
            });
            Set<Long> assgrpIds = needCalAssgrp.entrySet().stream().flatMap(x -> ((Set)x.getValue()).stream()).collect(Collectors.toSet());
            ArrayList<Long> balLogIds = new ArrayList<Long>(32);
            for (Map.Entry<Pair<Long, Long>, Map<Long, List<Long>>> entry : ctx.getAcctToBalLogIds().entrySet()) {
                if (!Objects.equals(acctId, entry.getKey().getLeft()) || !assgrpIds.contains(entry.getKey().getRight())) continue;
                balLogIds.addAll(entry.getValue().entrySet().stream().flatMap(x -> ((List)x.getValue()).stream()).collect(Collectors.toSet()));
            }
            Set<Long> assgrpIdSet = needCalAssgrp.entrySet().stream().flatMap(x -> ((Set)x.getValue()).stream()).collect(Collectors.toSet());
            DebugTrace.action(() -> LOGGER.info("FifoRealTimeWriteOffServiceImpl.realTimeWriteOff_fifoParam:{} assgrpIdSet:{}", (Object)fifoParam, (Object)assgrpIdSet));
            DataSet dataSet = this.simulateService.executeSimulateDetailResult(fifoParam, assgrpIdSet);
            Throwable throwable = null;
            try {
                DataSet newUnAccDs = dataSet.orderBy(new String[]{"id asc"});
                Throwable throwable2 = null;
                try {
                    DataSet oldUnAccDs = this.queryUnAcccurrent(fifoParam, assgrpIds);
                    Throwable throwable3 = null;
                    try {
                        UnAcccurrentHandle unAccHandle = new UnAcccurrentHandle();
                        unAccHandle.handle(newUnAccDs, oldUnAccDs, balLogIds);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (oldUnAccDs == null) continue;
                        if (throwable3 != null) {
                            try {
                                oldUnAccDs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        oldUnAccDs.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (newUnAccDs == null) continue;
                    if (throwable2 != null) {
                        try {
                            newUnAccDs.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    newUnAccDs.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
    }

    protected DataSet queryUnAcccurrent(FiFoSimulateParam fifoParam, Set<Long> assgrpIds) {
        QFilter filter = new QFilter("org", "=", (Object)fifoParam.getOrgId());
        filter.and(new QFilter("booktype", "=", (Object)fifoParam.getBookTypeId()));
        filter.and(new QFilter("accounttable", "=", (Object)fifoParam.getAcctTableId()));
        filter.and(new QFilter("account", "=", (Object)fifoParam.getAccountId()));
        if (assgrpIds.size() > 0) {
            filter.and(new QFilter("assgrp", "in", assgrpIds));
        }
        return QueryServiceHelper.queryDataSet((String)FifoRealTimeWriteOffServiceImpl.class.getName(), (String)UnAcccurrent.ENTITY, (String)"id, recordid, masterid, account accountid, currency currencyid, assgrp, amountbalfor, amountbal, forwriteoffdate, localwriteoffdate, isoriginpoint", (QFilter[])filter.toArray(), (String)"recordid asc");
    }

    protected Map<Long, Date> queryAcctLastPeriod(RealTimeWriteOffContext ctx) {
        QFilter filter = new QFilter("org", "=", (Object)ctx.getOrgId());
        filter.and(new QFilter("booktype", "=", (Object)ctx.getBookTypeId()));
        filter.and(new QFilter("account", "in", ctx.getAcctMasterIds()));
        filter.and(new QFilter("endperiod", "=", (Object)GLUtil.MAX_PERIOD));
        HashMap<Long, Date> acctToEndDate = new HashMap<Long, Date>(ctx.getAcctMasterIds().size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FifoRealTimeWriteOffServiceImpl.class.getName(), (String)"gl_acctbalance", (String)"account,period.enddate", (QFilter[])filter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                acctToEndDate.put(row.getLong("account"), row.getDate("period.enddate"));
            }
        }
        return acctToEndDate;
    }

    protected void setCtxUnAccOriPoint(RealTimeWriteOffContext simulateCxt) {
        String selectFields = "account, currency, assgrp, amountbalfor, amountbal, bizdate, forwriteoffdate, localwriteoffdate";
        QFilter unAccFilter = new QFilter("org", "=", (Object)simulateCxt.getOrgId());
        unAccFilter.and(new QFilter("booktype", "=", (Object)simulateCxt.getBookTypeId()));
        unAccFilter.and(new QFilter("account", "in", simulateCxt.getAcctMasterIds()));
        unAccFilter.and(new QFilter("currency", "in", simulateCxt.getCurrencyIds()));
        unAccFilter.and(new QFilter("assgrp", "in", simulateCxt.getAssgrpIds()));
        unAccFilter.and(new QFilter(UnAcccurrent.ISORIGINPOINT, "=", (Object)"1"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FifoRealTimeWriteOffServiceImpl.class.getName(), (String)UnAcccurrent.ENTITY, (String)selectFields, (QFilter[])unAccFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long accassgrp = row.getLong("assgrp");
                if (!Objects.nonNull(accassgrp) || accassgrp <= 0L) continue;
                Long account = row.getLong("account");
                Long currency = row.getLong("currency");
                Date forWriteOffDate = row.getDate("forwriteoffdate");
                BaseKey baseKey = new BaseKey(account, currency);
                String lastAmtBalForDc = row.getBigDecimal("amountbalfor").compareTo(BigDecimal.ZERO) >= 0 ? "1" : "-1";
                OriginPoint originPointFor = simulateCxt.getUnAccOriPoint().computeIfAbsent(baseKey, x -> new HashMap(16)).computeIfAbsent(GroupKey.of(accassgrp, GroupKey.CurrencyType.FOR), y -> OriginPoint.of(forWriteOffDate, lastAmtBalForDc));
                if (!originPointFor.getBalDc().equals(lastAmtBalForDc)) {
                    originPointFor.setLastWriteOffDate(forWriteOffDate);
                    originPointFor.setBalDc("0");
                } else if (Objects.isNull(originPointFor.getLastWriteOffDate()) || originPointFor.getLastWriteOffDate().compareTo(forWriteOffDate) <= 0) {
                    originPointFor.setLastWriteOffDate(forWriteOffDate);
                }
                Date localWriteOffData = row.getDate("localwriteoffdate");
                String lastAmtBalDc = row.getBigDecimal("amountbal").compareTo(BigDecimal.ZERO) >= 0 ? "1" : "-1";
                OriginPoint originPointLocal = simulateCxt.getUnAccOriPoint().computeIfAbsent(baseKey, x -> new HashMap(16)).computeIfAbsent(GroupKey.of(accassgrp, GroupKey.CurrencyType.LOCAL), y -> OriginPoint.of(localWriteOffData, lastAmtBalDc));
                if (!originPointLocal.getBalDc().equals(lastAmtBalDc)) {
                    originPointLocal.setLastWriteOffDate(localWriteOffData);
                    originPointLocal.setBalDc("0");
                    continue;
                }
                if (!Objects.isNull(originPointLocal.getLastWriteOffDate()) && originPointLocal.getLastWriteOffDate().compareTo(localWriteOffData) > 0) continue;
                originPointLocal.setLastWriteOffDate(localWriteOffData);
            }
        }
    }

    protected String getBalAmtDc(Row row, String debitAmtField, String creditAmtField) {
        String amtDc;
        BigDecimal amt = row.getBigDecimal(debitAmtField);
        String string = amtDc = amt.compareTo(BigDecimal.ZERO) >= 0 ? "1" : "-1";
        if (amt.compareTo(BigDecimal.ZERO) == 0) {
            amt = row.getBigDecimal(creditAmtField);
            amtDc = amt.compareTo(BigDecimal.ZERO) >= 0 ? "-1" : "1";
        }
        return amtDc;
    }
}

