/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.voucher.mc;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.enums.ConversionMethod;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.CurrencyField;
import org.apache.commons.collections4.list.UnmodifiableList;

public class MulLocalConfig {
    public static Map<LocalCurrencyConfigVO, MulLocalConfig> FACTORY = new ConcurrentHashMap<LocalCurrencyConfigVO, MulLocalConfig>(4);
    private final LocalCurrencyConfigVO config;
    private final AmountField amountField;

    public static MulLocalConfig[] enabledConfigs() {
        UnmodifiableList configs = LocalCurrencyConfigService.queryEnableCurrencies();
        return (MulLocalConfig[])configs.stream().map(x -> FACTORY.computeIfAbsent((LocalCurrencyConfigVO)x, MulLocalConfig::new)).toArray(MulLocalConfig[]::new);
    }

    public static MulLocalConfig[] enabledConfigs(long orgId, long bookTypeId) {
        return (MulLocalConfig[])Arrays.stream(MulLocalConfig.enabledConfigs()).filter(x -> x.isEnabled(orgId, bookTypeId)).toArray(MulLocalConfig[]::new);
    }

    public static MulLocalConfig[] disabledConfigs(Long orgId, Long bookTypeId) {
        return (MulLocalConfig[])Arrays.stream(MulLocalConfig.enabledConfigs()).filter(x -> !x.isEnabled(orgId, bookTypeId)).toArray(MulLocalConfig[]::new);
    }

    public static AmountField[] getEnabledAmountFields() {
        return (AmountField[])Arrays.stream(MulLocalConfig.enabledConfigs()).map(MulLocalConfig::getAmountField).toArray(AmountField[]::new);
    }

    public static AmountField[] getEnabledLocalAmountFields(Long orgId, Long bookTpeId) {
        return (AmountField[])Arrays.stream(MulLocalConfig.enabledConfigs(orgId, bookTpeId)).map(MulLocalConfig::getAmountField).toArray(AmountField[]::new);
    }

    public static String[] getEnabledAmountFieldKeys() {
        return (String[])Arrays.stream(MulLocalConfig.enabledConfigs()).flatMap(x -> Stream.of(x.getDebitField(), x.getCreditField())).toArray(String[]::new);
    }

    public static String[] getEnabledCurrencyFieldKeys() {
        return (String[])Arrays.stream(MulLocalConfig.enabledConfigs()).map(MulLocalConfig::getCurrencyField).toArray(String[]::new);
    }

    public static String[] getEnabledEntryFieldKeys() {
        return (String[])Arrays.stream(MulLocalConfig.enabledConfigs()).flatMap(x -> Stream.of(x.getDebitField(), x.getCreditField(), x.getExRateField())).toArray(String[]::new);
    }

    MulLocalConfig(LocalCurrencyConfigVO config) {
        this.config = config;
        this.amountField = new AmountField(config.getVoucherField(MCT.DEBIT).getMetaId(), config.getVoucherField(MCT.CREDIT).getMetaId(), config.getVoucherField(MCT.EX_RATE).getMetaId(), new CurrencyField(config.getVoucherField(MCT.CURRENCY).getMetaId(), config.getName().toString()));
    }

    public LocalCurrencyConfigVO getConfig() {
        return this.config;
    }

    public AmountField getAmountField() {
        return this.amountField;
    }

    public String name() {
        return this.config.getNumber();
    }

    public String getCurrencyField() {
        return this.config.getVoucherField(MCT.CURRENCY).getMetaId();
    }

    public String getExRateField() {
        return this.config.getVoucherField(MCT.EX_RATE).getMetaId();
    }

    public String getExRateTypeField() {
        return this.config.getVoucherField(MCT.EX_RATE_TYPE).getMetaId();
    }

    public String getDebitField() {
        return this.config.getVoucherField(MCT.DEBIT).getMetaId();
    }

    public String getCreditField() {
        return this.config.getVoucherField(MCT.CREDIT).getMetaId();
    }

    public String getCurrencyDbId() {
        return this.config.getVoucherField(MCT.CURRENCY).getDbId();
    }

    public String getExRateDbId() {
        return this.config.getVoucherField(MCT.EX_RATE).getDbId();
    }

    public String getDebitDbId() {
        return this.config.getVoucherField(MCT.DEBIT).getDbId();
    }

    public String getCreditDbId() {
        return this.config.getVoucherField(MCT.CREDIT).getDbId();
    }

    public Long getExRateTableId(Long orgId, Long bookTypeId) {
        return this.config.getExRateTableId(orgId.longValue(), bookTypeId.longValue());
    }

    public boolean isEnabled(Long orgId, Long bookTypeId) {
        return this.config.getCurrencyId(orgId.longValue(), bookTypeId.longValue()) > 0L;
    }

    public long getCurrencyId(Long orgId, Long bookTypeId) {
        return this.config.getCurrencyId(orgId.longValue(), bookTypeId.longValue());
    }

    public boolean isUsingLocalCalcMulLocal(Long orgId, Long bookTypeId, String voucherSourceType) {
        if (!"GrpLocalCurrency".equalsIgnoreCase(this.name()) || "2".equalsIgnoreCase(voucherSourceType)) {
            return false;
        }
        return this.getConfig().getConversionMethod(orgId.longValue(), bookTypeId.longValue()) == ConversionMethod.BASE;
    }

    public String getLocalAmountField(String entryDC) {
        return "1".equalsIgnoreCase(entryDC) ? this.getDebitField() : this.getCreditField();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MulLocalConfig that = (MulLocalConfig)o;
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.config);
    }
}

