/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.voucher.mc.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.util.CollectionUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.business.dao.voucher.BufferedEntryReader;
import kd.fi.gl.business.dao.voucher.BufferedEntryWriter;
import kd.fi.gl.business.dao.voucher.VoucherEntryStoreReader;
import kd.fi.gl.business.dao.voucher.mc.MCEntryWriter;
import kd.fi.gl.business.service.voucher.mc.IMCEntryBuilder;
import kd.fi.gl.business.service.voucher.mc.IMulLocalEntryService;
import kd.fi.gl.business.service.voucher.mc.MCContext;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.service.voucher.mc.arg.VoucherEntries;
import kd.fi.gl.business.service.voucher.mc.arg.VoucherEntryIds;
import kd.fi.gl.business.vo.voucher.IVoucher;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucher;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherEntry;
import kd.fi.gl.business.vo.voucher.mc.MCVoucher;
import kd.fi.gl.business.vo.voucher.mc.MCVoucherEntry;

public class MulLocalEntryServiceImpl
implements IMulLocalEntryService {
    private static final int BUFFER_SIZE = 1000;

    @Override
    public void updateByEntryIds(List<VoucherEntryIds> vouchers) {
        if (CollectionUtils.isEmpty(vouchers)) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])MulLocalConfig.enabledConfigs())) {
            return;
        }
        ArrayList<VoucherEntryIds> enabledVouchers = new ArrayList<VoucherEntryIds>(vouchers.size());
        LinkedHashSet<Object> configs = new LinkedHashSet<Object>(2);
        for (VoucherEntryIds v : vouchers) {
            Object[] bookConfigs = MulLocalConfig.enabledConfigs(v.getVoucher().getOrgId(), v.getVoucher().getBookTypeId());
            if (ArrayUtils.isEmpty((Object[])bookConfigs)) continue;
            enabledVouchers.add(v);
            configs.addAll(Arrays.asList(bookConfigs));
        }
        if (CollectionUtils.isEmpty(enabledVouchers)) {
            return;
        }
        List<Long> allEntryIds = enabledVouchers.stream().flatMap(x -> x.getEntryIds().stream()).collect(Collectors.toList());
        MCEntryBuilder builder = new MCEntryBuilder();
        HintCondition idCondition = new HintCondition("fid", "in", enabledVouchers.stream().map(x -> x.getVoucher().getId()).collect(Collectors.toSet()));
        try (TXHandle tx = TX.required();
             ShardingHintContext ignore = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{idCondition}).prepareShardingIndex();
             BufferedEntryReader<IVoucherEntry> reader = new BufferedEntryReader<IVoucherEntry>(new VoucherEntryStoreReader(), allEntryIds, 1000);
             BufferedEntryWriter<IMCVoucherEntry> writer = new BufferedEntryWriter<IMCVoucherEntry>(new MCEntryWriter(configs.toArray(new MulLocalConfig[0])), 1000);){
            try {
                for (VoucherEntryIds voucher : enabledVouchers) {
                    builder.setVoucher(voucher.getVoucher());
                    for (Long entryId : voucher.getEntryIds()) {
                        writer.write(builder.build((IVoucherEntry)reader.read(entryId)));
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<VoucherEntries<IMCVoucherEntry>> updateByEntries(List<VoucherEntries<IVoucherEntry>> vouchers) {
        if (CollectionUtils.isEmpty(vouchers)) {
            return new ArrayList<VoucherEntries<IMCVoucherEntry>>(1);
        }
        Object[] configs = MulLocalConfig.enabledConfigs();
        if (ArrayUtils.isEmpty((Object[])configs)) {
            return new ArrayList<VoucherEntries<IMCVoucherEntry>>(1);
        }
        MCEntryBuilder builder = new MCEntryBuilder();
        ArrayList<VoucherEntries<IMCVoucherEntry>> results = new ArrayList<VoucherEntries<IMCVoucherEntry>>(vouchers.size());
        for (VoucherEntries<IVoucherEntry> voucher : vouchers) {
            if (ArrayUtils.isEmpty((Object[])MulLocalConfig.enabledConfigs(voucher.getVoucher().getOrgId(), voucher.getVoucher().getBookTypeId()))) continue;
            VoucherEntries result = new VoucherEntries();
            result.setVoucher(voucher.getVoucher());
            result.setEntries(new ArrayList(voucher.getEntries().size()));
            builder.setVoucher(voucher.getVoucher());
            for (IVoucherEntry entry : voucher.getEntries()) {
                result.getEntries().add(builder.build(entry));
            }
            results.add(result);
        }
        return results;
    }

    private static class MCExRateReader {
        private final MCContext<Long> cache = new MCContext();
        private final MCContext<Long> typeCache = new MCContext();
        private final MCContext<Long> precisionCache = new MCContext();

        private MCExRateReader() {
        }

        private void rebuildCache(MulLocalConfig[] configs, IMCVoucher voucher) {
            this.cache.clear();
            this.typeCache.clear();
            this.precisionCache.clear();
            for (MulLocalConfig config : configs) {
                Long mulLocalCurId = voucher.getMCLocalCurId(config);
                Long mulLocalExRateTableId = voucher.getMCExRateTableId(config);
                Date mulLocalExRateDate = voucher.getMCExRateDate(config);
                if (voucher.isUsingLocalCalcMulLocal(config)) {
                    long localCurId = voucher.getLocalCurId();
                    this.cache.put(config, localCurId, RateServiceHelper.getExchangeRate((Long)localCurId, (Long)mulLocalCurId, (Long)mulLocalExRateTableId, (Date)mulLocalExRateDate));
                    this.typeCache.put(config, localCurId, RateServiceHelper.getRateType((long)localCurId, (long)mulLocalCurId, (Date)mulLocalExRateDate));
                    this.precisionCache.put(config, localCurId, RateServiceHelper.getRatePrecision((Long)localCurId, (Long)mulLocalCurId, (Long)mulLocalExRateTableId, (Date)mulLocalExRateDate));
                    continue;
                }
                this.cache.putAll(config, RateServiceHelper.batchGetExchangeRate(null, (Long)mulLocalCurId, (Long)mulLocalExRateTableId, (Date)mulLocalExRateDate));
            }
        }

        private ExchangeRate read(MulLocalConfig config, IMCVoucherEntry entry) {
            return (ExchangeRate)this.cache.get(config, entry.getMCOriCurId(config));
        }

        private RateType readType(MulLocalConfig config, IMCVoucherEntry entry) {
            Long currencyId = entry.getMCOriCurId(config);
            RateType type = (RateType)this.typeCache.get(config, currencyId);
            if (type == null) {
                IMCVoucher voucher = entry.getVoucher();
                type = RateServiceHelper.getRateType((long)currencyId, (long)voucher.getMCLocalCurId(config), (Date)voucher.getMCExRateDate(config));
                this.typeCache.put(config, currencyId, type);
            }
            return type;
        }

        private Integer readPrecision(MulLocalConfig config, IMCVoucherEntry entry) {
            Long currencyId = entry.getMCOriCurId(config);
            Integer precision = (Integer)this.precisionCache.get(config, currencyId);
            if (precision == null) {
                IMCVoucher voucher = entry.getVoucher();
                precision = RateServiceHelper.getRatePrecision((Long)currencyId, (Long)voucher.getMCLocalCurId(config), (Long)voucher.getMCExRateTableId(config), (Date)voucher.getMCExRateDate(config));
                this.precisionCache.put(config, currencyId, precision);
            }
            return precision;
        }
    }

    private static class MCEntryBuilder
    implements IMCEntryBuilder {
        private MulLocalConfig[] configs;
        private IMCVoucher voucher;
        private final MCExRateReader exRateReader = new MCExRateReader();

        private MCEntryBuilder() {
        }

        @Override
        public void setVoucher(IVoucher voucher) {
            this.configs = MulLocalConfig.enabledConfigs(voucher.getOrgId(), voucher.getBookTypeId());
            this.voucher = new MCVoucher(voucher);
            this.exRateReader.rebuildCache(this.configs, this.voucher);
        }

        @Override
        public IMCVoucherEntry build(IVoucherEntry entry) {
            MCVoucherEntry entryWrap = new MCVoucherEntry(this.voucher, entry);
            for (MulLocalConfig config : this.configs) {
                RateType rateType;
                BigDecimal localAmount = entryWrap.getMCLocalAmount(config);
                BigDecimal exRate = entryWrap.getMCExRate(config);
                if (localAmount.signum() != 0 && exRate.signum() != 0) continue;
                if (localAmount.signum() == 0 && exRate.signum() == 0) {
                    ExchangeRate exchangeRate = this.exRateReader.read(config, entryWrap);
                    if (exchangeRate == null) continue;
                    exRate = exchangeRate.getValue();
                    IRateCalculator rateCalculator = exchangeRate.getRateType().getRateCalculator();
                    localAmount = rateCalculator.calLocAmount(exRate, entryWrap.getMCOriAmt(config), this.voucher.getMCLocalCurAmtPrecision(config));
                    entryWrap.setMCExRateType(config, exchangeRate.getRateType());
                    entryWrap.setMCExRate(config, exRate);
                    entryWrap.setMCLocalAmount(config, localAmount);
                    continue;
                }
                if (exRate.signum() == 0) {
                    rateType = this.exRateReader.readType(config, entryWrap);
                    Integer precision = this.exRateReader.readPrecision(config, entryWrap);
                    exRate = rateType.getRateCalculator().calRate(entryWrap.getMCOriAmt(config), localAmount, precision.intValue());
                    entryWrap.setMCExRateType(config, rateType);
                    entryWrap.setMCExRate(config, exRate);
                    continue;
                }
                rateType = this.exRateReader.readType(config, entryWrap);
                localAmount = rateType.getRateCalculator().calLocAmount(exRate, entryWrap.getMCOriAmt(config), this.voucher.getMCLocalCurAmtPrecision(config));
                entryWrap.setMCExRateType(config, rateType);
                entryWrap.setMCLocalAmount(config, localAmount);
            }
            return entryWrap;
        }
    }
}

