/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.voucher.option.cfg;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.business.service.voucher.option.key.CarryKey;

public class VoucherCarryConfig {
    private long orgId;
    private long userId;
    private boolean defaultConfig = false;
    private Map<CarryKey, Boolean> configMap;

    public VoucherCarryConfig() {
    }

    public VoucherCarryConfig(long orgId, long userId, Map<CarryKey, Boolean> configMap) {
        this.orgId = orgId;
        this.userId = userId;
        this.configMap = configMap;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public boolean isDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(boolean defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    protected Map<CarryKey, Boolean> getConfigMap() {
        return this.configMap;
    }

    public boolean isCarry(String voucherField) {
        return this.isCarry((CarryKey)CarryKey.tryGetKey(voucherField).orElse(null));
    }

    public boolean isCarry(CarryKey key) {
        if (key == null) {
            return false;
        }
        return this.getConfigMap().getOrDefault((Object)key, Boolean.FALSE);
    }

    public static VoucherCarryConfig fromDynamic(long orgId, long userId, DynamicObject dynamicConfig) {
        Map<CarryKey, Boolean> configMap = Arrays.stream(CarryKey.values()).collect(Collectors.toMap(x -> x, x -> dynamicConfig.getBoolean(x.name())));
        return new VoucherCarryConfig(orgId, userId, configMap);
    }
}

