/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.voucher.rel;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.business.service.voucher.rel.TrackerDirection;
import kd.fi.gl.interfaces.service.dap.IDAPService;
import kd.fi.gl.interfaces.service.voucher.rel.IVoucherRelationService;
import kd.fi.gl.util.iter.SplitIterator;

public class VoucherRelationServiceImpl
implements IVoucherRelationService {
    private static int getInThreshold() {
        return Math.min(1000, HugeInConfig.inThreshold());
    }

    private IDAPService getDAPService() {
        return GLServiceFactory.getService(IDAPService.class);
    }

    @Override
    public Map<String, Set<Long>> findDAPRelatedBills(Long voucherId) {
        if (voucherId == null || voucherId <= 0L) {
            return new LinkedHashMap<String, Set<Long>>(1);
        }
        BillToVchRelationDto voucherRelations = this.getDAPService().getBillToVchRelationDtoByVchIDSet(Sets.newHashSet((Object[])new Long[]{voucherId}));
        LinkedHashMap<String, Set<Long>> relatedBills = new LinkedHashMap<String, Set<Long>>(8);
        for (BillToVchRelationDto.BillToVoucherRelation relation : voucherRelations) {
            relatedBills.computeIfAbsent(relation.getBillType(), k -> new HashSet(16)).add(relation.getBillId());
        }
        return relatedBills;
    }

    @Override
    public Map<String, Map<Long, Set<Long>>> findDAPRelatedVouchers(Collection<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return new HashMap<String, Map<Long, Set<Long>>>(1);
        }
        ArrayList<DAPTrackerTask> tasks = new ArrayList<DAPTrackerTask>(10);
        SplitIterator<Long> splitIterator = new SplitIterator<Long>(billIds.iterator(), VoucherRelationServiceImpl.getInThreshold());
        while (splitIterator.hasNext()) {
            tasks.add(new DAPTrackerTask((Collection<Long>)splitIterator.next()));
        }
        try {
            HashMap<String, Map<Long, Set<Long>>> result = new HashMap<String, Map<Long, Set<Long>>>(4);
            TaskExecutor.execute(tasks, relatedVouchers -> relatedVouchers.forEach((entity, billId2Vouchers) -> result.merge((String)entity, (Map<Long, Set<Long>>)billId2Vouchers, (o, n) -> {
                o.putAll(n);
                return o;
            })));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Set<Long>> findBOTPSourceBills(Map<String, Set<Long>> bills) {
        return this.findBOTPRelatedBills(TrackerDirection.SOURCE, bills);
    }

    @Override
    public Map<String, Set<Long>> findBOTPTargetBills(Map<String, Set<Long>> bills) {
        return this.findBOTPRelatedBills(TrackerDirection.TARGET, bills);
    }

    protected Map<String, Set<Long>> findBOTPRelatedBills(TrackerDirection direction, Map<String, Set<Long>> bills) {
        if (direction == null || bills == null || bills.isEmpty()) {
            return new LinkedHashMap<String, Set<Long>>(1);
        }
        ArrayList<BFTrackerTask> tasks = new ArrayList<BFTrackerTask>(bills.size());
        for (Map.Entry<String, Set<Long>> entry : bills.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            SplitIterator<Long> splitIterator = new SplitIterator<Long>(entry.getValue().iterator(), VoucherRelationServiceImpl.getInThreshold());
            while (splitIterator.hasNext()) {
                tasks.add(new BFTrackerTask(entry.getKey(), (Collection<Long>)splitIterator.next(), direction));
            }
        }
        try {
            LinkedHashMap<String, Set<Long>> result = new LinkedHashMap<String, Set<Long>>(bills.size());
            TaskExecutor.execute(tasks, relatedBills -> relatedBills.forEach((entity, billIds) -> result.merge((String)entity, (Set<Long>)billIds, (o, n) -> {
                o.addAll(n);
                return o;
            })));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class TaskExecutor {
        private static final int threadThreshold = 2;

        TaskExecutor() {
        }

        static <V> void execute(List<? extends Callable<V>> tasks, Consumer<V> consumer) throws Exception {
            if (tasks.isEmpty()) {
                return;
            }
            if (tasks.size() <= 2) {
                for (Callable<V> task2 : tasks) {
                    consumer.accept(task2.call());
                }
            } else {
                List futures = tasks.stream().map(task -> ThreadService.submit((Callable)task, (TaskType)TaskType.GL_VOUCHER_RELATION_QUERY)).collect(Collectors.toList());
                for (Future future : futures) {
                    consumer.accept(future.get());
                }
            }
        }
    }

    static final class DAPTrackerTask
    implements Callable<Map<String, Map<Long, Set<Long>>>> {
        private final Collection<Long> billIds;

        DAPTrackerTask(Collection<Long> billIds) {
            this.billIds = billIds;
        }

        private IDAPService getDAPService() {
            return GLServiceFactory.getService(IDAPService.class);
        }

        @Override
        public Map<String, Map<Long, Set<Long>>> call() {
            if (CollectionUtils.isEmpty(this.billIds)) {
                return new HashMap<String, Map<Long, Set<Long>>>(1);
            }
            BillToVchRelationDto voucherRelations = this.getDAPService().getBillToVchReDtoByBillTypeAndIds(null, new HashSet<Long>(this.billIds));
            HashMap<String, Map<Long, Set<Long>>> result = new HashMap<String, Map<Long, Set<Long>>>(8);
            for (BillToVchRelationDto.BillToVoucherRelation relation : voucherRelations) {
                result.computeIfAbsent(relation.getBillType(), k -> new HashMap(16)).computeIfAbsent(relation.getBillId(), k -> new HashSet(16)).add(relation.getVoucherId());
            }
            return result;
        }
    }

    static final class BFTrackerTask
    implements Callable<Map<String, HashSet<Long>>> {
        private final String entity;
        private final Collection<Long> billIds;
        private final TrackerDirection direction;

        BFTrackerTask(String entity, Collection<Long> billIds, TrackerDirection direction) {
            this.entity = entity;
            this.billIds = billIds;
            this.direction = direction;
        }

        @Override
        public Map<String, HashSet<Long>> call() {
            if (StringUtils.isEmpty((String)this.entity) || CollectionUtils.isEmpty(this.billIds) || this.direction == null) {
                return new LinkedHashMap<String, HashSet<Long>>(1);
            }
            if (TrackerDirection.SOURCE == this.direction) {
                return BFTrackerServiceHelper.findSourceBills((String)this.entity, (Long[])this.billIds.toArray(new Long[0]));
            }
            if (TrackerDirection.TARGET == this.direction) {
                return BFTrackerServiceHelper.findTargetBills((String)this.entity, (Long[])this.billIds.toArray(new Long[0]));
            }
            return new LinkedHashMap<String, HashSet<Long>>(1);
        }
    }
}

