/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.voucher.writeoff;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.enums.WriteOffTypeEnum;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.voucher.IVoucherEntryPK;
import kd.fi.gl.voucher.map.EntryIdMapping;
import kd.fi.gl.voucher.map.EntrySeqMapping;
import kd.fi.gl.voucher.map.IEntryMapping;
import kd.fi.gl.voucher.map.IVoucherMapping;
import kd.fi.gl.voucher.vo.VoucherEntryPK;
import kd.fi.gl.voucher.vo.VoucherPK;
import kd.fi.gl.voucher.writeoff.DynamicWriteOffVoucher;
import kd.fi.gl.voucher.writeoff.WriteOffBalanceMap;
import kd.fi.gl.voucher.writeoff.WriteOffEntry;
import kd.fi.gl.voucher.writeoff.WriteOffVoucher;

public class WriteOffService {
    private static final VoucherSchema VOU_SCHEMA = VoucherSchema.instance;

    private static List<WriteOffVoucher> dynamicToWriteOffVoucher(List<DynamicObject> dynamicWriteOffVouchers) {
        return dynamicWriteOffVouchers.stream().map(x -> {
            WriteOffVoucher writeOffVoucher = new WriteOffVoucher((Long)x.getPkValue());
            writeOffVoucher.setSourceVoucher(new VoucherPK(x.getLong("sourcebill")));
            return writeOffVoucher;
        }).collect(Collectors.toList());
    }

    public static void delete(List<DynamicObject> dynamicWriteOffVouchers) {
        List<WriteOffVoucher> writeOffVouchers = WriteOffService.dynamicToWriteOffVoucher(dynamicWriteOffVouchers);
        RelationDAO.delete(writeOffVouchers);
        WriteOffService.updateSourceVoucherFlag(writeOffVouchers, false);
    }

    public static void submit(List<DynamicObject> dynamicWriteOffVouchers) {
        List<WriteOffVoucher> writeOffVouchers = WriteOffService.dynamicToWriteOffVoucher(dynamicWriteOffVouchers);
        WriteOffService.updateSourceVoucherFlag(writeOffVouchers, true);
    }

    public static void effective(List<DynamicObject> dynamicWriteOffVouchers) {
        List<WriteOffVoucher> writeOffVouchers = WriteOffService.dynamicToWriteOffVoucher(dynamicWriteOffVouchers);
        RelationDAO.effective(writeOffVouchers);
        WriteOffService.updateSourceVoucherFlag(writeOffVouchers, true);
    }

    public static void ineffective(List<DynamicObject> dynamicWriteOffVouchers) {
        List<WriteOffVoucher> writeOffVouchers = WriteOffService.dynamicToWriteOffVoucher(dynamicWriteOffVouchers);
        RelationDAO.ineffective(writeOffVouchers);
        WriteOffService.updateSourceVoucherFlag(writeOffVouchers, false);
    }

    private static void updateSourceVoucherFlag(List<WriteOffVoucher> writeOffVouchers, boolean flag) {
        Set<Long> sourceVoucherIds = writeOffVouchers.stream().map(IVoucherMapping::getSourceVoucherId).collect(Collectors.toSet());
        if (flag) {
            VoucherDAO.updateHasReverse(sourceVoucherIds, true);
        } else {
            Set<Long> reversedSourceIds = RelationDAO.getEffectiveReversedSourceIds(sourceVoucherIds);
            sourceVoucherIds.removeAll(reversedSourceIds);
            VoucherDAO.updateHasReverse(sourceVoucherIds, false);
        }
    }

    public static Map<Long, WriteOffBalanceMap> querySourceVoucherBalances(Collection<Long> sourceVoucherIds, QFilter[] customRelationFilters, AmountField ... amountFields) {
        Map<Long, WriteOffVoucher> writeOffVouchers = RelationDAO.queryWriteOffVouchers(sourceVoucherIds, customRelationFilters).stream().collect(Collectors.toMap(IVoucherMapping::getMappingVoucherId, x -> x, (o, n) -> n));
        Map<Long, WriteOffBalanceMap> result = sourceVoucherIds.stream().collect(Collectors.toMap(x -> x, x -> new WriteOffBalanceMap(), (o, n) -> n));
        HashSet<Long> voucherIds = new HashSet<Long>(writeOffVouchers.keySet());
        voucherIds.addAll(sourceVoucherIds);
        ArrayList props = Lists.newArrayList((Object[])new Prop[]{WriteOffService.VOU_SCHEMA.id, WriteOffService.VOU_SCHEMA.entryId, WriteOffService.VOU_SCHEMA.entrySeq, WriteOffService.VOU_SCHEMA.dc, WriteOffService.VOU_SCHEMA.qty, AmountField.LOCAL.getDebitProp(), AmountField.LOCAL.getCreditProp(), AmountField.ORIGINAL.getDebitProp(), AmountField.ORIGINAL.getCreditProp()});
        if (amountFields != null) {
            for (AmountField amountField : amountFields) {
                props.add(amountField.getDebitProp());
                props.add(amountField.getCreditProp());
            }
        }
        WriteOffEntry writeOffEntry = new WriteOffEntry();
        VoucherDAO.query(voucherIds, props.toArray(new Prop[0]), WriteOffService.VOU_SCHEMA.id.toFullName(), voucherRow -> {
            Long id = WriteOffService.VOU_SCHEMA.id.longOf(voucherRow);
            VoucherEntryPK voucherEntryPK = new VoucherEntryPK(WriteOffService.VOU_SCHEMA.entryId.longOf(voucherRow), WriteOffService.VOU_SCHEMA.entrySeq.integerOf(voucherRow));
            WriteOffVoucher writeOffVoucher = (WriteOffVoucher)writeOffVouchers.get(id);
            writeOffEntry.setDc(WriteOffService.VOU_SCHEMA.dc.stringOf(voucherRow));
            writeOffEntry.resetQuantity(WriteOffService.VOU_SCHEMA.qty.decimalOf(voucherRow));
            writeOffEntry.resetAmount(AmountField.LOCAL, AmountField.LOCAL.getDebitProp().decimalOf(voucherRow), AmountField.LOCAL.getCreditProp().decimalOf(voucherRow));
            writeOffEntry.resetAmount(AmountField.ORIGINAL, AmountField.ORIGINAL.getDebitProp().decimalOf(voucherRow), AmountField.ORIGINAL.getCreditProp().decimalOf(voucherRow));
            if (amountFields != null) {
                for (AmountField amountField : amountFields) {
                    writeOffEntry.resetAmount(amountField, amountField.getDebitProp().decimalOf(voucherRow), amountField.getCreditProp().decimalOf(voucherRow));
                }
            }
            if (writeOffVoucher != null) {
                ((WriteOffBalanceMap)result.get(writeOffVoucher.getSourceVoucher().getId())).get(writeOffVoucher.getEntryMapping().getSourceEntry(voucherEntryPK)).addWriteOffEntry(writeOffEntry);
            } else {
                ((WriteOffBalanceMap)result.get(id)).get(voucherEntryPK).setSourceEntry(writeOffEntry);
            }
            writeOffEntry.reset();
        });
        return result;
    }

    public static IEntryMapping<?, ?> buildEntryMapping(WriteOffVoucher writeOffVoucher) {
        return EntryMappingBuildStrategy.get(writeOffVoucher).build(writeOffVoucher);
    }

    public static void insertRelations(Collection<DynamicObject> dynamicWriteOffVouchers) {
        List<WriteOffVoucher> WriteOffVouchers = dynamicWriteOffVouchers.stream().map(x -> new DynamicWriteOffVoucher((DynamicObject)x)).collect(Collectors.toList());
        RelationDAO.insertRelations(WriteOffVouchers);
    }

    private static class VoucherDAO {
        private VoucherDAO() {
        }

        private static void query(Collection<Long> voucherIds, Prop[] props, String orderBys, Consumer<Row> rowHandler) {
            try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, voucherIds)});
                 DataSet voucherDataSet = QueryServiceHelper.queryDataSet((String)VoucherDAO.class.getName(), (String)"gl_voucher", (String)Prop.toSelectFieldStr((Prop[])props), (QFilter[])new QFilter("id", "in", voucherIds).toArray(), (String)orderBys);){
                for (Row row : voucherDataSet) {
                    rowHandler.accept(row);
                }
            }
        }

        private static void updateHasReverse(Set<Long> voucherIdSet, boolean reversed) {
            if (CollectionUtils.isEmpty(voucherIdSet)) {
                return;
            }
            try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, voucherIdSet)});){
                String sql = "UPDATE T_GL_VOUCHER SET FHASREVERSE = " + (reversed ? "'1'" : "'0'") + " WHERE FID IN ";
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)(sql + QFilterBuilder.buildSQLParamHolder((int)voucherIdSet.size())), (Object[])voucherIdSet.toArray());
            }
        }
    }

    private static class RelationDAO {
        private static final String GL_REVERSERELATION = "gl_reverserelation";
        private static final String SRCENTITY = "srcentity";
        private static final String TARGENTITY = "targentity";
        private static final String ISEFFECTIVE = "iseffective";
        private static final String AGAINSTTYPE = "againsttype";
        private static final String ENTRYENTITY = "entryentity";
        private static final String SOURCEENTRYID = "sourceentryid";
        private static final String MAPPINGENTRYID = "mappingentryid";
        private static final String RELATION_SELECT = "srcentity,targentity,againsttype,entryentity,entryentity.seq,entryentity.sourceentryid,entryentity.mappingentryid";

        private RelationDAO() {
        }

        protected static List<WriteOffVoucher> queryWriteOffVouchers(Collection<Long> sourceVoucherIds, QFilter[] customRelationFilters) {
            DynamicObject[] relations = RelationDAO.queryRelations(sourceVoucherIds, customRelationFilters);
            ArrayList<WriteOffVoucher> writeOffVouchers = new ArrayList<WriteOffVoucher>(relations.length);
            for (DynamicObject relation : relations) {
                WriteOffVoucher writeOffVoucher = new WriteOffVoucher(relation.getLong(TARGENTITY));
                writeOffVoucher.setSourceVoucher(new VoucherPK(relation.getLong(SRCENTITY)));
                writeOffVoucher.setWriteOffType(WriteOffTypeEnum.get(relation.getString(AGAINSTTYPE)));
                writeOffVoucher.setEntryMapping(RelationDAO.getEntryMappingOnRelation(relation));
                writeOffVouchers.add(writeOffVoucher);
            }
            return writeOffVouchers;
        }

        protected static IEntryMapping<? extends IVoucherEntryPK, ? extends IVoucherEntryPK> queryEntryMapping(WriteOffVoucher writeOffVoucher) {
            return RelationDAO.getEntryMappingOnRelation(RelationDAO.queryRelation(writeOffVoucher).orElse(null));
        }

        protected static EntryIdMapping updateToEntryIdMapping(WriteOffVoucher writeOffVoucher) {
            IEntryMapping<Object, Object> entryMapping = writeOffVoucher.getEntryMapping();
            if (entryMapping instanceof EntryIdMapping) {
                return (EntryIdMapping)entryMapping;
            }
            Optional<DynamicObject> relation = RelationDAO.queryRelation(writeOffVoucher);
            if (!relation.isPresent()) {
                throw new KDBizException(new ErrorCode("fi.gl.voucher.write_off_error", "Relation of source voucher %s and mapping voucher %s not exists. "), new Object[]{writeOffVoucher.getSourceVoucherId(), writeOffVoucher.getMappingVoucherId()});
            }
            DynamicObject dynamicRelation = relation.get();
            entryMapping = RelationDAO.getEntryMappingOnRelation(dynamicRelation);
            if (entryMapping instanceof EntryIdMapping) {
                return (EntryIdMapping)entryMapping;
            }
            LinkedHashMap entryMap = new LinkedHashMap(16);
            VoucherDAO.query(Arrays.asList(writeOffVoucher.getSourceVoucherId(), writeOffVoucher.getMappingVoucherId()), new Prop[]{VOU_SCHEMA.id, VOU_SCHEMA.entrySeq, VOU_SCHEMA.entryId}, VOU_SCHEMA.entrySeq.toFullName(), row -> {
                Long[] entryIdMapping = entryMap.computeIfAbsent(row.getInteger(1), k -> new Long[2]);
                Long entryId = row.getLong(2);
                if (Objects.equals(row.getLong(0), writeOffVoucher.getSourceVoucherId())) {
                    entryIdMapping[0] = entryId;
                } else {
                    entryIdMapping[1] = entryId;
                }
            });
            EntryIdMapping entryIdMapping = new EntryIdMapping(entryMap.values().stream().collect(Collectors.toMap(x -> x[0], x -> x[1], (o, n) -> n, LinkedHashMap::new)));
            DynamicObjectCollection collection = dynamicRelation.getDynamicObjectCollection(ENTRYENTITY);
            collection.clear();
            BiMap<Long, Long> mapping = entryIdMapping.getMapping();
            for (Map.Entry mappingEntry : mapping.entrySet()) {
                DynamicObject entry = collection.addNew();
                entry.set("seq", (Object)collection.size());
                entry.set(SOURCEENTRYID, mappingEntry.getKey());
                entry.set(MAPPINGENTRYID, mappingEntry.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicRelation});
            return entryIdMapping;
        }

        protected static void insertRelations(Collection<WriteOffVoucher> writeOffVouchers) {
            DynamicObject[] relations = (DynamicObject[])writeOffVouchers.stream().map(x -> {
                DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)GL_REVERSERELATION);
                relation.set(SRCENTITY, (Object)x.getSourceVoucherId());
                relation.set(TARGENTITY, (Object)x.getMappingVoucherId());
                relation.set(AGAINSTTYPE, (Object)x.getWriteOffType().getCode());
                relation.set(ISEFFECTIVE, (Object)true);
                IEntryMapping<?, ?> entryMapping = x.getEntryMapping();
                if (entryMapping instanceof EntryIdMapping) {
                    DynamicObjectCollection entries = relation.getDynamicObjectCollection(ENTRYENTITY);
                    BiMap<Long, Long> mapping = ((EntryIdMapping)entryMapping).getMapping();
                    for (Map.Entry mappingEntry : mapping.entrySet()) {
                        DynamicObject entry = entries.addNew();
                        entry.set("seq", (Object)entries.size());
                        entry.set(SOURCEENTRYID, mappingEntry.getKey());
                        entry.set(MAPPINGENTRYID, mappingEntry.getValue());
                    }
                }
                return relation;
            }).toArray(DynamicObject[]::new);
            SaveServiceHelper.save((DynamicObject[])relations);
        }

        protected static void delete(Collection<WriteOffVoucher> writeOffVouchers) {
            RelationDAO.whereMappingIdIn(writeOffVouchers, "DELETE FROM T_GL_REVERSERELATION");
        }

        protected static void ineffective(Collection<WriteOffVoucher> writeOffVouchers) {
            RelationDAO.whereMappingIdIn(writeOffVouchers, "UPDATE T_GL_REVERSERELATION SET FISEFFECTIVE = '0'");
        }

        protected static void effective(Collection<WriteOffVoucher> writeOffVouchers) {
            RelationDAO.whereMappingIdIn(writeOffVouchers, "UPDATE T_GL_REVERSERELATION SET FISEFFECTIVE = '1'");
        }

        protected static Set<Long> getEffectiveReversedSourceIds(Collection<Long> sourceVoucherIds) {
            HashSet<Long> result = new HashSet<Long>(sourceVoucherIds.size());
            try (DataSet relationDataSet = QueryServiceHelper.queryDataSet((String)RelationDAO.class.getName(), (String)GL_REVERSERELATION, (String)SRCENTITY, (QFilter[])new QFilter(SRCENTITY, "in", sourceVoucherIds).and(ISEFFECTIVE, "=", (Object)true).toArray(), null);){
                relationDataSet.forEachRemaining(x -> result.add(x.getLong(0)));
            }
            return result;
        }

        private static void whereMappingIdIn(Collection<WriteOffVoucher> writeOffVouchers, String sqlPrefix) {
            if (CollectionUtils.isEmpty(writeOffVouchers)) {
                return;
            }
            Object[] params = writeOffVouchers.stream().map(IVoucherMapping::getMappingVoucherId).distinct().toArray();
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)(sqlPrefix + " WHERE FTARGENTITYID IN " + QFilterBuilder.buildSQLParamHolder((int)params.length)), (Object[])params);
        }

        private static Optional<DynamicObject> queryRelation(WriteOffVoucher writeOffVoucher) {
            DynamicObject[] relations = RelationDAO.queryRelations(Collections.singletonList(writeOffVoucher.getSourceVoucherId()), new QFilter(TARGENTITY, "=", (Object)writeOffVoucher.getMappingVoucherId()).toArray());
            return Optional.ofNullable(relations.length > 0 ? relations[0] : null);
        }

        private static DynamicObject[] queryRelations(Collection<Long> sourceVoucherIds, QFilter[] customRelationFilters) {
            ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{new QFilter(SRCENTITY, "in", sourceVoucherIds), new QFilter(ISEFFECTIVE, "=", (Object)true)});
            if (ArrayUtils.isNotEmpty((Object[])customRelationFilters)) {
                filters.addAll(Lists.newArrayList((Object[])customRelationFilters));
            }
            return BusinessDataServiceHelper.load((String)GL_REVERSERELATION, (String)RELATION_SELECT, (QFilter[])filters.toArray(new QFilter[0]));
        }

        private static IEntryMapping<? extends IVoucherEntryPK, ? extends IVoucherEntryPK> getEntryMappingOnRelation(DynamicObject relation) {
            DynamicObjectCollection entryRelation;
            if (relation == null || CollectionUtils.isEmpty((Collection)(entryRelation = relation.getDynamicObjectCollection(ENTRYENTITY)))) {
                return new EntrySeqMapping();
            }
            return new EntryIdMapping(entryRelation.stream().collect(Collectors.toMap(x -> x.getLong(SOURCEENTRYID), x -> x.getLong(MAPPINGENTRYID), (o, n) -> n, LinkedHashMap::new)));
        }
    }

    private static enum EntryMappingBuildStrategy {
        WRITE_OFF_NEW(w -> new EntrySeqMapping()),
        WRITE_OFF_PARTIAL(w -> {
            DynamicWriteOffVoucher dynamicWriteOffVoucher = (DynamicWriteOffVoucher)w;
            DynamicProperty sourceEntryProp = dynamicWriteOffVoucher.getEntries().getDynamicObjectType().getProperty("writeoffsourceentryid");
            Map entryIdMapping = dynamicWriteOffVoucher.getEntries().stream().collect(Collectors.toMap(x -> (Long)sourceEntryProp.getValueFast(x), x -> (Long)x.getPkValue(), (o, n) -> n, LinkedHashMap::new));
            return new EntryIdMapping(entryIdMapping);
        }),
        QUERY_FROM_RELATION(RelationDAO::queryEntryMapping),
        UPDATE_RELATION_TO_ENTRY_ID_MAPPING(RelationDAO::updateToEntryIdMapping);

        private final Function<WriteOffVoucher, IEntryMapping<?, ?>> entryMappingBuilder;

        private EntryMappingBuildStrategy(Function<WriteOffVoucher, IEntryMapping<?, ?>> entryMappingBuilder) {
            this.entryMappingBuilder = entryMappingBuilder;
        }

        public IEntryMapping<?, ?> build(WriteOffVoucher writeOffVoucher) {
            return this.entryMappingBuilder.apply(writeOffVoucher);
        }

        private static EntryMappingBuildStrategy get(WriteOffVoucher writeOffVoucher) {
            if (writeOffVoucher instanceof DynamicWriteOffVoucher) {
                DynamicWriteOffVoucher dynamicWriteOffVoucher = (DynamicWriteOffVoucher)writeOffVoucher;
                DynamicProperty sourceEntryProp = dynamicWriteOffVoucher.getEntries().getDynamicObjectType().getProperty("writeoffsourceentryid");
                if (sourceEntryProp != null) {
                    return WRITE_OFF_PARTIAL;
                }
                DataEntityState dataEntityState = dynamicWriteOffVoucher.getVoucher().getDataEntityState();
                if (!dataEntityState.getFromDatabase()) {
                    return WRITE_OFF_NEW;
                }
                Set voucherEntryOidSet = dataEntityState.getPkSnapshotSet().Snapshots.stream().filter(pkSnapshot -> "t_gl_voucherentry".equalsIgnoreCase(pkSnapshot.TableName) && pkSnapshot.Oids != null).flatMap(pkSnapshot -> Arrays.stream(pkSnapshot.Oids)).collect(Collectors.toSet());
                voucherEntryOidSet.removeAll(dynamicWriteOffVoucher.getEntries().stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
                if (!voucherEntryOidSet.isEmpty()) {
                    return UPDATE_RELATION_TO_ENTRY_ID_MAPPING;
                }
                return QUERY_FROM_RELATION;
            }
            return QUERY_FROM_RELATION;
        }
    }
}

